/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.Range;
import org.eclipse.jpt.utility.internal.model.value.CollectionListValueModelAdapter;
import org.eclipse.jpt.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedListValueModelAdapter<E>
extends CollectionListValueModelAdapter<E> {
    protected Comparator<E> comparator;

    public SortedListValueModelAdapter(CollectionValueModel<? extends E> collectionHolder, Comparator<E> comparator) {
        super(collectionHolder);
        this.comparator = comparator;
    }

    public SortedListValueModelAdapter(CollectionValueModel<? extends E> collectionHolder) {
        this(collectionHolder, null);
    }

    public void setComparator(Comparator<E> comparator) {
        this.comparator = comparator;
        this.sortList();
    }

    @Override
    protected void buildList(int size) {
        super.buildList(size);
        Collections.sort(this.list, this.comparator);
    }

    @Override
    protected void itemsAdded(CollectionAddEvent event) {
        super.itemsAdded(event);
        this.sortList();
    }

    protected void sortList() {
        ArrayList unsortedList = (ArrayList)this.list.clone();
        Collections.sort(this.list, this.comparator);
        Range diffRange = CollectionTools.identityDiffRange(unsortedList, this.list);
        if (diffRange.size > 0) {
            List unsortedItems = unsortedList.subList(diffRange.start, diffRange.end + 1);
            List sortedItems = this.list.subList(diffRange.start, diffRange.end + 1);
            this.fireItemsReplaced("list values", diffRange.start, sortedItems, unsortedItems);
        }
    }
}

