/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.P2Utils;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;

public class LaunchConfigurationHelper {
    private static final String PROP_OSGI_FRAMEWORK = "osgi.framework";
    private static final String PROP_OSGI_BUNDLES = "osgi.bundles";
    private static final String PROP_P2_DATA_AREA = "eclipse.p2.data.area";
    private static final String DEFAULT_PROFILE_NAME = "SelfHostingProfile";
    private static final String DEFAULT_P2_DIRECTORY = ".p2";

    public static void synchronizeManifests(ILaunchConfiguration config, File configDir) {
        try {
            String programArgs = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "");
            if (programArgs.indexOf("-clean") != -1) {
                return;
            }
        }
        catch (CoreException coreException) {}
        File dir = new File(configDir, "org.eclipse.osgi/manifests");
        if (dir.exists() && dir.isDirectory()) {
            PDECore.getDefault().getJavaElementChangeListener().synchronizeManifests(dir);
        }
    }

    public static File getConfigurationArea(ILaunchConfiguration config) {
        File dir = LaunchConfigurationHelper.getConfigurationLocation(config);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static File getConfigurationLocation(ILaunchConfiguration config) {
        String configName = config.getName();
        configName = configName.replace('#', 'h');
        File dir = new File(PDECore.getDefault().getStateLocation().toOSString(), configName);
        try {
            String userPath;
            if (!config.getAttribute("useDefaultConfigArea", true) && (userPath = config.getAttribute("configLocation", null)) != null) {
                userPath = LaunchConfigurationHelper.getSubstitutedString(userPath);
                dir = new File(userPath).getAbsoluteFile();
            }
        }
        catch (CoreException coreException) {}
        return dir;
    }

    private static String getSubstitutedString(String text) throws CoreException {
        if (text == null) {
            return "";
        }
        IStringVariableManager mgr = VariablesPlugin.getDefault().getStringVariableManager();
        return mgr.performStringSubstitution(text);
    }

    public static Properties createConfigIniFile(ILaunchConfiguration configuration, String productID, Map bundles, Map bundlesWithStartLevels, File configurationDirectory) throws CoreException {
        Properties properties = null;
        if (configuration.getAttribute("useDefaultConfig", true)) {
            properties = TargetPlatformHelper.getConfigIniProperties();
            if (properties == null) {
                properties = new Properties();
            } else if (productID == null || !productID.equals(properties.get("eclipse.product"))) {
                properties.clear();
            }
            String bundleList = properties.getProperty(PROP_OSGI_BUNDLES);
            if (bundleList != null) {
                properties.setProperty(PROP_OSGI_BUNDLES, LaunchConfigurationHelper.computeOSGiBundles(TargetPlatformHelper.stripPathInformation((String)bundleList), bundles, bundlesWithStartLevels));
            }
        } else {
            String osgiBundles;
            String templateLoc = configuration.getAttribute("templateConfig", null);
            if (templateLoc != null && (osgiBundles = (properties = LaunchConfigurationHelper.loadFromTemplate(LaunchConfigurationHelper.getSubstitutedString(templateLoc))).getProperty(PROP_OSGI_BUNDLES)) != null) {
                properties.setProperty(PROP_OSGI_BUNDLES, TargetPlatformHelper.stripPathInformation((String)osgiBundles));
            }
        }
        if (properties != null) {
            LaunchConfigurationHelper.addRequiredProperties(properties, productID, bundles, bundlesWithStartLevels);
        } else {
            properties = new Properties();
        }
        if (!configurationDirectory.exists()) {
            configurationDirectory.mkdirs();
        }
        String osgiBundles = properties.getProperty(PROP_OSGI_BUNDLES);
        int start = configuration.getAttribute("default_start_level", 4);
        properties.put("osgi.bundles.defaultStartLevel", Integer.toString(start));
        boolean autostart = configuration.getAttribute("default_auto_start", false);
        if (osgiBundles != null && osgiBundles.indexOf("org.eclipse.equinox.simpleconfigurator") != -1 && bundles.containsKey("org.eclipse.equinox.simpleconfigurator")) {
            String startLevel;
            Object updateConfiguratorBundle = bundles.get("org.eclipse.update.configurator");
            if (updateConfiguratorBundle != null && (startLevel = (String)bundlesWithStartLevels.get(updateConfiguratorBundle)) != null && startLevel.equals("3:true")) {
                bundlesWithStartLevels.put(updateConfiguratorBundle, "4:false");
            }
            URL bundlesTxt = null;
            boolean usedefault = configuration.getAttribute("default", true);
            boolean useFeatures = configuration.getAttribute("usefeatures", false);
            bundlesTxt = usedefault || useFeatures ? P2Utils.writeBundlesTxt((Map)bundlesWithStartLevels, (int)4, (boolean)false, (File)configurationDirectory, (String)osgiBundles) : P2Utils.writeBundlesTxt((Map)bundlesWithStartLevels, (int)start, (boolean)autostart, (File)configurationDirectory, null);
            if (bundlesTxt != null) {
                properties.setProperty("org.eclipse.equinox.simpleconfigurator.configUrl", bundlesTxt.toString());
                if (bundles.get("org.eclipse.update.configurator") != null) {
                    properties.setProperty("org.eclipse.update.reconcile", "false");
                }
            }
            properties.setProperty(PROP_P2_DATA_AREA, "@config.dir/".concat(DEFAULT_P2_DIRECTORY));
            if (configuration.getAttribute("generateProfile", false)) {
                String profileID = DEFAULT_PROFILE_NAME;
                File p2DataArea = new File(configurationDirectory, DEFAULT_P2_DIRECTORY);
                if (!configuration.getAttribute("restart", false) || !P2Utils.profileExists((String)profileID, (File)p2DataArea)) {
                    P2Utils.createProfile((String)profileID, (File)p2DataArea, bundles.values());
                }
                properties.setProperty("eclipse.p2.profile", profileID);
            }
        }
        LaunchConfigurationHelper.setBundleLocations(bundles, properties, autostart);
        LaunchConfigurationHelper.save(new File(configurationDirectory, "config.ini"), properties);
        return properties;
    }

    private static void addRequiredProperties(Properties properties, String productID, Map bundles, Map bundlesWithStartLevels) {
        if (!properties.containsKey("osgi.install.area")) {
            properties.setProperty("osgi.install.area", "file:" + TargetPlatform.getLocation());
        }
        if (!properties.containsKey("osgi.configuration.cascaded")) {
            properties.setProperty("osgi.configuration.cascaded", "false");
        }
        if (!properties.containsKey(PROP_OSGI_FRAMEWORK)) {
            properties.setProperty(PROP_OSGI_FRAMEWORK, "org.eclipse.osgi");
        }
        if (!properties.containsKey("osgi.splashPath") && productID != null) {
            LaunchConfigurationHelper.addSplashLocation(properties, productID, bundles);
        }
        if (properties.containsKey("osgi.splashPath")) {
            LaunchConfigurationHelper.resolveLocationPath(properties.getProperty("osgi.splashPath"), properties, bundles);
        }
        if (!properties.containsKey(PROP_OSGI_BUNDLES)) {
            properties.setProperty(PROP_OSGI_BUNDLES, LaunchConfigurationHelper.computeOSGiBundles(TargetPlatform.getBundleList(), bundles, bundlesWithStartLevels));
        }
        if (!properties.containsKey("osgi.bundles.defaultStartLevel")) {
            properties.setProperty("osgi.bundles.defaultStartLevel", "4");
        }
    }

    private static String computeOSGiBundles(String bundleList, Map bundles, Map bundlesWithStartLevels) {
        String id;
        if (bundles.get("org.eclipse.equinox.simpleconfigurator") != null) {
            return "org.eclipse.equinox.simpleconfigurator@1:start";
        }
        StringBuffer buffer = new StringBuffer();
        HashSet<String> initialBundleSet = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(bundleList, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int index = token.indexOf(64);
            String string = id = index != -1 ? token.substring(0, index) : token;
            if (!bundles.containsKey(id)) continue;
            if (buffer.length() > 0) {
                buffer.append(',');
            }
            buffer.append(id);
            if (index != -1 && index < token.length() - 1) {
                buffer.append(token.substring(index));
            }
            initialBundleSet.add(id);
        }
        if (!initialBundleSet.contains("org.eclipse.update.configurator")) {
            initialBundleSet.add("org.eclipse.osgi");
            Iterator iter = bundlesWithStartLevels.keySet().iterator();
            while (iter.hasNext()) {
                IPluginModelBase model = (IPluginModelBase)iter.next();
                id = model.getPluginBase().getId();
                if (initialBundleSet.contains(id)) continue;
                if (buffer.length() > 0) {
                    buffer.append(',');
                }
                String slinfo = (String)bundlesWithStartLevels.get(model);
                buffer.append(id);
                buffer.append('@');
                buffer.append(slinfo);
            }
        }
        return buffer.toString();
    }

    private static Properties loadFromTemplate(String templateLoc) throws CoreException {
        Properties properties;
        block16: {
            properties = new Properties();
            File templateFile = new File(templateLoc);
            if (templateFile.exists() && templateFile.isFile()) {
                FileInputStream stream = null;
                try {
                    try {
                        stream = new FileInputStream(templateFile);
                        properties.load(stream);
                    }
                    catch (Exception e) {
                        String message = e.getMessage();
                        if (message != null) {
                            throw new CoreException((IStatus)new Status(4, PDELaunchingPlugin.getPluginId(), 4, message, (Throwable)e));
                        }
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return properties;
    }

    private static void addSplashLocation(Properties properties, String productID, Map map) {
        String targetSplash;
        Properties targetConfig = TargetPlatformHelper.getConfigIniProperties();
        String targetProduct = targetConfig == null ? null : targetConfig.getProperty("eclipse.product");
        String string = targetSplash = targetConfig == null ? null : targetConfig.getProperty("osgi.splashPath");
        if (!productID.equals(targetProduct) || targetSplash == null) {
            BundleDescription desc;
            ArrayList<String> locations = new ArrayList<String>();
            String plugin = LaunchConfigurationHelper.getContributingPlugin(productID);
            locations.add(plugin);
            IPluginModelBase model = (IPluginModelBase)map.get(plugin);
            if (model != null && (desc = model.getBundleDescription()) != null) {
                BundleDescription[] fragments = desc.getFragments();
                int i = 0;
                while (i < fragments.length) {
                    locations.add(fragments[i].getSymbolicName());
                    ++i;
                }
            }
            LaunchConfigurationHelper.resolveLocationPath(locations, properties, map);
        } else {
            LaunchConfigurationHelper.resolveLocationPath(targetSplash, properties, map);
        }
    }

    private static void resolveLocationPath(String splashPath, Properties properties, Map map) {
        ArrayList<String> locations = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(splashPath, ",");
        while (tok.hasMoreTokens()) {
            locations.add(tok.nextToken());
        }
        LaunchConfigurationHelper.resolveLocationPath(locations, properties, map);
    }

    private static void resolveLocationPath(ArrayList locations, Properties properties, Map map) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < locations.size()) {
            String url;
            String location = (String)locations.get(i);
            if (location.startsWith("platform:/base/plugins/")) {
                location = location.replaceFirst("platform:/base/plugins/", "");
            }
            if ((url = LaunchConfigurationHelper.getBundleURL(location, map, false)) != null) {
                if (buffer.length() > 0) {
                    buffer.append(",");
                }
                buffer.append(url);
            }
            ++i;
        }
        if (buffer.length() > 0) {
            properties.setProperty("osgi.splashPath", buffer.toString());
        }
    }

    public static String getBundleURL(String id, Map pluginMap, boolean includeReference) {
        IPluginModelBase model = (IPluginModelBase)pluginMap.get(id.trim());
        return LaunchConfigurationHelper.getBundleURL(model, includeReference);
    }

    public static String getBundleURL(IPluginModelBase model, boolean includeReference) {
        if (model == null || model.getInstallLocation() == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        if (includeReference) {
            buf.append("reference:");
        }
        buf.append("file:");
        buf.append(new Path(model.getInstallLocation()).removeTrailingSeparator().toString());
        return buf.toString();
    }

    private static void setBundleLocations(Map map, Properties properties, boolean defaultAuto) {
        String bundles;
        String url;
        String framework = properties.getProperty(PROP_OSGI_FRAMEWORK);
        if (framework != null && (url = LaunchConfigurationHelper.getBundleURL(framework = TargetPlatformHelper.stripPathInformation((String)framework), map, false)) != null) {
            properties.setProperty(PROP_OSGI_FRAMEWORK, url);
        }
        if ((bundles = properties.getProperty(PROP_OSGI_BUNDLES)) != null) {
            StringBuffer buffer = new StringBuffer();
            StringTokenizer tokenizer = new StringTokenizer(bundles, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                String url2 = LaunchConfigurationHelper.getBundleURL(token, map, false);
                int i = -1;
                if (url2 == null) {
                    i = token.indexOf(64);
                    if (i != -1) {
                        url2 = LaunchConfigurationHelper.getBundleURL(token.substring(0, i), map, false);
                    }
                    if (url2 == null && (i = token.indexOf(58)) != -1) {
                        url2 = LaunchConfigurationHelper.getBundleURL(token.substring(0, i), map, false);
                    }
                }
                if (url2 == null) continue;
                if (buffer.length() > 0) {
                    buffer.append(",");
                }
                buffer.append("reference:" + url2);
                if (i == -1) continue;
                String slinfo = token.substring(i + 1);
                buffer.append(LaunchConfigurationHelper.getStartData(slinfo, defaultAuto));
            }
            properties.setProperty(PROP_OSGI_BUNDLES, buffer.toString());
        }
    }

    public static String getStartData(String startData, boolean defaultAuto) {
        StringBuffer buffer = new StringBuffer();
        int index = startData.indexOf(58);
        String level = index > 0 ? startData.substring(0, index) : "default";
        String auto = startData;
        if (!startData.equals("start")) {
            String string = auto = index >= 0 && index < startData.length() - 1 ? startData.substring(index + 1) : "default";
        }
        if ("default".equals(auto)) {
            auto = Boolean.toString(defaultAuto);
        }
        if (!level.equals("default") || "true".equals(auto) || "start".equals(auto)) {
            buffer.append("@");
        }
        if (!level.equals("default")) {
            buffer.append(level);
            if ("start".equals(auto) || "true".equals(auto)) {
                buffer.append(":");
            }
        }
        if ("start".equals(auto) || "true".equals(auto)) {
            buffer.append("start");
        }
        return buffer.toString();
    }

    public static void save(File file, Properties properties) {
        try {
            FileOutputStream stream = new FileOutputStream(file);
            properties.store(stream, "Configuration File");
            stream.flush();
            stream.close();
        }
        catch (IOException e) {
            PDECore.logException((Throwable)e);
        }
    }

    public static String getContributingPlugin(String productID) {
        if (productID == null) {
            return null;
        }
        int index = productID.lastIndexOf(46);
        return index == -1 ? productID : productID.substring(0, index);
    }

    public static String getProductID(ILaunchConfiguration configuration) throws CoreException {
        if (configuration.getAttribute("useProduct", false)) {
            return configuration.getAttribute("product", null);
        }
        String appID = configuration.getAttribute("application", TargetPlatform.getDefaultApplication());
        IExtension[] extensions = PDECore.getDefault().getExtensionsRegistry().findExtensions("org.eclipse.core.runtime.products", true);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] children;
            String id = extensions[i].getUniqueIdentifier();
            if (id != null && (children = extensions[i].getConfigurationElements()).length == 1 && "product".equals(children[0].getName()) && appID.equals(children[0].getAttribute("application"))) {
                return id;
            }
            ++i;
        }
        return null;
    }
}

