/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.pde.core.plugin.IExtensions;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.IEditingModel;
import org.eclipse.pde.internal.core.text.plugin.PluginModel;
import org.eclipse.pde.internal.ui.editor.AbstractFoldingStructureProvider;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;

public class PluginFoldingStructureProvider
extends AbstractFoldingStructureProvider {
    private Map fPositionToElement = new HashMap();

    public PluginFoldingStructureProvider(PDESourcePage editor, IEditingModel model) {
        super(editor, model);
    }

    public void addFoldingRegions(Set currentRegions, IEditingModel model) throws BadLocationException {
        IExtensions extensions = ((PluginModel)model).getExtensions();
        IPluginExtension[] pluginExtensions = extensions.getExtensions();
        this.addFoldingRegions(currentRegions, pluginExtensions, model.getDocument());
    }

    private void addFoldingRegions(Set regions, IPluginExtension[] nodes, IDocument document) throws BadLocationException {
        int i = 0;
        while (i < nodes.length) {
            IDocumentElementNode[] children;
            int endLine;
            IDocumentElementNode element = (IDocumentElementNode)nodes[i];
            int startLine = document.getLineOfOffset(element.getOffset());
            if (startLine < (endLine = document.getLineOfOffset(element.getOffset() + element.getLength()))) {
                int start = document.getLineOffset(startLine);
                int end = document.getLineOffset(endLine) + document.getLineLength(endLine);
                Position position = new Position(start, end - start);
                regions.add(position);
                this.fPositionToElement.put(position, element);
            }
            if ((children = element.getChildNodes()) != null) {
                this.addFoldingRegions(regions, children, document);
            }
            ++i;
        }
    }

    private void addFoldingRegions(Set regions, IDocumentElementNode[] nodes, IDocument document) throws BadLocationException {
        int i = 0;
        while (i < nodes.length) {
            IDocumentElementNode[] children;
            int endLine;
            IDocumentElementNode element = nodes[i];
            int startLine = document.getLineOfOffset(element.getOffset());
            if (startLine < (endLine = document.getLineOfOffset(element.getOffset() + element.getLength()))) {
                int start = document.getLineOffset(startLine);
                int end = document.getLineOffset(endLine) + document.getLineLength(endLine);
                Position position = new Position(start, end - start);
                regions.add(position);
                this.fPositionToElement.put(position, element);
            }
            if ((children = element.getChildNodes()) != null) {
                this.addFoldingRegions(regions, children, document);
            }
            ++i;
        }
    }
}

