/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.orm;

import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.core.jpa2.context.CacheableHolder2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmCacheable2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmCacheableHolder2_0;
import org.eclipse.jpt.core.jpa2.context.persistence.PersistenceUnit2_0;
import org.eclipse.jpt.core.resource.orm.v2_0.XmlCacheable_2_0;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkCacheCoordinationType;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkCacheType;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkExistenceType;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkExpiryTimeOfDay;
import org.eclipse.jpt.eclipselink.core.context.java.JavaEclipseLinkCaching;
import org.eclipse.jpt.eclipselink.core.context.orm.OrmEclipseLinkCaching;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.OrmEclipseLinkExpiryTimeOfDay;
import org.eclipse.jpt.eclipselink.core.resource.orm.EclipseLinkOrmFactory;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlCache;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlCacheHolder;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlTimeOfDay;

public class OrmEclipseLinkCachingImpl
extends AbstractOrmXmlContextNode
implements OrmEclipseLinkCaching,
OrmCacheableHolder2_0 {
    protected final XmlCacheHolder resource;
    protected int defaultSize;
    protected Integer specifiedSize;
    protected boolean defaultShared;
    protected Boolean specifiedShared;
    protected EclipseLinkCacheType defaultType;
    protected EclipseLinkCacheType specifiedType;
    protected boolean defaultAlwaysRefresh;
    protected Boolean specifiedAlwaysRefresh;
    protected boolean defaultRefreshOnlyIfNewer;
    protected Boolean specifiedRefreshOnlyIfNewer;
    protected boolean defaultDisableHits;
    protected Boolean specifiedDisableHits;
    protected EclipseLinkCacheCoordinationType defaultCoordinationType;
    protected EclipseLinkCacheCoordinationType specifiedCoordinationType;
    protected EclipseLinkExistenceType specifiedExistenceType;
    protected EclipseLinkExistenceType defaultExistenceType;
    protected Integer expiry;
    protected OrmEclipseLinkExpiryTimeOfDay expiryTimeOfDay;
    protected final OrmCacheable2_0 cacheable;

    public OrmEclipseLinkCachingImpl(OrmTypeMapping parent, XmlCacheHolder resource, XmlCacheable_2_0 cacheableResource, JavaEclipseLinkCaching javaCaching) {
        super((JpaContextNode)parent);
        this.resource = resource;
        XmlCache resourceCache = this.getResourceCache();
        this.defaultSize = this.defaultSize(javaCaching);
        this.specifiedSize = this.getResourceSize(resourceCache);
        this.defaultShared = this.defaultShared(javaCaching);
        this.specifiedShared = this.getResourceShared(resourceCache);
        this.defaultAlwaysRefresh = this.defaultAlwaysRefresh(javaCaching);
        this.specifiedAlwaysRefresh = this.getResourceAlwaysRefresh(resourceCache);
        this.defaultRefreshOnlyIfNewer = this.defaultRefreshOnlyIfNewer(javaCaching);
        this.specifiedRefreshOnlyIfNewer = this.getResourceRefreshOnlyIfNewer(resourceCache);
        this.defaultDisableHits = this.defaultDisableHits(javaCaching);
        this.specifiedDisableHits = this.getResourceDisableHits(resourceCache);
        this.defaultType = this.defaultType(javaCaching);
        this.specifiedType = this.getResourceType(resourceCache);
        this.defaultCoordinationType = this.defaultCoordinationType(javaCaching);
        this.specifiedCoordinationType = this.getResourceCoordinationType(resourceCache);
        this.defaultExistenceType = this.defaultExistenceType(javaCaching);
        this.specifiedExistenceType = this.getResourceExistenceChecking();
        this.initializeExpiry(resourceCache);
        this.cacheable = this.getXmlContextNodeFactory().buildOrmCacheable((OrmCacheableHolder2_0)this, cacheableResource);
    }

    public OrmTypeMapping getParent() {
        return (OrmTypeMapping)super.getParent();
    }

    public int getSize() {
        return this.specifiedSize == null ? this.defaultSize : this.specifiedSize;
    }

    public int getDefaultSize() {
        return this.defaultSize;
    }

    protected void setDefaultSize(int newSize) {
        int oldSize = this.defaultSize;
        this.defaultSize = newSize;
        this.firePropertyChanged("defaultSize", oldSize, newSize);
    }

    public Integer getSpecifiedSize() {
        return this.specifiedSize;
    }

    public void setSpecifiedSize(Integer newSpecifiedSize) {
        Integer oldSpecifiedSize = this.specifiedSize;
        this.specifiedSize = newSpecifiedSize;
        if (oldSpecifiedSize != newSpecifiedSize) {
            if (this.getResourceCache() != null) {
                this.getResourceCache().setSize(newSpecifiedSize);
                if (this.getResourceCache().isUnset()) {
                    this.removeResourceCache();
                }
            } else if (newSpecifiedSize != null) {
                this.addResourceCache();
                this.getResourceCache().setSize(newSpecifiedSize);
            }
        }
        this.firePropertyChanged("specifiedSize", oldSpecifiedSize, newSpecifiedSize);
    }

    protected void setSpecifiedSize_(Integer newSpecifiedSize) {
        Integer oldSpecifiedSize = this.specifiedSize;
        this.specifiedSize = newSpecifiedSize;
        this.firePropertyChanged("specifiedSize", oldSpecifiedSize, newSpecifiedSize);
    }

    public boolean isShared() {
        return this.specifiedShared == null ? this.defaultShared : this.specifiedShared;
    }

    public boolean isDefaultShared() {
        return this.defaultShared;
    }

    protected void setDefaultShared(boolean newDefaultShared) {
        boolean oldDefaultShared = this.defaultShared;
        this.defaultShared = newDefaultShared;
        this.firePropertyChanged("defaultShared", oldDefaultShared, newDefaultShared);
    }

    public Boolean getSpecifiedShared() {
        return this.specifiedShared;
    }

    public void setSpecifiedShared(Boolean newSpecifiedShared) {
        Boolean oldSpecifiedShared = this.specifiedShared;
        this.specifiedShared = newSpecifiedShared;
        if (oldSpecifiedShared != newSpecifiedShared) {
            if (this.getResourceCache() != null) {
                this.getResourceCache().setShared(newSpecifiedShared);
                if (this.getResourceCache().isUnset()) {
                    this.removeResourceCache();
                }
            } else if (newSpecifiedShared != null) {
                this.addResourceCache();
                this.getResourceCache().setShared(newSpecifiedShared);
            }
        }
        this.firePropertyChanged("specifiedShared", oldSpecifiedShared, newSpecifiedShared);
        if (newSpecifiedShared == Boolean.FALSE) {
            this.setSpecifiedType(null);
            this.setSpecifiedSize(null);
            this.setSpecifiedAlwaysRefresh(null);
            this.setSpecifiedRefreshOnlyIfNewer(null);
            this.setSpecifiedDisableHits(null);
            this.setSpecifiedCoordinationType(null);
            this.setExpiry(null);
            if (this.expiryTimeOfDay != null) {
                this.removeExpiryTimeOfDay();
            }
        }
    }

    protected void setSpecifiedShared_(Boolean newSpecifiedShared) {
        Boolean oldSpecifiedShared = this.specifiedShared;
        this.specifiedShared = newSpecifiedShared;
        this.firePropertyChanged("specifiedShared", oldSpecifiedShared, newSpecifiedShared);
    }

    public boolean isAlwaysRefresh() {
        return this.specifiedAlwaysRefresh == null ? this.defaultAlwaysRefresh : this.specifiedAlwaysRefresh;
    }

    public boolean isDefaultAlwaysRefresh() {
        return this.defaultAlwaysRefresh;
    }

    protected void setDefaultAlwaysRefresh(boolean newDefaultAlwaysRefresh) {
        boolean oldDefaultAlwaysRefresh = this.defaultAlwaysRefresh;
        this.defaultAlwaysRefresh = newDefaultAlwaysRefresh;
        this.firePropertyChanged("defaultAlwaysRefresh", oldDefaultAlwaysRefresh, newDefaultAlwaysRefresh);
    }

    public Boolean getSpecifiedAlwaysRefresh() {
        return this.specifiedAlwaysRefresh;
    }

    public void setSpecifiedAlwaysRefresh(Boolean newSpecifiedAlwaysRefresh) {
        Boolean oldSpecifiedAlwaysRefresh = this.specifiedAlwaysRefresh;
        this.specifiedAlwaysRefresh = newSpecifiedAlwaysRefresh;
        if (oldSpecifiedAlwaysRefresh != newSpecifiedAlwaysRefresh) {
            if (this.getResourceCache() != null) {
                this.getResourceCache().setAlwaysRefresh(newSpecifiedAlwaysRefresh);
                if (this.getResourceCache().isUnset()) {
                    this.removeResourceCache();
                }
            } else if (newSpecifiedAlwaysRefresh != null) {
                this.addResourceCache();
                this.getResourceCache().setAlwaysRefresh(newSpecifiedAlwaysRefresh);
            }
        }
        this.firePropertyChanged("specifiedAlwaysRefresh", oldSpecifiedAlwaysRefresh, newSpecifiedAlwaysRefresh);
    }

    protected void setSpecifiedAlwaysRefresh_(Boolean newSpecifiedAlwaysRefresh) {
        Boolean oldSpecifiedAlwaysRefresh = this.specifiedAlwaysRefresh;
        this.specifiedAlwaysRefresh = newSpecifiedAlwaysRefresh;
        this.firePropertyChanged("specifiedAlwaysRefresh", oldSpecifiedAlwaysRefresh, newSpecifiedAlwaysRefresh);
    }

    public boolean isRefreshOnlyIfNewer() {
        return this.specifiedRefreshOnlyIfNewer == null ? this.defaultRefreshOnlyIfNewer : this.specifiedRefreshOnlyIfNewer;
    }

    public boolean isDefaultRefreshOnlyIfNewer() {
        return this.defaultRefreshOnlyIfNewer;
    }

    protected void setDefaultRefreshOnlyIfNewer(boolean newDefaultRefreshOnlyIfNewer) {
        boolean oldDefaultRefreshOnlyIfNewer = this.defaultRefreshOnlyIfNewer;
        this.defaultRefreshOnlyIfNewer = newDefaultRefreshOnlyIfNewer;
        this.firePropertyChanged("defaultRefreshOnlyIfNewer", oldDefaultRefreshOnlyIfNewer, newDefaultRefreshOnlyIfNewer);
    }

    public Boolean getSpecifiedRefreshOnlyIfNewer() {
        return this.specifiedRefreshOnlyIfNewer;
    }

    public void setSpecifiedRefreshOnlyIfNewer(Boolean newSpecifiedRefreshOnlyIfNewer) {
        Boolean oldSpecifiedRefreshOnlyIfNewer = this.specifiedRefreshOnlyIfNewer;
        this.specifiedRefreshOnlyIfNewer = newSpecifiedRefreshOnlyIfNewer;
        if (oldSpecifiedRefreshOnlyIfNewer != newSpecifiedRefreshOnlyIfNewer) {
            if (this.getResourceCache() != null) {
                this.getResourceCache().setRefreshOnlyIfNewer(newSpecifiedRefreshOnlyIfNewer);
                if (this.getResourceCache().isUnset()) {
                    this.removeResourceCache();
                }
            } else if (newSpecifiedRefreshOnlyIfNewer != null) {
                this.addResourceCache();
                this.getResourceCache().setRefreshOnlyIfNewer(newSpecifiedRefreshOnlyIfNewer);
            }
        }
        this.firePropertyChanged("specifiedRefreshOnlyIfNewer", oldSpecifiedRefreshOnlyIfNewer, newSpecifiedRefreshOnlyIfNewer);
    }

    protected void setSpecifiedRefreshOnlyIfNewer_(Boolean newSpecifiedRefreshOnlyIfNewer) {
        Boolean oldSpecifiedRefreshOnlyIfNewer = this.specifiedRefreshOnlyIfNewer;
        this.specifiedRefreshOnlyIfNewer = newSpecifiedRefreshOnlyIfNewer;
        this.firePropertyChanged("specifiedRefreshOnlyIfNewer", oldSpecifiedRefreshOnlyIfNewer, newSpecifiedRefreshOnlyIfNewer);
    }

    public boolean isDisableHits() {
        return this.specifiedDisableHits == null ? this.defaultDisableHits : this.specifiedDisableHits;
    }

    public boolean isDefaultDisableHits() {
        return this.defaultDisableHits;
    }

    protected void setDefaultDisableHits(boolean newDefaultDisableHits) {
        boolean oldDefaultDisableHits = this.defaultDisableHits;
        this.defaultDisableHits = newDefaultDisableHits;
        this.firePropertyChanged("defaultDisableHits", oldDefaultDisableHits, newDefaultDisableHits);
    }

    public Boolean getSpecifiedDisableHits() {
        return this.specifiedDisableHits;
    }

    public void setSpecifiedDisableHits(Boolean newSpecifiedDisableHits) {
        Boolean oldSpecifiedDisableHits = this.specifiedDisableHits;
        this.specifiedDisableHits = newSpecifiedDisableHits;
        if (oldSpecifiedDisableHits != newSpecifiedDisableHits) {
            if (this.getResourceCache() != null) {
                this.getResourceCache().setDisableHits(newSpecifiedDisableHits);
                if (this.getResourceCache().isUnset()) {
                    this.removeResourceCache();
                }
            } else if (newSpecifiedDisableHits != null) {
                this.addResourceCache();
                this.getResourceCache().setDisableHits(newSpecifiedDisableHits);
            }
        }
        this.firePropertyChanged("specifiedDisableHits", oldSpecifiedDisableHits, newSpecifiedDisableHits);
    }

    protected void setSpecifiedDisableHits_(Boolean newSpecifiedDisableHits) {
        Boolean oldSpecifiedDisableHits = this.specifiedDisableHits;
        this.specifiedDisableHits = newSpecifiedDisableHits;
        this.firePropertyChanged("specifiedDisableHits", oldSpecifiedDisableHits, newSpecifiedDisableHits);
    }

    public EclipseLinkCacheType getType() {
        return this.specifiedType == null ? this.defaultType : this.specifiedType;
    }

    public EclipseLinkCacheType getDefaultType() {
        return this.defaultType;
    }

    protected void setDefaultType(EclipseLinkCacheType newDefaultType) {
        EclipseLinkCacheType oldDefaultType = this.defaultType;
        this.defaultType = newDefaultType;
        this.firePropertyChanged("defaultType", (Object)oldDefaultType, (Object)newDefaultType);
    }

    public EclipseLinkCacheType getSpecifiedType() {
        return this.specifiedType;
    }

    public void setSpecifiedType(EclipseLinkCacheType newSpecifiedType) {
        EclipseLinkCacheType oldSpecifiedType = this.specifiedType;
        this.specifiedType = newSpecifiedType;
        if (oldSpecifiedType != newSpecifiedType) {
            if (this.getResourceCache() != null) {
                this.getResourceCache().setType(EclipseLinkCacheType.toOrmResourceModel(newSpecifiedType));
                if (this.getResourceCache().isUnset()) {
                    this.removeResourceCache();
                }
            } else if (newSpecifiedType != null) {
                this.addResourceCache();
                this.getResourceCache().setType(EclipseLinkCacheType.toOrmResourceModel(newSpecifiedType));
            }
        }
        this.firePropertyChanged("specifiedType", (Object)oldSpecifiedType, (Object)newSpecifiedType);
    }

    protected void setSpecifiedType_(EclipseLinkCacheType newSpecifiedType) {
        EclipseLinkCacheType oldSpecifiedType = this.specifiedType;
        this.specifiedType = newSpecifiedType;
        this.firePropertyChanged("specifiedType", (Object)oldSpecifiedType, (Object)newSpecifiedType);
    }

    public EclipseLinkCacheCoordinationType getCoordinationType() {
        return this.specifiedCoordinationType == null ? this.defaultCoordinationType : this.specifiedCoordinationType;
    }

    public EclipseLinkCacheCoordinationType getDefaultCoordinationType() {
        return this.defaultCoordinationType;
    }

    protected void setDefaultCoordinationType(EclipseLinkCacheCoordinationType newDefaultcCoordinationType) {
        EclipseLinkCacheCoordinationType oldDefaultcCoordinationType = this.defaultCoordinationType;
        this.defaultCoordinationType = newDefaultcCoordinationType;
        this.firePropertyChanged("defaultCoordinationType", (Object)oldDefaultcCoordinationType, (Object)newDefaultcCoordinationType);
    }

    public EclipseLinkCacheCoordinationType getSpecifiedCoordinationType() {
        return this.specifiedCoordinationType;
    }

    public void setSpecifiedCoordinationType(EclipseLinkCacheCoordinationType newSpecifiedCoordinationType) {
        EclipseLinkCacheCoordinationType oldSpecifiedCoordinationType = this.specifiedCoordinationType;
        this.specifiedCoordinationType = newSpecifiedCoordinationType;
        if (oldSpecifiedCoordinationType != newSpecifiedCoordinationType) {
            if (this.getResourceCache() != null) {
                this.getResourceCache().setCoordinationType(EclipseLinkCacheCoordinationType.toOrmResourceModel(newSpecifiedCoordinationType));
                if (this.getResourceCache().isUnset()) {
                    this.removeResourceCache();
                }
            } else if (newSpecifiedCoordinationType != null) {
                this.addResourceCache();
                this.getResourceCache().setCoordinationType(EclipseLinkCacheCoordinationType.toOrmResourceModel(newSpecifiedCoordinationType));
            }
        }
        this.firePropertyChanged("specifiedCoordinationType", (Object)oldSpecifiedCoordinationType, (Object)newSpecifiedCoordinationType);
    }

    protected void setSpecifiedCoordinationType_(EclipseLinkCacheCoordinationType newSpecifiedCoordinationType) {
        EclipseLinkCacheCoordinationType oldSpecifiedCoordinationType = this.specifiedCoordinationType;
        this.specifiedCoordinationType = newSpecifiedCoordinationType;
        this.firePropertyChanged("specifiedCoordinationType", (Object)oldSpecifiedCoordinationType, (Object)newSpecifiedCoordinationType);
    }

    public EclipseLinkExistenceType getExistenceType() {
        return this.specifiedExistenceType == null ? this.defaultExistenceType : this.specifiedExistenceType;
    }

    public EclipseLinkExistenceType getDefaultExistenceType() {
        return this.defaultExistenceType;
    }

    protected void setDefaultExistenceType(EclipseLinkExistenceType newDefaultExistenceType) {
        EclipseLinkExistenceType oldDefaultExistenceType = this.defaultExistenceType;
        this.defaultExistenceType = newDefaultExistenceType;
        this.firePropertyChanged("defaultExistenceType", (Object)oldDefaultExistenceType, (Object)newDefaultExistenceType);
    }

    public EclipseLinkExistenceType getSpecifiedExistenceType() {
        return this.specifiedExistenceType;
    }

    public void setSpecifiedExistenceType(EclipseLinkExistenceType newSpecifiedExistenceType) {
        EclipseLinkExistenceType oldSpecifiedExistenceType = this.specifiedExistenceType;
        this.specifiedExistenceType = newSpecifiedExistenceType;
        this.resource.setExistenceChecking(EclipseLinkExistenceType.toOrmResourceModel(newSpecifiedExistenceType));
        this.firePropertyChanged("specifiedExistenceType", (Object)oldSpecifiedExistenceType, (Object)newSpecifiedExistenceType);
    }

    protected void setSpecifiedExistenceType_(EclipseLinkExistenceType newSpecifiedExistenceType) {
        EclipseLinkExistenceType oldSpecifiedExistenceType = this.specifiedExistenceType;
        this.specifiedExistenceType = newSpecifiedExistenceType;
        this.firePropertyChanged("specifiedExistenceType", (Object)oldSpecifiedExistenceType, (Object)newSpecifiedExistenceType);
    }

    public Integer getExpiry() {
        return this.expiry;
    }

    public void setExpiry(Integer newExpiry) {
        Integer oldExpiry = this.expiry;
        this.expiry = newExpiry;
        if (oldExpiry != newExpiry) {
            if (this.getResourceCache() != null) {
                this.getResourceCache().setExpiry(newExpiry);
                if (this.getResourceCache().isUnset()) {
                    this.removeResourceCache();
                }
            } else if (newExpiry != null) {
                this.addResourceCache();
                this.getResourceCache().setExpiry(newExpiry);
            }
        }
        this.firePropertyChanged("expiry", oldExpiry, newExpiry);
        if (newExpiry != null && this.expiryTimeOfDay != null) {
            this.removeExpiryTimeOfDay();
        }
    }

    protected void setExpiry_(Integer newExpiry) {
        Integer oldExpiry = this.expiry;
        this.expiry = newExpiry;
        this.firePropertyChanged("expiry", oldExpiry, newExpiry);
    }

    public EclipseLinkExpiryTimeOfDay getExpiryTimeOfDay() {
        return this.expiryTimeOfDay;
    }

    public EclipseLinkExpiryTimeOfDay addExpiryTimeOfDay() {
        OrmEclipseLinkExpiryTimeOfDay newExpiryTimeOfDay;
        if (this.expiryTimeOfDay != null) {
            throw new IllegalStateException("expiryTimeOfDay already exists, use getExpiryTimeOfDay()");
        }
        if (this.getResourceCache() == null) {
            this.addResourceCache();
        }
        this.expiryTimeOfDay = newExpiryTimeOfDay = new OrmEclipseLinkExpiryTimeOfDay(this);
        XmlTimeOfDay resourceTimeOfDay = EclipseLinkOrmFactory.eINSTANCE.createXmlTimeOfDay();
        newExpiryTimeOfDay.initialize(resourceTimeOfDay);
        this.getResourceCache().setExpiryTimeOfDay(resourceTimeOfDay);
        this.firePropertyChanged("expiryTimeOfDay", null, newExpiryTimeOfDay);
        this.setExpiry(null);
        return newExpiryTimeOfDay;
    }

    public void removeExpiryTimeOfDay() {
        if (this.expiryTimeOfDay == null) {
            throw new IllegalStateException("timeOfDayExpiry does not exist");
        }
        OrmEclipseLinkExpiryTimeOfDay oldExpiryTimeOfDay = this.expiryTimeOfDay;
        this.expiryTimeOfDay = null;
        this.getResourceCache().setExpiryTimeOfDay(null);
        if (this.getResourceCache().isUnset()) {
            this.removeResourceCache();
        }
        this.firePropertyChanged("expiryTimeOfDay", oldExpiryTimeOfDay, null);
    }

    protected void setExpiryTimeOfDay(OrmEclipseLinkExpiryTimeOfDay newExpiryTimeOfDay) {
        OrmEclipseLinkExpiryTimeOfDay oldExpiryTimeOfDay = this.expiryTimeOfDay;
        this.expiryTimeOfDay = newExpiryTimeOfDay;
        this.firePropertyChanged("expiryTimeOfDay", oldExpiryTimeOfDay, newExpiryTimeOfDay);
    }

    protected XmlCache getResourceCache() {
        return this.resource.getCache();
    }

    protected void addResourceCache() {
        this.resource.setCache(EclipseLinkOrmFactory.eINSTANCE.createXmlCache());
    }

    protected void removeResourceCache() {
        this.resource.setCache(null);
    }

    public OrmCacheable2_0 getCacheable() {
        return this.cacheable;
    }

    public boolean calculateDefaultCacheable() {
        JavaPersistentType javaPersistentType;
        if (!this.getParent().isMetadataComplete() && (javaPersistentType = this.getParent().getPersistentType().getJavaPersistentType()) != null && javaPersistentType.getMapping() instanceof CacheableHolder2_0) {
            return ((CacheableHolder2_0)javaPersistentType.getMapping()).getCacheable().isCacheable();
        }
        CacheableHolder2_0 cacheableHolder = this.getCacheableSuperPersistentType((PersistentType)this.getParent().getPersistentType());
        if (cacheableHolder != null) {
            return cacheableHolder.getCacheable().isCacheable();
        }
        return ((PersistenceUnit2_0)this.getPersistenceUnit()).calculateDefaultCacheable();
    }

    protected CacheableHolder2_0 getCacheableSuperPersistentType(PersistentType persistentType) {
        PersistentType superPersistentType = persistentType.getSuperPersistentType();
        if (superPersistentType != null) {
            if (superPersistentType.getMapping() instanceof CacheableHolder2_0) {
                return (CacheableHolder2_0)superPersistentType.getMapping();
            }
            return this.getCacheableSuperPersistentType(superPersistentType);
        }
        return null;
    }

    protected void initializeExpiry(XmlCache resourceCache) {
        if (resourceCache == null) {
            return;
        }
        if (resourceCache.getExpiryTimeOfDay() == null) {
            this.expiry = resourceCache.getExpiry();
        } else if (resourceCache.getExpiry() == null) {
            this.expiryTimeOfDay = new OrmEclipseLinkExpiryTimeOfDay(this);
            this.expiryTimeOfDay.initialize(resourceCache.getExpiryTimeOfDay());
        }
    }

    public void update(JavaEclipseLinkCaching javaCaching) {
        XmlCache resourceCache = this.getResourceCache();
        this.setDefaultSize(this.defaultSize(javaCaching));
        this.setSpecifiedSize_(this.getResourceSize(resourceCache));
        this.setDefaultShared(this.defaultShared(javaCaching));
        this.setSpecifiedShared_(this.getResourceShared(resourceCache));
        this.setDefaultAlwaysRefresh(this.defaultAlwaysRefresh(javaCaching));
        this.setSpecifiedAlwaysRefresh_(this.getResourceAlwaysRefresh(resourceCache));
        this.setDefaultRefreshOnlyIfNewer(this.defaultRefreshOnlyIfNewer(javaCaching));
        this.setSpecifiedRefreshOnlyIfNewer_(this.getResourceRefreshOnlyIfNewer(resourceCache));
        this.setDefaultDisableHits(this.defaultDisableHits(javaCaching));
        this.setSpecifiedDisableHits_(this.getResourceDisableHits(resourceCache));
        this.setDefaultType(this.defaultType(javaCaching));
        this.setSpecifiedType_(this.getResourceType(resourceCache));
        this.setDefaultCoordinationType(this.defaultCoordinationType(javaCaching));
        this.setSpecifiedCoordinationType_(this.getResourceCoordinationType(resourceCache));
        this.setDefaultExistenceType(this.defaultExistenceType(javaCaching));
        this.setSpecifiedExistenceType_(this.getResourceExistenceChecking());
        this.updateExpiry(resourceCache);
        this.cacheable.update();
    }

    protected void updateExpiry(XmlCache resourceCache) {
        if (resourceCache == null) {
            this.setExpiryTimeOfDay(null);
            this.setExpiry_(null);
            return;
        }
        if (resourceCache.getExpiryTimeOfDay() == null) {
            this.setExpiryTimeOfDay(null);
            this.setExpiry_(resourceCache.getExpiry());
        } else if (this.expiryTimeOfDay != null) {
            this.expiryTimeOfDay.update(resourceCache.getExpiryTimeOfDay());
        } else if (resourceCache.getExpiry() == null) {
            this.setExpiryTimeOfDay(new OrmEclipseLinkExpiryTimeOfDay(this));
            this.expiryTimeOfDay.initialize(resourceCache.getExpiryTimeOfDay());
        } else {
            this.setExpiryTimeOfDay(null);
        }
    }

    protected int defaultSize(JavaEclipseLinkCaching javaCaching) {
        return javaCaching == null ? 100 : javaCaching.getSize();
    }

    protected Integer getResourceSize(XmlCache resource) {
        return resource == null ? null : resource.getSize();
    }

    protected boolean defaultShared(JavaEclipseLinkCaching javaCaching) {
        if (javaCaching == null) {
            return true;
        }
        return this.getResourceCache() == null ? javaCaching.isShared() : true;
    }

    protected Boolean getResourceShared(XmlCache resource) {
        return resource == null ? null : resource.getShared();
    }

    protected boolean defaultAlwaysRefresh(JavaEclipseLinkCaching javaCaching) {
        if (javaCaching == null) {
            return false;
        }
        return this.getResourceCache() == null ? javaCaching.isAlwaysRefresh() : false;
    }

    protected Boolean getResourceAlwaysRefresh(XmlCache resource) {
        return resource == null ? null : resource.getAlwaysRefresh();
    }

    protected boolean defaultRefreshOnlyIfNewer(JavaEclipseLinkCaching javaCaching) {
        if (javaCaching == null) {
            return false;
        }
        return this.getResourceCache() == null ? javaCaching.isRefreshOnlyIfNewer() : false;
    }

    protected Boolean getResourceRefreshOnlyIfNewer(XmlCache resource) {
        return resource == null ? null : resource.getRefreshOnlyIfNewer();
    }

    protected boolean defaultDisableHits(JavaEclipseLinkCaching javaCaching) {
        if (javaCaching == null) {
            return false;
        }
        return this.getResourceCache() == null ? javaCaching.isDisableHits() : false;
    }

    protected Boolean getResourceDisableHits(XmlCache resource) {
        return resource == null ? null : resource.getDisableHits();
    }

    protected EclipseLinkCacheType defaultType(JavaEclipseLinkCaching javaCaching) {
        if (javaCaching == null) {
            return DEFAULT_TYPE;
        }
        return this.getResourceCache() == null ? javaCaching.getType() : DEFAULT_TYPE;
    }

    protected EclipseLinkCacheType getResourceType(XmlCache resource) {
        return resource == null ? null : EclipseLinkCacheType.fromOrmResourceModel(resource.getType());
    }

    protected EclipseLinkCacheCoordinationType defaultCoordinationType(JavaEclipseLinkCaching javaCaching) {
        if (javaCaching == null) {
            return DEFAULT_COORDINATION_TYPE;
        }
        return this.getResourceCache() == null ? javaCaching.getCoordinationType() : DEFAULT_COORDINATION_TYPE;
    }

    protected EclipseLinkCacheCoordinationType getResourceCoordinationType(XmlCache resource) {
        return resource == null ? null : EclipseLinkCacheCoordinationType.fromOrmResourceModel(resource.getCoordinationType());
    }

    protected EclipseLinkExistenceType defaultExistenceType(JavaEclipseLinkCaching javaCaching) {
        return javaCaching == null ? DEFAULT_EXISTENCE_TYPE : javaCaching.getExistenceType();
    }

    protected EclipseLinkExistenceType getResourceExistenceChecking() {
        return this.resource == null ? null : EclipseLinkExistenceType.fromOrmResourceModel(this.resource.getExistenceChecking());
    }

    protected Integer getResourceExpiry(XmlCache resource) {
        return resource == null ? null : resource.getExpiry();
    }

    public TextRange getValidationTextRange() {
        XmlCache resource = this.getResourceCache();
        return resource == null ? null : resource.getValidationTextRange();
    }
}

