/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java.source;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.AnnotationContainerTools;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.StringExpressionConverter;
import org.eclipse.jpt.core.resource.java.AnnotationContainer;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.eclipselink.core.internal.resource.java.source.SourceBaseEclipseLinkTypeConverterAnnotation;
import org.eclipse.jpt.eclipselink.core.internal.resource.java.source.SourceEclipseLinkConversionValueAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkConversionValueAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkObjectTypeConverterAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.NestableEclipseLinkConversionValueAnnotation;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceEclipseLinkObjectTypeConverterAnnotation
extends SourceBaseEclipseLinkTypeConverterAnnotation
implements EclipseLinkObjectTypeConverterAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.ObjectTypeConverter");
    private static final DeclarationAnnotationElementAdapter<String> DEFAULT_OBJECT_VALUE_ADAPTER = SourceEclipseLinkObjectTypeConverterAnnotation.buildDefaultObjectValueAdapter();
    private final AnnotationElementAdapter<String> defaultObjectValueAdapter;
    private String defaultObjectValue;
    private final Vector<NestableEclipseLinkConversionValueAnnotation> conversionValues = new Vector();
    private final ConversionValuesAnnotationContainer conversionValuesContainer = new ConversionValuesAnnotationContainer();

    public SourceEclipseLinkObjectTypeConverterAnnotation(JavaResourcePersistentMember parent, Member member) {
        super(parent, member, DECLARATION_ANNOTATION_ADAPTER);
        this.defaultObjectValueAdapter = new MemberAnnotationElementAdapter(member, DEFAULT_OBJECT_VALUE_ADAPTER);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.ObjectTypeConverter";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.defaultObjectValue = this.buildDefaultObjectValue(astRoot);
        AnnotationContainerTools.initialize((AnnotationContainer)this.conversionValuesContainer, (CompilationUnit)astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncDefaultObjectValue(this.buildDefaultObjectValue(astRoot));
        AnnotationContainerTools.synchronize((AnnotationContainer)this.conversionValuesContainer, (CompilationUnit)astRoot);
    }

    @Override
    String getNameElementName() {
        return "name";
    }

    @Override
    String getDataTypeElementName() {
        return "dataType";
    }

    @Override
    String getObjectTypeElementName() {
        return "objectType";
    }

    @Override
    public String getDefaultObjectValue() {
        return this.defaultObjectValue;
    }

    @Override
    public void setDefaultObjectValue(String defaultObjectValue) {
        if (this.attributeValueHasChanged(this.defaultObjectValue, defaultObjectValue)) {
            this.defaultObjectValue = defaultObjectValue;
            this.defaultObjectValueAdapter.setValue((Object)defaultObjectValue);
        }
    }

    private void syncDefaultObjectValue(String astDefaultObjectValue) {
        String old = this.defaultObjectValue;
        this.defaultObjectValue = astDefaultObjectValue;
        this.firePropertyChanged("defaultObjectValue", old, astDefaultObjectValue);
    }

    private String buildDefaultObjectValue(CompilationUnit astRoot) {
        return (String)this.defaultObjectValueAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getDefaultObjectValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(DEFAULT_OBJECT_VALUE_ADAPTER, astRoot);
    }

    @Override
    public ListIterator<EclipseLinkConversionValueAnnotation> conversionValues() {
        return new CloneListIterator(this.conversionValues);
    }

    Iterable<NestableEclipseLinkConversionValueAnnotation> getNestableConversionValues() {
        return new LiveCloneIterable(this.conversionValues);
    }

    @Override
    public int conversionValuesSize() {
        return this.conversionValues.size();
    }

    @Override
    public NestableEclipseLinkConversionValueAnnotation conversionValueAt(int index) {
        return this.conversionValues.get(index);
    }

    @Override
    public int indexOfConversionValue(EclipseLinkConversionValueAnnotation conversionValue) {
        return this.conversionValues.indexOf(conversionValue);
    }

    @Override
    public NestableEclipseLinkConversionValueAnnotation addConversionValue(int index) {
        return (NestableEclipseLinkConversionValueAnnotation)AnnotationContainerTools.addNestedAnnotation((int)index, (AnnotationContainer)this.conversionValuesContainer);
    }

    NestableEclipseLinkConversionValueAnnotation addConversionValue_() {
        return this.addConversionValue_(this.conversionValues.size());
    }

    private NestableEclipseLinkConversionValueAnnotation addConversionValue_(int index) {
        NestableEclipseLinkConversionValueAnnotation conversionValue = this.buildConversionValue(index);
        this.conversionValues.add(conversionValue);
        return conversionValue;
    }

    void syncAddConversionValue(Annotation astAnnotation) {
        int index = this.conversionValues.size();
        NestableEclipseLinkConversionValueAnnotation conversionValue = this.addConversionValue_(index);
        conversionValue.initialize((CompilationUnit)astAnnotation.getRoot());
        this.fireItemAdded("conversionValues", index, conversionValue);
    }

    private NestableEclipseLinkConversionValueAnnotation buildConversionValue(int index) {
        return SourceEclipseLinkConversionValueAnnotation.createConversionValue(this, this.member, this.daa, index);
    }

    void conversionValueAdded(int index, NestableEclipseLinkConversionValueAnnotation conversionValue) {
        this.fireItemAdded("conversionValues", index, conversionValue);
    }

    @Override
    public void moveConversionValue(int targetIndex, int sourceIndex) {
        AnnotationContainerTools.moveNestedAnnotation((int)targetIndex, (int)sourceIndex, (AnnotationContainer)this.conversionValuesContainer);
    }

    NestableEclipseLinkConversionValueAnnotation moveConversionValue_(int targetIndex, int sourceIndex) {
        return (NestableEclipseLinkConversionValueAnnotation)CollectionTools.move(this.conversionValues, (int)targetIndex, (int)sourceIndex).get(targetIndex);
    }

    @Override
    public void removeConversionValue(int index) {
        AnnotationContainerTools.removeNestedAnnotation((int)index, (AnnotationContainer)this.conversionValuesContainer);
    }

    NestableEclipseLinkConversionValueAnnotation removeConversionValue_(int index) {
        return this.conversionValues.remove(index);
    }

    void syncRemoveConversionValues(int index) {
        this.removeItemsFromList(index, this.conversionValues, "conversionValues");
    }

    private static DeclarationAnnotationElementAdapter<String> buildDefaultObjectValueAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "defaultObjectValue", false, StringExpressionConverter.instance());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConversionValuesAnnotationContainer
    implements AnnotationContainer<NestableEclipseLinkConversionValueAnnotation> {
        ConversionValuesAnnotationContainer() {
        }

        public Annotation getAstAnnotation(CompilationUnit astRoot) {
            return SourceEclipseLinkObjectTypeConverterAnnotation.this.getAstAnnotation(astRoot);
        }

        public String getElementName() {
            return "conversionValues";
        }

        public String getNestedAnnotationName() {
            return "org.eclipse.persistence.annotations.ConversionValue";
        }

        public Iterable<NestableEclipseLinkConversionValueAnnotation> getNestedAnnotations() {
            return SourceEclipseLinkObjectTypeConverterAnnotation.this.getNestableConversionValues();
        }

        public int getNestedAnnotationsSize() {
            return SourceEclipseLinkObjectTypeConverterAnnotation.this.conversionValuesSize();
        }

        public NestableEclipseLinkConversionValueAnnotation addNestedAnnotation() {
            return SourceEclipseLinkObjectTypeConverterAnnotation.this.addConversionValue_();
        }

        public void syncAddNestedAnnotation(Annotation astAnnotation) {
            SourceEclipseLinkObjectTypeConverterAnnotation.this.syncAddConversionValue(astAnnotation);
        }

        public NestableEclipseLinkConversionValueAnnotation moveNestedAnnotation(int targetIndex, int sourceIndex) {
            return SourceEclipseLinkObjectTypeConverterAnnotation.this.moveConversionValue_(targetIndex, sourceIndex);
        }

        public NestableEclipseLinkConversionValueAnnotation removeNestedAnnotation(int index) {
            return SourceEclipseLinkObjectTypeConverterAnnotation.this.removeConversionValue_(index);
        }

        public void syncRemoveNestedAnnotations(int index) {
            SourceEclipseLinkObjectTypeConverterAnnotation.this.syncRemoveConversionValues(index);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

