/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.layouttpl.core.descriptor;

import com.liferay.ide.eclipse.layouttpl.core.LayoutTplCore;
import com.liferay.ide.eclipse.project.core.BaseValidator;
import com.liferay.ide.eclipse.project.core.ProjectCorePlugin;
import com.liferay.ide.eclipse.project.core.util.ProjectUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.ValidatorMessage;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiferayLayoutTplDescriptorValidator
extends BaseValidator {
    public static final String TEMPLATE_PATH_ELEMENT = "template-path";
    public static final String THUMBNAIL_PATH_ELEMENT = "thumbnail-path";
    public static final String WAP_TEMPLATE_PATH_ELEMENT = "wap-template-path";
    public static final String MARKER_TYPE = "com.liferay.ide.eclipse.layouttpl.core.liferayLayoutTplDescriptorMarker";
    public static final String MESSAGE_TEMPLATE_PATH_NOT_FOUND = "The template path {0} was not found in the docroot.";
    public static final String MESSAGE_THUMBNAIL_PATH_NOT_FOUND = "The thumbnail path {0} was not found in the docroot.";
    public static final String MESSAGE_WAP_TEMPLATE_PATH_NOT_FOUND = "The wap template path {0} was not found in the docroot.";
    public static final String PREFERENCE_NODE_QUALIFIER = ProjectCorePlugin.getDefault().getBundle().getSymbolicName();

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        if (resource.getType() != 1) {
            return null;
        }
        ValidationResult result = new ValidationResult();
        IFile liferayLayoutTplXml = (IFile)resource;
        if (liferayLayoutTplXml.isAccessible() && ProjectUtil.isLayoutTplProject((IProject)resource.getProject())) {
            IScopeContext[] scopes = new IScopeContext[]{new InstanceScope(), new DefaultScope()};
            ProjectScope projectScope = new ProjectScope(liferayLayoutTplXml.getProject());
            boolean useProjectSettings = projectScope.getNode(PREFERENCE_NODE_QUALIFIER).getBoolean("use-project-settings", false);
            if (useProjectSettings) {
                scopes = new IScopeContext[]{projectScope, new InstanceScope(), new DefaultScope()};
            }
            try {
                Map<String, Object>[] problems = this.detectProblems(liferayLayoutTplXml, scopes);
                int i = 0;
                while (i < problems.length) {
                    ValidatorMessage message = ValidatorMessage.create((String)problems[i].get("message").toString(), (IResource)resource);
                    message.setType(MARKER_TYPE);
                    message.setAttributes(problems[i]);
                    result.add(message);
                    ++i;
                }
            }
            catch (Exception e) {
                LayoutTplCore.logError(e);
            }
        }
        return result;
    }

    protected void checkDocrootElements(IDOMDocument document, IProject project, IScopeContext[] preferenceScopes, List<Map<String, Object>> problems) {
        this.checkDocrootElement(document, TEMPLATE_PATH_ELEMENT, project, PREFERENCE_NODE_QUALIFIER, preferenceScopes, "validation-liferay-layouttpl-xml-template-path-not-found", MESSAGE_TEMPLATE_PATH_NOT_FOUND, problems);
        this.checkDocrootElement(document, WAP_TEMPLATE_PATH_ELEMENT, project, PREFERENCE_NODE_QUALIFIER, preferenceScopes, "validation-liferay-layouttpl-xml-wap-template-path-not-found", MESSAGE_WAP_TEMPLATE_PATH_NOT_FOUND, problems);
        this.checkDocrootElement(document, THUMBNAIL_PATH_ELEMENT, project, PREFERENCE_NODE_QUALIFIER, preferenceScopes, "validation-liferay-layouttpl-xml-thumbnail-path-not-found", MESSAGE_THUMBNAIL_PATH_NOT_FOUND, problems);
    }

    protected Map<String, Object>[] detectProblems(IFile liferayLayoutTplXml, IScopeContext[] preferenceScopes) throws CoreException {
        ArrayList<Map<String, Object>> problems;
        block9: {
            problems = new ArrayList<Map<String, Object>>();
            IStructuredModel liferayLayputTplXmlModel = null;
            IDOMDocument liferayLayoutTplXmlDocument = null;
            try {
                try {
                    liferayLayputTplXmlModel = StructuredModelManager.getModelManager().getModelForRead(liferayLayoutTplXml);
                    if (liferayLayputTplXmlModel != null && liferayLayputTplXmlModel instanceof IDOMModel) {
                        liferayLayoutTplXmlDocument = ((IDOMModel)liferayLayputTplXmlModel).getDocument();
                        this.checkDocrootElements(liferayLayoutTplXmlDocument, liferayLayoutTplXml.getProject(), preferenceScopes, problems);
                    }
                }
                catch (IOException iOException) {
                    if (liferayLayputTplXmlModel != null) {
                        liferayLayputTplXmlModel.releaseFromRead();
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (liferayLayputTplXmlModel != null) {
                    liferayLayputTplXmlModel.releaseFromRead();
                }
                throw throwable;
            }
            if (liferayLayputTplXmlModel != null) {
                liferayLayputTplXmlModel.releaseFromRead();
            }
        }
        Map[] retval = new Map[problems.size()];
        return problems.toArray(retval);
    }
}

