/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.project.ui;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.project.core.facet.IPluginProjectDataModelProperties;
import com.liferay.ide.eclipse.project.core.util.ProjectUtil;
import com.liferay.ide.eclipse.project.ui.ProjectUIPlugin;
import com.liferay.ide.eclipse.sdk.SDK;
import com.liferay.ide.eclipse.sdk.SDKManager;
import com.liferay.ide.eclipse.ui.util.SWTUtil;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class LiferayProjectPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage,
IPluginProjectDataModelProperties {
    protected Combo sdkCombo;

    public LiferayProjectPropertyPage() {
        this.setImageDescriptor(ProjectUIPlugin.imageDescriptorFromPlugin((String)"com.liferay.ide.eclipse.project.ui", (String)"/icons/e16/liferay.png"));
    }

    public boolean isValid() {
        boolean valid = super.isValid();
        if (!valid) {
            return valid;
        }
        int index = this.sdkCombo.getSelectionIndex();
        if (index < 0) {
            valid = false;
        } else {
            String sdkName = this.sdkCombo.getItem(this.sdkCombo.getSelectionIndex());
            SDK sdk = SDKManager.getInstance().getSDK(sdkName);
            valid = sdk != null;
        }
        return valid;
    }

    public boolean performOk() {
        if (!this.isValid()) {
            this.setErrorMessage("Current values are invalid.");
            return false;
        }
        boolean retval = false;
        String sdkName = this.sdkCombo.getItem(this.sdkCombo.getSelectionIndex());
        SDK sdk = SDKManager.getInstance().getSDK(sdkName);
        if (sdk != null) {
            IFacetedProject facetedProject = this.getFacetedProject();
            IProjectFacet liferayFacet = ProjectUtil.getLiferayFacet((IFacetedProject)facetedProject);
            try {
                ProjectUtil.setSDK((IProject)facetedProject.getProject(), (IProjectFacet)liferayFacet, (SDK)sdk);
                retval = true;
            }
            catch (Exception e) {
                ProjectUIPlugin.logError(e);
            }
        }
        return retval;
    }

    protected void configureSDKsLinkSelected(SelectionEvent e) {
        String[] id = new String[]{"com.liferay.ide.eclipse.sdk.preferences.installedSDKs"};
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)"com.liferay.ide.eclipse.sdk.preferences.installedSDKs", (String[])id, null);
        int retval = dialog.open();
        if (retval == 0) {
            this.setupSDKCombo();
            this.getContainer().updateButtons();
        }
    }

    protected Control createContents(Composite parent) {
        Composite top = SWTUtil.createTopComposite((Composite)parent, (int)1);
        this.createSDKGroup(top);
        return top;
    }

    protected Group createDefaultGroup(Composite parent, String text, int columns) {
        GridLayout gl = new GridLayout(columns, false);
        Group group = new Group(parent, 0);
        group.setText(text);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)gl);
        return group;
    }

    protected void createSDKGroup(Composite parent) {
        Group group = this.createDefaultGroup(parent, "Liferay Plugin SDK", 2);
        ((GridData)group.getLayoutData()).grabExcessVerticalSpace = false;
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 3;
        gl.marginWidth = 0;
        this.sdkCombo = new Combo((Composite)group, 12);
        this.sdkCombo.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.sdkCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LiferayProjectPropertyPage.this.getContainer().updateButtons();
            }
        });
        Link configureSDKsLink = new Link((Composite)group, 4);
        configureSDKsLink.setText("<a href=\"#\">Configure SDKs</a>");
        configureSDKsLink.setLayoutData((Object)new GridData(131072, 128, false, false));
        configureSDKsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LiferayProjectPropertyPage.this.configureSDKsLinkSelected(e);
            }
        });
        this.setupSDKCombo();
    }

    protected IFacetedProject getFacetedProject() {
        IFacetedProject retval = null;
        IAdaptable adaptable = this.getElement();
        IProject project = (IProject)adaptable.getAdapter(IProject.class);
        if (project != null) {
            retval = ProjectUtil.getFacetedProject((IProject)project);
        }
        return retval;
    }

    protected void performDefaults() {
        SDK defaultSdk = SDKManager.getInstance().getDefaultSDK();
        if (defaultSdk != null) {
            this.setupSDKCombo();
            String[] items = this.sdkCombo.getItems();
            int i = 0;
            while (i < items.length) {
                String sdkItemName = this.sdkCombo.getItem(i);
                if (defaultSdk.getName().equals(sdkItemName)) {
                    this.sdkCombo.select(i);
                    break;
                }
                ++i;
            }
        }
        super.performDefaults();
    }

    protected void setupSDKCombo() {
        SDK[] allSDKs;
        ArrayList<String> sdkNames = new ArrayList<String>();
        SDK[] sDKArray = allSDKs = SDKManager.getInstance().getSDKs();
        int n = allSDKs.length;
        int n2 = 0;
        while (n2 < n) {
            SDK sdk = sDKArray[n2];
            sdkNames.add(sdk.getName());
            ++n2;
        }
        this.sdkCombo.setItems(sdkNames.toArray(new String[0]));
        IFacetedProject facetedProject = this.getFacetedProject();
        if (facetedProject != null) {
            IProjectFacet liferayFacet = ProjectUtil.getLiferayFacet((IFacetedProject)facetedProject);
            try {
                Preferences prefs = facetedProject.getPreferences(liferayFacet).node("liferay-plugin-project");
                String sdkName = prefs.get("sdk-name", "");
                SDK sdk = SDKManager.getInstance().getSDK(sdkName);
                if (!CoreUtil.isNullOrEmpty((String)sdkName) && sdk != null) {
                    this.sdkCombo.select(sdkNames.indexOf(sdk.getName()));
                }
            }
            catch (BackingStoreException e) {
                ProjectUIPlugin.logError((Exception)((Object)e));
            }
        }
    }
}

