/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.project.ui.wizard;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.project.core.ILiferayProjectImportDataModelProperties;
import com.liferay.ide.eclipse.project.core.ProjectRecord;
import com.liferay.ide.eclipse.project.core.util.ProjectUtil;
import com.liferay.ide.eclipse.project.ui.wizard.NewProjectFromSourceWizard;
import com.liferay.ide.eclipse.ui.util.SWTUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.server.ui.ServerUIUtil;
import org.eclipse.wst.web.ui.internal.wizards.DataModelFacetCreationWizardPage;

public class LiferayProjectImportWizardPage
extends DataModelFacetCreationWizardPage
implements ILiferayProjectImportDataModelProperties {
    protected Text projectLocation;
    protected Text pluginType;
    protected Text sdkVersion;
    protected ProjectRecord projectRecord = null;
    protected Combo serverTargetCombo;
    protected IProject[] wsProjects;

    public LiferayProjectImportWizardPage(IDataModel model, String pageName, IWizard parentWizard) {
        super(model, pageName);
        if (parentWizard instanceof NewProjectFromSourceWizard) {
            this.setTitle("New Liferay Project from Existing Source");
            this.setDescription("Browse to an existing Liferay project to import.");
        } else {
            this.setTitle("Import Liferay Project");
            this.setDescription("Select an existing Liferay project to import.");
        }
    }

    protected void createProjectLocationField(Composite topComposite) {
        SWTUtil.createLabel((Composite)topComposite, (int)16384, (String)"Liferay project location:", (int)1);
        this.projectLocation = SWTUtil.createText((Composite)topComposite, (int)1);
        this.synchHelper.synchText(this.projectLocation, "ILiferayProjectImportDataModelProperties.PROJECT_LOCATION", null);
        this.synchHelper.getDataModel().addListener(new IDataModelListener(){

            public void propertyChanged(DataModelEvent event) {
                if ("ILiferayProjectImportDataModelProperties.PROJECT_LOCATION".equals(event.getPropertyName())) {
                    LiferayProjectImportWizardPage.this.updateProjectRecord(event.getDataModel().getStringProperty("ILiferayProjectImportDataModelProperties.PROJECT_LOCATION"));
                    LiferayProjectImportWizardPage.this.synchHelper.synchAllUIWithModel();
                    LiferayProjectImportWizardPage.this.validatePage();
                }
            }
        });
        Button iconFileBrowse = SWTUtil.createPushButton((Composite)topComposite, (String)"Browse...", null);
        iconFileBrowse.setLayoutData((Object)new GridData(2));
        iconFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LiferayProjectImportWizardPage.this.handleFileBrowseButton(LiferayProjectImportWizardPage.this.projectLocation);
            }
        });
    }

    protected void createSDKVersionField(Composite topComposite) {
        SWTUtil.createLabel((Composite)topComposite, (int)16384, (String)"Liferay Plugin SDK version:", (int)1);
        this.sdkVersion = SWTUtil.createText((Composite)topComposite, (int)1);
        this.synchHelper.synchText(this.sdkVersion, "ILiferayProjectImportDataModelProperties.SDK_VERSION", null);
        SWTUtil.createLabel((Composite)topComposite, (String)"", (int)1);
    }

    protected void createPluginTypeField(Composite topComposite) {
        SWTUtil.createLabel((Composite)topComposite, (int)16384, (String)"Liferay plugin type:", (int)1);
        this.pluginType = SWTUtil.createText((Composite)topComposite, (int)1);
        this.synchHelper.synchText(this.pluginType, "ILiferayProjectImportDataModelProperties.PLUGIN_TYPE", null);
        SWTUtil.createLabel((Composite)topComposite, (String)"", (int)1);
    }

    protected void createTargetRuntimeGroup(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Liferay target runtime:");
        label.setLayoutData((Object)new GridData(32));
        this.serverTargetCombo = new Combo(parent, 2056);
        this.serverTargetCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button newServerTargetButton = new Button(parent, 0);
        newServerTargetButton.setText("New...");
        newServerTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataModelPropertyDescriptor[] preAdditionDescriptors = LiferayProjectImportWizardPage.this.model.getValidPropertyDescriptors("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
                boolean isOK = ServerUIUtil.showNewRuntimeWizard((Shell)LiferayProjectImportWizardPage.this.getShell(), (String)LiferayProjectImportWizardPage.this.getModuleTypeID(), null, (String)"com.liferay.");
                if (isOK) {
                    DataModelPropertyDescriptor[] postAdditionDescriptors = LiferayProjectImportWizardPage.this.model.getValidPropertyDescriptors("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
                    Object[] preAddition = new Object[preAdditionDescriptors.length];
                    int i = 0;
                    while (i < preAddition.length) {
                        preAddition[i] = preAdditionDescriptors[i].getPropertyValue();
                        ++i;
                    }
                    Object[] postAddition = new Object[postAdditionDescriptors.length];
                    int i2 = 0;
                    while (i2 < postAddition.length) {
                        postAddition[i2] = postAdditionDescriptors[i2].getPropertyValue();
                        ++i2;
                    }
                    Object newAddition = CoreUtil.getNewObject((Object[])preAddition, (Object[])postAddition);
                    if (newAddition != null) {
                        LiferayProjectImportWizardPage.this.model.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", newAddition);
                    }
                }
            }
        });
        Control[] deps = new Control[]{newServerTargetButton};
        this.synchHelper.synchCombo(this.serverTargetCombo, "IFacetProjectCreationDataModelProperties.FACET_RUNTIME", deps);
        if (this.serverTargetCombo.getSelectionIndex() == -1 && this.serverTargetCombo.getVisibleItemCount() != 0) {
            this.serverTargetCombo.select(0);
        }
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite topComposite = SWTUtil.createTopComposite((Composite)parent, (int)3);
        GridLayout gl = new GridLayout(3, false);
        topComposite.setLayout((Layout)gl);
        topComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.createProjectLocationField(topComposite);
        this.createPluginTypeField(topComposite);
        this.createSDKVersionField(topComposite);
        this.createTargetRuntimeGroup(topComposite);
        return topComposite;
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"ILiferayProjectImportDataModelProperties.PROJECT_LOCATION", "ILiferayProjectImportDataModelProperties.PROJECT_RECORD", "ILiferayProjectImportDataModelProperties.SDK_VERSION", "ILiferayProjectImportDataModelProperties.PLUGIN_TYPE", "IFacetProjectCreationDataModelProperties.FACET_RUNTIME"};
    }

    protected void handleFileBrowseButton(Text text) {
        String dir;
        DirectoryDialog dd = new DirectoryDialog(this.getShell(), 4096);
        dd.setText("Select Liferay project folder");
        if (!CoreUtil.isNullOrEmpty((String)this.projectLocation.getText())) {
            dd.setFilterPath(this.projectLocation.getText());
        }
        if (!CoreUtil.isNullOrEmpty((String)(dir = dd.open()))) {
            this.projectLocation.setText(dir);
        }
    }

    protected void updateProjectRecord(String projectLocation) {
        if (CoreUtil.isNullOrEmpty((String)projectLocation)) {
            return;
        }
        this.projectRecord = ProjectUtil.getProjectRecordForDir((String)projectLocation);
        this.getDataModel().setProperty("ILiferayProjectImportDataModelProperties.PROJECT_RECORD", (Object)this.projectRecord);
    }

    protected IProject[] getProjectsInWorkspace() {
        if (this.wsProjects == null) {
            this.wsProjects = IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getProjects();
        }
        return this.wsProjects;
    }

    protected boolean isProjectInWorkspace(String projectName) {
        if (projectName == null) {
            return false;
        }
        IProject[] workspaceProjects = this.getProjectsInWorkspace();
        int i = 0;
        while (i < workspaceProjects.length) {
            if (projectName.equals(workspaceProjects[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

