/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.project.ui.wizard;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.project.core.facet.IPluginFacetConstants;
import com.liferay.ide.eclipse.project.core.facet.IPluginProjectDataModelProperties;
import com.liferay.ide.eclipse.project.ui.ProjectUIPlugin;
import com.liferay.ide.eclipse.project.ui.wizard.LiferaySDKField;
import com.liferay.ide.eclipse.project.ui.wizard.NewPluginProjectGroup;
import com.liferay.ide.eclipse.project.ui.wizard.NewPluginProjectWizard;
import com.liferay.ide.eclipse.project.ui.wizard.NewProjectFromSourceWizard;
import com.liferay.ide.eclipse.sdk.SDKManager;
import com.liferay.ide.eclipse.ui.util.SWTUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.servlet.ui.project.facet.WebProjectFirstPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.ui.internal.FacetsSelectionDialog;
import org.eclipse.wst.server.ui.ServerUIUtil;

public class NewPluginProjectFirstPage
extends WebProjectFirstPage
implements IPluginProjectDataModelProperties {
    protected Button extType;
    protected Button hookType;
    protected Button layoutTemplateType;
    protected Button portletType;
    protected boolean shouldValidatePage = true;
    protected Button themeType;

    public NewPluginProjectFirstPage(NewPluginProjectWizard wizard, IDataModel model, String pageName) {
        super(model, pageName);
        this.setImageDescriptor(wizard.getDefaultPageImageDescriptor());
        this.setTitle("Liferay Plugin Project");
        this.setDescription("Create a new plugin project for Liferay Portal.");
        this.primaryProjectFacet = IPluginFacetConstants.LIFERAY_PORTLET_PROJECT_FACET;
    }

    public boolean canFlipToNextPage() {
        boolean canFlip = super.canFlipToNextPage();
        if (canFlip) {
            return this.getModel().getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_PORTLET");
        }
        return canFlip;
    }

    public void setShouldValidatePage(boolean shouldValidate) {
        this.shouldValidatePage = shouldValidate;
    }

    protected void configureSDKsLinkSelected(SelectionEvent e) {
        int retval = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)"com.liferay.ide.eclipse.sdk.preferences.installedSDKs", (String[])new String[]{"com.liferay.ide.eclipse.sdk.preferences.installedSDKs"}, null).open();
        if (retval == 0) {
            this.getModel().notifyPropertyChange("IPluginProjectDataModelProperties.LIFERAY_SDK_NAME", 4);
        }
    }

    protected Group createDefaultGroup(Composite parent, String text, int columns) {
        Group group = new Group(parent, 0);
        group.setText(text);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gl = new GridLayout(columns, false);
        group.setLayout((Layout)gl);
        return group;
    }

    protected void createImportProjectLink(Composite parent) {
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 0x1000008;
        gd.horizontalIndent = 8;
        gd.verticalIndent = 8;
        Link link = new Link(parent, 4);
        link.setText("<a href=\"#\">Create a new project from existing sources...</a>");
        link.setLayoutData((Object)gd);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewPluginProjectFirstPage.this.getWizard().getContainer().getShell().close();
                WizardDialog dialog = new WizardDialog(NewPluginProjectFirstPage.this.getShell(), (IWizard)new NewProjectFromSourceWizard());
                dialog.open();
            }
        });
    }

    protected void createLiferayRuntimeGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Configuration");
        group.setLayoutData((Object)NewPluginProjectFirstPage.gdhfill());
        group.setLayout((Layout)new GridLayout(3, false));
        this.getModel().addListener((IDataModelListener)this);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SDKManager.getInstance().getDefaultSDK() != null && NewPluginProjectFirstPage.this.getModel().getBooleanProperty("IPluginProjectDataModelProperties.LIFERAY_USE_SDK_LOCATION")) {
                    NewPluginProjectFirstPage.this.getModel().setBooleanProperty("IPluginProjectDataModelProperties.LIFERAY_USE_SDK_LOCATION", false);
                    NewPluginProjectFirstPage.this.getModel().setBooleanProperty("IPluginProjectDataModelProperties.LIFERAY_USE_SDK_LOCATION", true);
                }
                NewPluginProjectFirstPage.this.validatePage(true);
            }
        };
        new LiferaySDKField((Composite)group, this.getModel(), selectionAdapter, "IPluginProjectDataModelProperties.LIFERAY_SDK_NAME", this.synchHelper);
        SWTUtil.createLabel((Composite)group, (String)"Liferay Portal Runtime", (int)1);
        this.serverTargetCombo = new Combo((Composite)group, 2056);
        this.serverTargetCombo.setLayoutData((Object)NewPluginProjectFirstPage.gdhfill());
        Button newServerTargetButton = new Button((Composite)group, 8);
        newServerTargetButton.setText("New ...");
        newServerTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataModelPropertyDescriptor[] preAdditionDescriptors = NewPluginProjectFirstPage.this.model.getValidPropertyDescriptors("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
                boolean isOK = ServerUIUtil.showNewRuntimeWizard((Shell)NewPluginProjectFirstPage.this.getShell(), (String)NewPluginProjectFirstPage.this.getModuleTypeID(), null, (String)"com.liferay.");
                if (isOK) {
                    DataModelPropertyDescriptor[] postAdditionDescriptors = NewPluginProjectFirstPage.this.model.getValidPropertyDescriptors("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
                    Object[] preAddition = new Object[preAdditionDescriptors.length];
                    int i = 0;
                    while (i < preAddition.length) {
                        preAddition[i] = preAdditionDescriptors[i].getPropertyValue();
                        ++i;
                    }
                    Object[] postAddition = new Object[postAdditionDescriptors.length];
                    int i2 = 0;
                    while (i2 < postAddition.length) {
                        postAddition[i2] = postAdditionDescriptors[i2].getPropertyValue();
                        ++i2;
                    }
                    Object newAddition = CoreUtil.getNewObject((Object[])preAddition, (Object[])postAddition);
                    if (newAddition != null) {
                        NewPluginProjectFirstPage.this.model.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", newAddition);
                    }
                }
            }
        });
        Control[] deps = new Control[]{newServerTargetButton};
        this.synchHelper.synchCombo(this.serverTargetCombo, "IFacetProjectCreationDataModelProperties.FACET_RUNTIME", deps);
        if (this.serverTargetCombo.getSelectionIndex() == -1 && this.serverTargetCombo.getVisibleItemCount() != 0) {
            this.serverTargetCombo.select(0);
        }
        SWTUtil.createLabel((Composite)group, (String)"", (int)1);
        Link facetsLink = new Link((Composite)group, 4);
        GridData gd = new GridData(-1, -1, false, false, 1, 1);
        facetsLink.setLayoutData((Object)gd);
        facetsLink.setText("<a href=\"#\">Advanced project configuration...</a>");
        facetsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FacetsSelectionDialog.openDialog((Shell)NewPluginProjectFirstPage.this.getShell(), (IFacetedProjectWorkingCopy)((IFacetedProjectWorkingCopy)NewPluginProjectFirstPage.this.getModel().getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY")));
            }
        });
        SWTUtil.createLabel((Composite)group, (String)"", (int)1);
    }

    protected void createPluginTypeGroup(Composite parent) {
        Group group = SWTUtil.createGroup((Composite)parent, (String)"Plugin Type", (int)2);
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.portletType = SWTUtil.createRadioButton((Composite)group, (String)"Portlet", (Image)this.getPluginImageDescriptor("/icons/e16/portlet.png").createImage(), (boolean)false, (int)1);
        Label l = SWTUtil.createLabel((Composite)group, (int)64, (String)"Create a web application using the portlet framework.", (int)1);
        l.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.synchHelper.synchCheckbox(this.portletType, "IPluginProjectDataModelProperties.PLUGIN_TYPE_PORTLET", null);
        this.hookType = SWTUtil.createRadioButton((Composite)group, (String)"Hook", (Image)this.getPluginImageDescriptor("/icons/e16/hook.png").createImage(), (boolean)false, (int)1);
        l = SWTUtil.createLabel((Composite)group, (int)64, (String)"Override or extend Liferay's default behavior and functionality.", (int)1);
        l.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.synchHelper.synchCheckbox(this.hookType, "IPluginProjectDataModelProperties.PLUGIN_TYPE_HOOK", null);
        this.extType = SWTUtil.createRadioButton((Composite)group, (String)"Ext", (Image)this.getPluginImageDescriptor("/icons/e16/ext.png").createImage(), (boolean)false, (int)1);
        l = SWTUtil.createLabel((Composite)group, (int)64, (String)"Light-weight extension environment for Liferay as a plugin.", (int)1);
        l.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.synchHelper.synchCheckbox(this.extType, "IPluginProjectDataModelProperties.PLUGIN_TYPE_EXT", null);
        this.layoutTemplateType = SWTUtil.createRadioButton((Composite)group, (String)"Layout", (Image)this.getPluginImageDescriptor("/icons/e16/layout.png").createImage(), (boolean)false, (int)1);
        l = SWTUtil.createLabel((Composite)group, (int)64, (String)"Create a new custom layout for Liferay pages.", (int)1);
        l.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.synchHelper.synchCheckbox(this.layoutTemplateType, "IPluginProjectDataModelProperties.PLUGIN_TYPE_LAYOUTTPL", null);
        this.themeType = SWTUtil.createRadioButton((Composite)group, (String)"Theme", (Image)this.getPluginImageDescriptor("/icons/e16/theme.png").createImage(), (boolean)false, (int)1);
        l = SWTUtil.createLabel((Composite)group, (int)64, (String)"Build a custom look and feel for the portal.", (int)1);
        l.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.synchHelper.synchCheckbox(this.themeType, "IPluginProjectDataModelProperties.PLUGIN_TYPE_THEME", null);
    }

    protected void createProjectGroup(Composite parent) {
        IDataModel nestedProjectDM = this.model.getNestedModel("IFacetProjectCreationDataModelProperties.NESTED_PROJECT_DM");
        nestedProjectDM.addListener((IDataModelListener)this);
        this.projectNameGroup = new NewPluginProjectGroup(parent, this.getModel(), nestedProjectDM);
    }

    protected void createSDKGroup(Composite parent) {
        Group group = this.createDefaultGroup(parent, "Liferay Plugin SDK", 2);
        ((GridData)group.getLayoutData()).grabExcessVerticalSpace = false;
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 3;
        gl.marginWidth = 0;
        this.getModel().addListener((IDataModelListener)this);
        Combo sdkCombo = new Combo((Composite)group, 12);
        sdkCombo.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Link configureSDKsLink = new Link((Composite)group, 4);
        configureSDKsLink.setText("<a href=\"#\">Configure SDKs</a>");
        configureSDKsLink.setLayoutData((Object)new GridData(131072, 128, false, false));
        configureSDKsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewPluginProjectFirstPage.this.configureSDKsLinkSelected(e);
            }
        });
        this.synchHelper.synchCombo(sdkCombo, "IPluginProjectDataModelProperties.LIFERAY_SDK_NAME", new Control[]{configureSDKsLink});
    }

    protected void createServerTargetComposite(Composite parent) {
        Group group = new Group(parent, 0);
        ((GridData)group.getLayoutData()).grabExcessVerticalSpace = false;
        group.setText("Liferay runtime");
        group.setLayoutData((Object)NewPluginProjectFirstPage.gdhfill());
        group.setLayout((Layout)new GridLayout(2, false));
        this.serverTargetCombo = new Combo((Composite)group, 2056);
        this.serverTargetCombo.setLayoutData((Object)NewPluginProjectFirstPage.gdhfill());
        Button newServerTargetButton = new Button((Composite)group, 0);
        newServerTargetButton.setText("New ...");
        newServerTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataModelPropertyDescriptor[] preAdditionDescriptors = NewPluginProjectFirstPage.this.model.getValidPropertyDescriptors("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
                boolean isOK = ServerUIUtil.showNewRuntimeWizard((Shell)NewPluginProjectFirstPage.this.getShell(), (String)NewPluginProjectFirstPage.this.getModuleTypeID(), null, (String)"com.liferay.");
                if (isOK) {
                    DataModelPropertyDescriptor[] postAdditionDescriptors = NewPluginProjectFirstPage.this.model.getValidPropertyDescriptors("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
                    Object[] preAddition = new Object[preAdditionDescriptors.length];
                    int i = 0;
                    while (i < preAddition.length) {
                        preAddition[i] = preAdditionDescriptors[i].getPropertyValue();
                        ++i;
                    }
                    Object[] postAddition = new Object[postAdditionDescriptors.length];
                    int i2 = 0;
                    while (i2 < postAddition.length) {
                        postAddition[i2] = postAdditionDescriptors[i2].getPropertyValue();
                        ++i2;
                    }
                    Object newAddition = CoreUtil.getNewObject((Object[])preAddition, (Object[])postAddition);
                    if (newAddition != null) {
                        NewPluginProjectFirstPage.this.model.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", newAddition);
                    }
                }
            }
        });
        Control[] deps = new Control[]{newServerTargetButton};
        this.synchHelper.synchCombo(this.serverTargetCombo, "IFacetProjectCreationDataModelProperties.FACET_RUNTIME", deps);
        if (this.serverTargetCombo.getSelectionIndex() == -1 && this.serverTargetCombo.getVisibleItemCount() != 0) {
            this.serverTargetCombo.select(0);
        }
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout());
        top.setLayoutData((Object)new GridData(1808));
        this.createProjectGroup(top);
        this.createImportProjectLink(top);
        this.createLiferayRuntimeGroup(top);
        this.createPluginTypeGroup(top);
        this.createWorkingSetGroupPanel(top, new String[]{"org.eclipse.ui.resourceWorkingSetPage", "org.eclipse.jdt.ui.JavaWorkingSetPage"});
        this.updateControls();
        return top;
    }

    protected void enter() {
        super.enter();
        String projectType = ((NewPluginProjectWizard)this.getWizard()).getProjectType();
        if (CoreUtil.isNullOrEmpty((String)projectType)) {
            projectType = "liferay.portlet";
        }
        this.setShouldValidatePage(false);
        if ("liferay.portlet".equals(projectType.toLowerCase())) {
            this.getDataModel().setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_PORTLET", (Object)true);
            this.getDataModel().setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_HOOK", (Object)false);
            this.getDataModel().setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_EXT", (Object)false);
            this.getDataModel().setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_LAYOUTTPL", (Object)false);
            this.getDataModel().setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_THEME", (Object)false);
        } else if ("liferay.hook".equals(projectType.toLowerCase())) {
            this.getDataModel().setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_HOOK", (Object)true);
            this.getDataModel().setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_PORTLET", (Object)false);
            this.getDataModel().setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_EXT", (Object)false);
            this.getDataModel().setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_LAYOUTTPL", (Object)false);
            this.getDataModel().setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_THEME", (Object)false);
        } else if ("liferay.ext".equals(projectType.toLowerCase())) {
            this.getDataModel().setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_EXT", (Object)true);
            this.getDataModel().setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_PORTLET", (Object)false);
            this.getDataModel().setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_HOOK", (Object)false);
            this.getDataModel().setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_LAYOUTTPL", (Object)false);
            this.getDataModel().setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_THEME", (Object)false);
        } else if ("liferay.layouttpl".equals(projectType.toLowerCase())) {
            this.getDataModel().setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_LAYOUTTPL", (Object)true);
            this.getDataModel().setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_PORTLET", (Object)false);
            this.getDataModel().setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_HOOK", (Object)false);
            this.getDataModel().setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_EXT", (Object)false);
            this.getDataModel().setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_THEME", (Object)false);
        } else if ("liferay.theme".equals(projectType.toLowerCase())) {
            this.getDataModel().setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_THEME", (Object)true);
            this.getDataModel().setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_LAYOUTTPL", (Object)false);
            this.getDataModel().setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_PORTLET", (Object)false);
            this.getDataModel().setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_HOOK", (Object)false);
            this.getDataModel().setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_EXT", (Object)false);
        }
        this.setShouldValidatePage(true);
    }

    protected IDataModel getModel() {
        return this.model;
    }

    protected ImageDescriptor getPluginImageDescriptor(String path) {
        return ImageDescriptor.createFromURL((URL)ProjectUIPlugin.getDefault().getBundle().getEntry(path));
    }

    protected String[] getValidationPropertyNames() {
        String[] superProperties = super.getValidationPropertyNames();
        List<String> list = Arrays.asList(superProperties);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(list);
        arrayList.add("IPluginProjectDataModelProperties.LIFERAY_SDK_NAME");
        arrayList.add("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        arrayList.add("IProjectCreationPropertiesNew.PROJECT_NAME");
        arrayList.add("IPluginProjectCreationPropertiesNew.DISPLAY_NAME");
        arrayList.add("IFacetDataModelProperties.FACET_PROJECT_NAME");
        arrayList.add("IPluginProjectDataModelProperties.PLUGIN_TYPE_PORTLET");
        arrayList.add("IPluginProjectDataModelProperties.PLUGIN_TYPE_HOOK");
        arrayList.add("IPluginProjectDataModelProperties.PLUGIN_TYPE_EXT");
        arrayList.add("IPluginProjectDataModelProperties.PLUGIN_TYPE_THEME");
        arrayList.add("IPluginProjectDataModelProperties.PLUGIN_TYPE_LAYOUTTPL");
        return arrayList.toArray(new String[0]);
    }

    protected void validatePage(boolean showMessage) {
        if (this.shouldValidatePage) {
            super.validatePage(showMessage);
        }
    }
}

