/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.project.ui.wizard;

import com.liferay.ide.eclipse.project.core.IPortletFramework;
import com.liferay.ide.eclipse.project.core.facet.IPluginProjectDataModelProperties;
import com.liferay.ide.eclipse.project.core.facet.PluginFacetProjectCreationDataModelProvider;
import com.liferay.ide.eclipse.project.ui.IPortletFrameworkDelegate;
import com.liferay.ide.eclipse.project.ui.ProjectUIPlugin;
import com.liferay.ide.eclipse.project.ui.wizard.IPluginWizardFragment;
import com.liferay.ide.eclipse.project.ui.wizard.NewPluginProjectFirstPage;
import com.liferay.ide.eclipse.project.ui.wizard.NewPortletPluginProjectPage;
import com.liferay.ide.eclipse.ui.wizard.INewProjectWizard;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.AntProjectNodeProxy;
import org.eclipse.ant.internal.ui.views.AntView;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.web.ui.internal.wizards.NewProjectDataModelFacetWizard;

public class NewPluginProjectWizard
extends NewProjectDataModelFacetWizard
implements INewProjectWizard,
IPluginProjectDataModelProperties {
    protected NewPluginProjectFirstPage firstPage;
    protected ImageDescriptor liferayWizardImageDescriptor;
    protected NewPortletPluginProjectPage portletPluginPage;
    protected String projectType;

    public NewPluginProjectWizard() {
        this.setupWizard();
    }

    public NewPluginProjectWizard(IDataModel model) {
        super(model);
        this.setupWizard();
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage().equals((Object)this.portletPluginPage) && this.isPluginWizardFragmentEnabled()) {
            return false;
        }
        return super.canFinish();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (((Object)((Object)this.portletPluginPage)).equals(page)) {
            if (this.isPluginWizardFragmentEnabled()) {
                IPortletFramework selectedFramework = this.portletPluginPage.getSelectedPortletFramework();
                IPortletFrameworkDelegate delegate = ProjectUIPlugin.getPortletFrameworkDelegate(selectedFramework.getId());
                IPluginWizardFragment pluginFragment = delegate.getWizardFragment();
                IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)pluginFragment.getDataModelProvider());
                this.getDataModel().addNestedModel("IPluginProjectDataModelProperties.PLUGIN_FRAGMENT_DM", dm);
                pluginFragment.setDataModel(dm);
                pluginFragment.initFragmentDataModel(this.getDataModel(), this.getProjectName());
                pluginFragment.addPages();
                pluginFragment.setHostPage((IWizardPage)this.portletPluginPage);
                return pluginFragment.getNextPage(page);
            }
            return null;
        }
        return super.getNextPage(page);
    }

    public String getProjectType() {
        return this.projectType;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.getDataModel().setBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_PORTLET", true);
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    protected IWizardPage[] createBeginingPages() {
        this.firstPage = this.createFirstPage();
        this.portletPluginPage = new NewPortletPluginProjectPage(this, this.model);
        return new IWizardPage[]{this.firstPage, this.portletPluginPage};
    }

    protected IDataModel createDataModel() {
        try {
            return DataModelFactory.createDataModel((IDataModelProvider)new PluginFacetProjectCreationDataModelProvider());
        }
        catch (Exception e) {
            ProjectUIPlugin.logError(e);
            return null;
        }
    }

    protected NewPluginProjectFirstPage createFirstPage() {
        return new NewPluginProjectFirstPage(this, this.model, "first.page");
    }

    protected ImageDescriptor getDefaultPageImageDescriptor() {
        if (this.liferayWizardImageDescriptor == null) {
            this.liferayWizardImageDescriptor = ImageDescriptor.createFromURL((URL)ProjectUIPlugin.getDefault().getBundle().getEntry("/icons/wizban/plugin_project.png"));
        }
        return this.liferayWizardImageDescriptor;
    }

    protected String getFinalPerspectiveID() {
        return "com.liferay.ide.eclipse.ui.perspective.liferay";
    }

    protected IDataModel getNestedModel() {
        return this.getDataModel().getNestedModel("IFacetProjectCreationDataModelProperties.NESTED_PROJECT_DM");
    }

    protected String getPluginFacetId() {
        IDataModel dm = this.getDataModel();
        if (dm.getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_PORTLET")) {
            return "liferay.portlet";
        }
        if (dm.getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_HOOK")) {
            return "liferay.hook";
        }
        if (dm.getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_EXT")) {
            return "liferay.ext";
        }
        if (dm.getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_LAYOUTTPL")) {
            return "liferay.layouttpl";
        }
        if (dm.getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_THEME")) {
            return "liferay.theme";
        }
        return null;
    }

    protected String getProjectSuffix() {
        if (this.getDataModel().getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_PORTLET")) {
            return "-portlet";
        }
        if (this.getDataModel().getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_HOOK")) {
            return "-hook";
        }
        if (this.getDataModel().getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_EXT")) {
            return "-ext";
        }
        if (this.getDataModel().getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_THEME")) {
            return "-theme";
        }
        if (this.getDataModel().getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_LAYOUTTPL")) {
            return "-layouttpl";
        }
        return null;
    }

    protected IFacetedProjectTemplate getTemplate() {
        return ProjectFacetsManager.getTemplate((String)"liferay.portlet.template");
    }

    protected boolean isPluginWizardFragmentEnabled() {
        IPortletFrameworkDelegate delegate;
        IPortletFramework portletFramework = this.portletPluginPage.getSelectedPortletFramework();
        return portletFramework != null && (delegate = ProjectUIPlugin.getPortletFrameworkDelegate(portletFramework.getId())) != null && delegate.getWizardFragment() != null && delegate.isFragmentEnabled();
    }

    protected void performFinish(IProgressMonitor monitor) throws CoreException {
        this.firstPage.setShouldValidatePage(false);
        String projectName = this.getNestedModel().getStringProperty("IProjectCreationPropertiesNew.PROJECT_NAME");
        if (!projectName.endsWith(this.getProjectSuffix())) {
            this.getNestedModel().setStringProperty("IProjectCreationPropertiesNew.PROJECT_NAME", String.valueOf(projectName) + this.getProjectSuffix());
        }
        this.model.setProperty("IPluginProjectDataModelProperties.PORTLET_NAME", (Object)projectName);
        this.model.setProperty("IPluginProjectDataModelProperties.THEME_NAME", (Object)projectName);
        this.model.setProperty("IPluginProjectDataModelProperties.LAYOUTTPL_NAME", (Object)projectName);
        super.performFinish(monitor);
    }

    protected void postPerformFinish() throws InvocationTargetException {
        if (this.getDataModel().getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_PORTLET")) {
            IPortletFramework portletFramework = (IPortletFramework)this.getDataModel().getProperty("IPluginProjectDataModelProperties.PORTLET_FRAMEWORK");
            portletFramework.postProjectCreated(this.getDataModel(), this.getFacetedProject());
        }
        if (this.isPluginWizardFragmentEnabled()) {
            final IDataModel fragmentModel = this.getDataModel().getNestedModel("IPluginProjectDataModelProperties.PLUGIN_FRAGMENT_DM");
            fragmentModel.setStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", this.getProjectName());
            try {
                this.getContainer().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            fragmentModel.getDefaultOperation().execute(monitor, null);
                        }
                        catch (ExecutionException e) {
                            ProjectUIPlugin.logError("Error executing wizard fragment", (Exception)((Object)e));
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                ProjectUIPlugin.logError("Error executing wizard fragment", e);
            }
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                this.refreshProjectExplorer();
                this.addBuildInAntView();
            }

            private void addBuildInAntView() {
                IFile buildXmlFile;
                IProject project = NewPluginProjectWizard.this.getFacetedProject().getProject();
                if (project != null && (buildXmlFile = project.getFile("build.xml")).exists()) {
                    String buildFileName = buildXmlFile.getFullPath().toString();
                    AntProjectNodeProxy antProject = new AntProjectNodeProxy(buildFileName);
                    project.getName();
                    IViewPart antView = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage().findView("org.eclipse.ant.ui.views.AntView");
                    if (antView instanceof AntView) {
                        ((AntView)antView).addProject((AntProjectNode)antProject);
                    }
                }
            }

            private void refreshProjectExplorer() {
                IViewPart view = null;
                try {
                    view = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage().findView("org.eclipse.ui.navigator.ProjectExplorer");
                }
                catch (Exception exception) {}
                if (view == null) {
                    return;
                }
                CommonViewer viewer = (CommonViewer)view.getAdapter(CommonViewer.class);
                viewer.refresh(true);
            }
        });
        super.postPerformFinish();
    }

    protected void setupWizard() {
        this.setWindowTitle("New Liferay Project");
        this.setShowFacetsSelectionPage(false);
    }
}

