/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.project.ui.wizard;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.project.core.ISDKProjectsImportDataModelProperties;
import com.liferay.ide.eclipse.project.core.ProjectRecord;
import com.liferay.ide.eclipse.ui.util.SWTUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.server.ui.ServerUIUtil;
import org.eclipse.wst.web.ui.internal.wizards.DataModelFacetCreationWizardPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDKProjectConvertWizardPage
extends DataModelFacetCreationWizardPage
implements ISDKProjectsImportDataModelProperties {
    public static final String METADATA_FOLDER = ".metadata";
    protected long lastModified;
    protected String lastPath;
    protected CheckboxTreeViewer projectsList;
    protected Text sdkLocation;
    protected Text sdkVersion;
    protected ProjectRecord[] selectedProjects = new ProjectRecord[0];
    protected Combo serverTargetCombo;
    protected IProject[] wsProjects;

    public SDKProjectConvertWizardPage(IDataModel model, String pageName) {
        super(model, pageName);
        this.setTitle("Convert Project");
        this.setDescription("Convert existing project to Liferay plugin.");
    }

    public void updateProjectsList(String path) {
        Object[] checkedProjects;
        if (path == null || path.length() == 0) {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_ImportProjectsDescription);
            this.selectedProjects = new ProjectRecord[0];
            this.projectsList.refresh(true);
            this.projectsList.setCheckedElements((Object[])this.selectedProjects);
            this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
            this.lastPath = path;
            return;
        }
        final File directory = new File(path);
        long modified = directory.lastModified();
        if (path.equals(this.lastPath) && this.lastModified == modified) {
            return;
        }
        this.lastPath = path;
        this.lastModified = modified;
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(DataTransferMessages.WizardProjectsImportPage_SearchingMessage, 100);
                    monitor.worked(10);
                    if (directory.isDirectory()) {
                        ProjectRecord[] projectToConvert = (ProjectRecord[])SDKProjectConvertWizardPage.this.getDataModel().getProperty("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS");
                        Path dir = new Path(directory.getPath());
                        SDKProjectConvertWizardPage.this.selectedProjects = dir.isPrefixOf(projectToConvert[0].getProjectLocation()) ? projectToConvert : new ProjectRecord[0];
                    } else {
                        monitor.worked(60);
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            IDEWorkbenchPlugin.log((String)e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException interruptedException) {}
        this.projectsList.refresh(true);
        if (!CoreUtil.isNullOrEmpty((Object[])this.selectedProjects)) {
            this.projectsList.setChecked((Object)this.selectedProjects[0], true);
        }
        this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
        if (this.selectedProjects.length == 0) {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_noProjectsToImport, 2);
        }
        if ((checkedProjects = this.projectsList.getCheckedElements()) != null && checkedProjects.length > 0) {
            this.selectedProjects = new ProjectRecord[checkedProjects.length];
            int i = 0;
            while (i < checkedProjects.length) {
                this.selectedProjects[i] = (ProjectRecord)checkedProjects[i];
                ++i;
            }
            this.getDataModel().setProperty("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS", (Object)this.selectedProjects);
        }
    }

    private boolean isLiferayProjectDir(File file) {
        if (file.isDirectory() && this.isValidLiferayProjectDir(file)) {
            File[] contents = file.listFiles();
            boolean hasBuildXml = false;
            boolean hasDocroot = false;
            File[] fileArray = contents;
            int n = contents.length;
            int n2 = 0;
            while (n2 < n) {
                File content = fileArray[n2];
                if (content.getName().equals("build.xml") || file.getName().endsWith("-hook")) {
                    hasBuildXml = true;
                } else if (content.getName().equals("docroot")) {
                    hasDocroot = true;
                }
                ++n2;
            }
            if (hasBuildXml && hasDocroot) {
                return true;
            }
        }
        return false;
    }

    protected boolean collectProjectsFromDirectory(Collection<File> eclipseProjectFiles, Collection<File> liferayProjectDirs, File directory, Set<String> directoriesVisited, boolean recurse, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.subTask(NLS.bind((String)DataTransferMessages.WizardProjectsImportPage_CheckingMessage, (Object)directory.getPath()));
        File[] contents = directory.listFiles();
        if (contents == null) {
            return false;
        }
        if (directoriesVisited == null) {
            directoriesVisited = new HashSet<String>();
            try {
                directoriesVisited.add(directory.getCanonicalPath());
            }
            catch (IOException exception) {
                StatusManager.getManager().handle(StatusUtil.newStatus((int)4, (String)exception.getLocalizedMessage(), (Throwable)exception));
            }
        }
        int i = 0;
        while (i < contents.length) {
            File file = contents[i];
            if (this.isLiferayProjectDir(file)) {
                int currentSize = eclipseProjectFiles.size();
                this.collectProjectsFromDirectory(eclipseProjectFiles, liferayProjectDirs, contents[i], directoriesVisited, false, monitor);
                int newSize = eclipseProjectFiles.size();
                if (newSize == currentSize) {
                    liferayProjectDirs.add(file);
                }
            } else if (file.isFile() && file.getName().equals(".project")) {
                if (!eclipseProjectFiles.contains(file)) {
                    eclipseProjectFiles.add(file);
                }
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < contents.length) {
            block17: {
                if (contents[i].isDirectory() && !contents[i].getName().equals(METADATA_FOLDER)) {
                    block16: {
                        try {
                            String canonicalPath = contents[i].getCanonicalPath();
                            if (directoriesVisited.add(canonicalPath)) break block16;
                            break block17;
                        }
                        catch (IOException exception) {
                            StatusManager.getManager().handle(StatusUtil.newStatus((int)4, (String)exception.getLocalizedMessage(), (Throwable)exception));
                        }
                    }
                    if (!liferayProjectDirs.contains(contents[i]) && recurse) {
                        this.collectProjectsFromDirectory(eclipseProjectFiles, liferayProjectDirs, contents[i], directoriesVisited, recurse, monitor);
                    }
                }
            }
            ++i;
        }
        return true;
    }

    protected void createProjectsList(Composite workArea) {
        Label title = new Label(workArea, 0);
        title.setText("Project to import:");
        title.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.projectsList = new CheckboxTreeViewer(workArea, 2048);
        GridData gridData = new GridData(4, 4, true, true, 3, 1);
        gridData.widthHint = new PixelConverter(this.projectsList.getControl()).convertWidthInCharsToPixels(25);
        gridData.heightHint = new PixelConverter(this.projectsList.getControl()).convertHeightInCharsToPixels(10);
        this.projectsList.getControl().setLayoutData((Object)gridData);
        this.projectsList.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return (Object[])SDKProjectConvertWizardPage.this.getDataModel().getProperty("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS");
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.projectsList.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.projectsList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ProjectRecord element = (ProjectRecord)event.getElement();
                if (element.hasConflicts()) {
                    SDKProjectConvertWizardPage.this.projectsList.setChecked((Object)element, false);
                }
                SDKProjectConvertWizardPage.this.getDataModel().setProperty("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS", (Object)SDKProjectConvertWizardPage.this.projectsList.getCheckedElements());
                SDKProjectConvertWizardPage.this.setPageComplete(SDKProjectConvertWizardPage.this.projectsList.getCheckedElements().length > 0);
            }
        });
        this.projectsList.setInput((Object)this);
        this.projectsList.setComparator(new ViewerComparator());
    }

    protected void createSDKLocationField(Composite topComposite) {
        SWTUtil.createLabel((Composite)topComposite, (int)16384, (String)"Liferay Plugin SDK Location:", (int)1);
        this.sdkLocation = SWTUtil.createText((Composite)topComposite, (int)2);
        this.synchHelper.synchText(this.sdkLocation, "ISDKProjectsImportDataModelProperties.SDK_LOCATION", null);
    }

    protected void createSDKVersionField(Composite topComposite) {
        SWTUtil.createLabel((Composite)topComposite, (int)16384, (String)"Liferay Plugin SDK Version:", (int)1);
        this.sdkVersion = SWTUtil.createText((Composite)topComposite, (int)2);
        this.synchHelper.synchText(this.sdkVersion, "ISDKProjectsImportDataModelProperties.SDK_VERSION", null);
        SWTUtil.createLabel((Composite)topComposite, (String)"", (int)1);
    }

    protected void createTargetRuntimeGroup(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Liferay target runtime:");
        label.setLayoutData((Object)new GridData(32));
        this.serverTargetCombo = new Combo(parent, 2056);
        this.serverTargetCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button newServerTargetButton = new Button(parent, 0);
        newServerTargetButton.setText("New...");
        newServerTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataModelPropertyDescriptor[] preAdditionDescriptors = SDKProjectConvertWizardPage.this.model.getValidPropertyDescriptors("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
                boolean isOK = ServerUIUtil.showNewRuntimeWizard((Shell)SDKProjectConvertWizardPage.this.getShell(), (String)SDKProjectConvertWizardPage.this.getModuleTypeID(), null, (String)"com.liferay.");
                if (isOK) {
                    DataModelPropertyDescriptor[] postAdditionDescriptors = SDKProjectConvertWizardPage.this.model.getValidPropertyDescriptors("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
                    Object[] preAddition = new Object[preAdditionDescriptors.length];
                    int i = 0;
                    while (i < preAddition.length) {
                        preAddition[i] = preAdditionDescriptors[i].getPropertyValue();
                        ++i;
                    }
                    Object[] postAddition = new Object[postAdditionDescriptors.length];
                    int i2 = 0;
                    while (i2 < postAddition.length) {
                        postAddition[i2] = postAdditionDescriptors[i2].getPropertyValue();
                        ++i2;
                    }
                    Object newAddition = CoreUtil.getNewObject((Object[])preAddition, (Object[])postAddition);
                    if (newAddition != null) {
                        SDKProjectConvertWizardPage.this.model.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", newAddition);
                    }
                }
            }
        });
        Control[] deps = new Control[]{newServerTargetButton};
        this.synchHelper.synchCombo(this.serverTargetCombo, "IFacetProjectCreationDataModelProperties.FACET_RUNTIME", deps);
        if (this.serverTargetCombo.getSelectionIndex() == -1 && this.serverTargetCombo.getVisibleItemCount() != 0) {
            this.serverTargetCombo.select(0);
        }
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite topComposite = SWTUtil.createTopComposite((Composite)parent, (int)1);
        GridLayout gl = new GridLayout(3, false);
        topComposite.setLayout((Layout)gl);
        topComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.createSDKLocationField(topComposite);
        this.createSDKVersionField(topComposite);
        SWTUtil.createVerticalSpacer((Composite)topComposite, (int)1, (int)3);
        this.createProjectsList(topComposite);
        this.createTargetRuntimeGroup(topComposite);
        return topComposite;
    }

    protected void enter() {
        super.enter();
        if (this.sdkLocation.getText() != null) {
            this.updateProjectsList(this.sdkLocation.getText());
        }
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"ISDKProjectsImportDataModelProperties.SDK_LOCATION", "ISDKProjectsImportDataModelProperties.SDK_VERSION", "ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS", "IFacetProjectCreationDataModelProperties.FACET_RUNTIME"};
    }

    protected boolean isValidLiferayProjectDir(File dir) {
        String name = dir.getName();
        return name.endsWith("-portlet") || name.endsWith("-ext") || name.endsWith("-hook");
    }

    protected final class ProjectLabelProvider
    extends LabelProvider
    implements IColorProvider {
        protected ProjectLabelProvider() {
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            ProjectRecord projectRecord = (ProjectRecord)element;
            if (projectRecord.hasConflicts()) {
                return SDKProjectConvertWizardPage.this.getShell().getDisplay().getSystemColor(15);
            }
            return null;
        }

        public String getText(Object element) {
            return ((ProjectRecord)element).getProjectLabel();
        }
    }
}

