/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.ui.action;

import com.liferay.ide.eclipse.ui.LiferayUIPlugin;
import com.liferay.ide.eclipse.ui.wizard.INewProjectWizard;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class NewWizardAction
extends Action
implements Comparable {
    public static final String ATT_CLASS = "class";
    public static final String ATT_ICON = "icon";
    public static final String ATT_MENUINDEX = "menuIndex";
    public static final String ATT_NAME = "name";
    public static final String ATT_PROJECTTYPE = "project_type";
    public static final String TAG_CLASS = "class";
    public static final String TAG_DESCRIPTION = "description";
    public static final String TAG_NAME = "name";
    public static final String TAG_PARAMETER = "parameter";
    public static final String TAG_VALUE = "value";
    protected IConfigurationElement fConfigurationElement;
    protected IStructuredSelection fSelection;
    protected Shell fShell;
    protected int menuIndex;
    protected String projectType = null;

    public NewWizardAction(IConfigurationElement element) {
        this.fConfigurationElement = element;
        String description = this.getDescriptionFromConfig(this.fConfigurationElement);
        this.setText("New " + element.getAttribute("name"));
        this.setDescription(description);
        this.setToolTipText(description);
        this.setImageDescriptor(this.getIconFromConfig(this.fConfigurationElement));
        this.setMenuIndex(this.getMenuIndexFromConfig(this.fConfigurationElement));
    }

    public int compareTo(Object o) {
        NewWizardAction action = (NewWizardAction)o;
        return this.getMenuIndex() - action.getMenuIndex();
    }

    public int getMenuIndex() {
        return this.menuIndex;
    }

    public String getProjectType() {
        return this.projectType;
    }

    public void run() {
        Shell shell = this.getShell();
        try {
            INewWizard wizard = this.createWizard();
            if (wizard instanceof INewProjectWizard && this.projectType != null) {
                ((INewProjectWizard)wizard).setProjectType(this.projectType);
            }
            wizard.init(PlatformUI.getWorkbench(), this.getSelection());
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            PixelConverter converter = new PixelConverter(JFaceResources.getDialogFont());
            dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
            dialog.create();
            int res = dialog.open();
            this.notifyResult(res == 0);
        }
        catch (CoreException coreException) {}
    }

    public void setMenuIndex(int menuIndex) {
        this.menuIndex = menuIndex;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    public void setShell(Shell shell) {
        this.fShell = shell;
    }

    private IStructuredSelection evaluateCurrentSelection() {
        ISelection selection;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (selection = window.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    private String getDescriptionFromConfig(IConfigurationElement config) {
        IConfigurationElement[] children = config.getChildren(TAG_DESCRIPTION);
        if (children.length >= 1) {
            return children[0].getValue();
        }
        return "";
    }

    private ImageDescriptor getIconFromConfig(IConfigurationElement config) {
        String iconName = config.getAttribute(ATT_ICON);
        if (iconName != null) {
            return LiferayUIPlugin.imageDescriptorFromPlugin((String)config.getContributor().getName(), (String)iconName);
        }
        return null;
    }

    private int getMenuIndexFromConfig(IConfigurationElement config) {
        IConfigurationElement[] classElements = config.getChildren("class");
        if (classElements.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = classElements;
            int n = classElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] paramElements;
                IConfigurationElement classElement = iConfigurationElementArray[n2];
                IConfigurationElement[] iConfigurationElementArray2 = paramElements = classElement.getChildren(TAG_PARAMETER);
                int n3 = paramElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement paramElement = iConfigurationElementArray2[n4];
                    if (ATT_MENUINDEX.equals(paramElement.getAttribute("name"))) {
                        return Integer.parseInt(paramElement.getAttribute(TAG_VALUE));
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return Integer.MAX_VALUE;
    }

    private String getProjectTypeFromConfig(IConfigurationElement config) {
        IConfigurationElement[] classElements = config.getChildren("class");
        if (classElements.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = classElements;
            int n = classElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] paramElements;
                IConfigurationElement classElement = iConfigurationElementArray[n2];
                IConfigurationElement[] iConfigurationElementArray2 = paramElements = classElement.getChildren(TAG_PARAMETER);
                int n3 = paramElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement paramElement = iConfigurationElementArray2[n4];
                    if (ATT_PROJECTTYPE.equals(paramElement.getAttribute("name"))) {
                        return paramElement.getAttribute(TAG_VALUE);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    protected INewWizard createWizard() throws CoreException {
        return (INewWizard)CoreUtility.createExtension((IConfigurationElement)this.fConfigurationElement, (String)"class");
    }

    protected IStructuredSelection getSelection() {
        if (this.fSelection == null) {
            return this.evaluateCurrentSelection();
        }
        return this.fSelection;
    }

    protected Shell getShell() {
        if (this.fShell == null) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        return this.fShell;
    }
}

