/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.ui.util;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathModel;
import org.eclipse.jdt.internal.debug.ui.classpath.IClasspathEntry;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;

public abstract class LaunchHelper
implements IDebugEventSetListener {
    protected String[] launchArgs = new String[0];
    protected boolean launchCaptureInConsole = true;
    protected String launchConfigTypeId;
    protected boolean launchInBackground = true;
    protected boolean launchIsPrivate = true;
    protected boolean launchSync = true;
    protected String mainClass;
    protected String mode = "run";
    protected ILaunch runningLaunch;

    public LaunchHelper(String launchConfigTypeId) {
        this.launchConfigTypeId = launchConfigTypeId;
    }

    public ILaunchConfigurationWorkingCopy createLaunchConfiguration() throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(this.launchConfigTypeId);
        String name = DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(this.getNewLaunchConfigurationName());
        ILaunchConfigurationWorkingCopy launchConfig = type.newInstance(null, name);
        launchConfig.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", this.isLaunchInBackground());
        launchConfig.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", this.isLaunchCaptureInConsole());
        launchConfig.setAttribute("org.eclipse.debug.ui.private", this.isLaunchIsPrivate());
        IRuntimeClasspathEntry[] classpath = this.getClasspath(launchConfig);
        ArrayList<String> mementos = new ArrayList<String>(classpath.length);
        int i = 0;
        while (i < classpath.length) {
            IRuntimeClasspathEntry entry = classpath[i];
            mementos.add(entry.getMemento());
            ++i;
        }
        launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
        launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, mementos);
        if (this.mainClass != null) {
            launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.mainClass);
        }
        if (this.launchArgs != null && this.launchArgs.length > 0) {
            StringBuilder sb = new StringBuilder();
            int i2 = 0;
            while (i2 < this.launchArgs.length) {
                sb.append("\"" + this.launchArgs[i2] + "\" ");
                ++i2;
            }
            launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, sb.toString());
        }
        return launchConfig;
    }

    public String[] getLaunchArgs() {
        return this.launchArgs;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getMode() {
        return this.mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            if (event.getSource() instanceof IProcess && ((IProcess)event.getSource()).getLaunch().equals(this.runningLaunch) && event.getKind() == 8) {
                LaunchHelper launchHelper = this;
                synchronized (launchHelper) {
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                }
            }
            ++n2;
        }
    }

    public boolean isLaunchCaptureInConsole() {
        return this.launchCaptureInConsole;
    }

    public boolean isLaunchInBackground() {
        return this.launchInBackground;
    }

    public boolean isLaunchIsPrivate() {
        return this.launchIsPrivate;
    }

    public boolean isLaunchRunning() {
        return this.runningLaunch != null && !this.runningLaunch.isTerminated() && !this.runningLaunch.getProcesses()[0].isTerminated();
    }

    public boolean isLaunchSync() {
        return this.launchSync;
    }

    public void launch(ILaunchConfiguration config, String mode, IProgressMonitor monitor) throws CoreException {
        if (config == null) {
            throw new IllegalArgumentException("Launch config cannot be null");
        }
        if (this.isLaunchSync()) {
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        }
        ILaunch launch = config.launch(mode, monitor);
        if (this.isLaunchSync()) {
            this.runningLaunch = launch;
            try {
                try {
                    while (this.isLaunchRunning()) {
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.runningLaunch.terminate();
                    this.runningLaunch = null;
                }
            }
            finally {
                this.runningLaunch = null;
            }
        }
    }

    public void launch(IProgressMonitor monitor) throws CoreException {
        ILaunchConfigurationWorkingCopy config = this.createLaunchConfiguration();
        this.launch((ILaunchConfiguration)config, this.mode, monitor);
    }

    public void setLaunchArgs(String[] launchArgs) {
        this.launchArgs = launchArgs;
    }

    public void setLaunchCaptureInConsole(boolean launchCaptureInConsole) {
        this.launchCaptureInConsole = launchCaptureInConsole;
    }

    public void setLaunchInBackground(boolean launchInBackground) {
        this.launchInBackground = launchInBackground;
    }

    public void setLaunchIsPrivate(boolean launchIsPrivate) {
        this.launchIsPrivate = launchIsPrivate;
    }

    public void setLaunchSync(boolean sync) {
        this.launchSync = sync;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    protected abstract void addUserEntries(ClasspathModel var1) throws CoreException;

    protected IRuntimeClasspathEntry[] getClasspath(ILaunchConfigurationWorkingCopy config) throws CoreException {
        ClasspathModel model = new ClasspathModel();
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, this.getClasspathProviderAttributeValue());
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
        IRuntimeClasspathEntry[] defaultEntries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)config);
        int i = 0;
        while (i < defaultEntries.length) {
            IRuntimeClasspathEntry entry = defaultEntries[i];
            switch (entry.getClasspathProperty()) {
                case 3: {
                    model.addEntry(1, entry);
                    break;
                }
                default: {
                    model.addEntry(0, entry);
                }
            }
            ++i;
        }
        this.addUserEntries(model);
        return this.getClasspathEntries(model);
    }

    protected IRuntimeClasspathEntry[] getClasspathEntries(ClasspathModel model) {
        IRuntimeClasspathEntry entry;
        IClasspathEntry[] boot = model.getEntries(0);
        IClasspathEntry[] user = model.getEntries(1);
        ArrayList<IRuntimeClasspathEntry> entries = new ArrayList<IRuntimeClasspathEntry>(boot.length + user.length);
        int i = 0;
        while (i < boot.length) {
            IClasspathEntry bootEntry = boot[i];
            entry = null;
            if (bootEntry instanceof ClasspathEntry) {
                entry = ((ClasspathEntry)bootEntry).getDelegate();
            } else if (bootEntry instanceof IRuntimeClasspathEntry) {
                entry = (IRuntimeClasspathEntry)boot[i];
            }
            if (entry != null) {
                if (entry.getClasspathProperty() == 3) {
                    entry.setClasspathProperty(2);
                }
                entries.add(entry);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < user.length) {
            IClasspathEntry userEntry = user[i2];
            entry = null;
            if (userEntry instanceof ClasspathEntry) {
                entry = ((ClasspathEntry)userEntry).getDelegate();
            } else if (userEntry instanceof IRuntimeClasspathEntry) {
                entry = (IRuntimeClasspathEntry)user[i2];
            }
            if (entry != null) {
                entry.setClasspathProperty(3);
                entries.add(entry);
            }
            ++i2;
        }
        return entries.toArray(new IRuntimeClasspathEntry[entries.size()]);
    }

    protected String getClasspathProviderAttributeValue() {
        return null;
    }

    protected IVMInstall getDefaultVMInstall(ILaunchConfiguration config) {
        IVMInstall defaultVMInstall;
        try {
            defaultVMInstall = JavaRuntime.computeVMInstall((ILaunchConfiguration)config);
        }
        catch (CoreException coreException) {
            defaultVMInstall = JavaRuntime.getDefaultVMInstall();
        }
        return defaultVMInstall;
    }

    protected String getNewLaunchConfigurationName() {
        return this.getClass().getName();
    }
}

