/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.ui.util;

import com.liferay.ide.eclipse.ui.DebugGroup;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SWTUtil {
    private static FontMetrics fontMetrics;

    protected static void initializeDialogUnits(Control testControl) {
        GC gc = new GC((Drawable)testControl);
        gc.setFont(JFaceResources.getDialogFont());
        fontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    protected static int getButtonWidthHint(Button button) {
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static Button createButton(Composite comp, String label) {
        Button b = new Button(comp, 8);
        b.setText(label);
        if (fontMetrics == null) {
            SWTUtil.initializeDialogUnits((Control)comp);
        }
        GridData data = new GridData(256);
        data.widthHint = SWTUtil.getButtonWidthHint(b);
        b.setLayoutData((Object)data);
        return b;
    }

    public static boolean showPreferencePage(String id, Shell shell) {
        PreferenceManager manager = PlatformUI.getWorkbench().getPreferenceManager();
        IPreferenceNode node = manager.find("org.eclipse.jdt.ui.preferences.JavaBasePreferencePage").findSubNode(id);
        PreferenceManager manager2 = new PreferenceManager();
        manager2.addToRoot(node);
        PreferenceDialog dialog = new PreferenceDialog(shell, manager2);
        dialog.create();
        return dialog.open() == 0;
    }

    public static void selectItem(Combo combo, String item) {
        if (combo == null || item == null) {
            return;
        }
        String[] items = combo.getItems();
        if (items != null && items.length > 0) {
            int i = 0;
            while (i < items.length) {
                if (item.equals(items[i])) {
                    combo.select(i);
                    return;
                }
                ++i;
            }
        }
    }

    public static Label createWrapLabel(Composite parent, String text, int hspan, int wrapwidth) {
        Label l = new Label(parent, 64);
        l.setFont(parent.getFont());
        l.setText(text);
        GridData gd = new GridData(768);
        gd.horizontalSpan = hspan;
        gd.widthHint = wrapwidth;
        l.setLayoutData((Object)gd);
        return l;
    }

    public static void createVerticalSpacer(Composite comp, int numlines, int hspan) {
        Label lbl = new Label(comp, 0);
        GridData gd = new GridData(768);
        gd.heightHint = numlines;
        gd.horizontalSpan = hspan;
        lbl.setLayoutData((Object)gd);
    }

    public static void createHorizontalSpacer(Composite comp, int hSpan) {
        Label l = new Label(comp, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = hSpan;
        l.setLayoutData((Object)gd);
    }

    public static Composite createComposite(Composite parent, int columns, int hspan, int fill) {
        Composite g = new Composite(parent, 0);
        g.setLayout((Layout)new GridLayout(columns, false));
        g.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    public static Label createLabel(Composite parent, String text, int hspan) {
        return SWTUtil.createLabel(parent, 0, text, hspan);
    }

    public static Label createLabel(Composite parent, int style, String text, int hspan) {
        Label l = new Label(parent, style);
        l.setFont(parent.getFont());
        l.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = hspan;
        l.setLayoutData((Object)gd);
        return l;
    }

    public static Link createLink(Composite parent, int style, String text, int hspan) {
        Link l = new Link(parent, style);
        l.setFont(parent.getFont());
        l.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = hspan;
        l.setLayoutData((Object)gd);
        return l;
    }

    public static Composite createComposite(Composite parent, int columns, int hspan, int fill, int marginwidth, int marginheight) {
        Composite g = new Composite(parent, 0);
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = marginwidth;
        layout.marginHeight = marginheight;
        g.setLayout((Layout)layout);
        g.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    public static Button createPushButton(Composite parent, String label, Image image) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        if (image != null) {
            button.setImage(image);
        }
        if (label != null) {
            button.setText(label);
        }
        GridData gd = new GridData();
        button.setLayoutData((Object)gd);
        if (fontMetrics == null) {
            SWTUtil.initializeDialogUnits((Control)parent);
        }
        SWTUtil.setButtonDimensionHint(button);
        return button;
    }

    public static void setButtonDimensionHint(Button button) {
        Object gd = button.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = SWTUtil.getButtonWidthHint(button);
            ((GridData)gd).horizontalAlignment = 4;
        }
    }

    public static Text createSingleText(Composite parent, int hspan) {
        Text t = new Text(parent, 2052);
        t.setFont(parent.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = hspan;
        t.setLayoutData((Object)gd);
        return t;
    }

    public static Button createCheckButton(Composite parent, String label, Image image, boolean checked, int hspan) {
        Button button = new Button(parent, 32);
        button.setFont(parent.getFont());
        button.setSelection(checked);
        if (image != null) {
            button.setImage(image);
        }
        if (label != null) {
            button.setText(label);
        }
        GridData gd = new GridData();
        gd.horizontalSpan = hspan;
        button.setLayoutData((Object)gd);
        if (fontMetrics == null) {
            SWTUtil.initializeDialogUnits((Control)parent);
        }
        SWTUtil.setButtonDimensionHint(button);
        return button;
    }

    public static Composite createTopComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.widthHint = 300;
        composite.setLayoutData((Object)data);
        return composite;
    }

    public static Button createRadioButton(Composite parent, String label, Image image, boolean checked, int hspan) {
        Button button = new Button(parent, 16);
        button.setFont(parent.getFont());
        button.setSelection(checked);
        if (image != null) {
            button.setImage(image);
        }
        if (label != null) {
            button.setText(label);
        }
        GridData gd = new GridData();
        gd.horizontalSpan = hspan;
        button.setLayoutData((Object)gd);
        if (fontMetrics == null) {
            SWTUtil.initializeDialogUnits((Control)parent);
        }
        SWTUtil.setButtonDimensionHint(button);
        return button;
    }

    public static Group createDebugGroup(Composite parent, String text, int numColumns) {
        DebugGroup group = new DebugGroup(parent, 0);
        group.setText(text);
        GridLayout layout = new GridLayout(numColumns, false);
        group.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.widthHint = 300;
        group.setLayoutData(data);
        return group;
    }

    public static Group createGroup(Composite parent, String text, int numColumns) {
        Group group = new Group(parent, 0);
        group.setText(text);
        GridLayout layout = new GridLayout(numColumns, false);
        group.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.widthHint = 300;
        group.setLayoutData((Object)data);
        return group;
    }

    public static Text createText(Composite parent, int hspan) {
        return SWTUtil.createText(parent, 2052, hspan);
    }

    public static Text createText(Composite parent, int style, int hspan) {
        Text text = new Text(parent, style);
        GridData gd = new GridData(768);
        gd.horizontalSpan = hspan;
        text.setLayoutData((Object)gd);
        return text;
    }

    public static void createSeparator(Composite parent, int hspan) {
        Label label = new Label(parent, 258);
        GridData gd = new GridData(4, 0x1000000, true, false, hspan, 1);
        label.setLayoutData((Object)gd);
    }
}

