/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.ui.util;

import com.liferay.ide.eclipse.ui.LiferayUIPlugin;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class UIUtil {
    public static void async(Runnable runnable) {
        if (runnable != null) {
            try {
                Display.getDefault().asyncExec(runnable);
            }
            catch (Throwable throwable) {}
        }
    }

    public static Shell getActiveShell() {
        final Shell[] retval = new Shell[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                retval[0] = Display.getDefault().getActiveShell();
            }
        });
        return retval[0];
    }

    public static ImageDescriptor getPluginImageDescriptor(String symbolicName, String imagePath) {
        URL entry;
        Bundle bundle = Platform.getBundle((String)symbolicName);
        if (bundle != null && (entry = bundle.getEntry(imagePath)) != null) {
            return ImageDescriptor.createFromURL((URL)entry);
        }
        return null;
    }

    public static void postInfo(final String title, final String msg) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)title, (String)msg);
            }
        });
    }

    public static void postInfoWithToggle(final String title, final String msg, final String toggleMessage, final boolean toggleState, final IPersistentPreferenceStore store, final String key) {
        if (store == null || key == null || store.getString(key).equals("never")) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openInformation((Shell)Display.getDefault().getActiveShell(), (String)title, (String)msg, (String)toggleMessage, (boolean)toggleState, (IPreferenceStore)store, (String)key);
                try {
                    if (dialog.getToggleState()) {
                        store.setValue(key, "never");
                        store.save();
                    }
                }
                catch (IOException iOException) {}
            }
        });
    }

    public static boolean promptQuestion(final String title, final String message) {
        final boolean[] retval = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                retval[0] = MessageDialog.openQuestion((Shell)UIUtil.getActiveShell(), (String)title, (String)message);
            }
        });
        return retval[0];
    }

    public static IViewPart showView(String viewId) {
        try {
            IViewPart view = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage().showView(viewId);
            return view;
        }
        catch (PartInitException e) {
            LiferayUIPlugin.logError((Exception)((Object)e));
            return null;
        }
    }
}

