/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.ui.wizard;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class RenameDialog
extends SelectionStatusDialog {
    private ArrayList oldNames;
    private String oldName;
    private String newName;
    private Text text;
    private IStatus status;
    private boolean isCaseSensitive;
    private IInputValidator fValidator;

    public RenameDialog(Shell shell, String oldName) {
        super(shell);
        this.isCaseSensitive = false;
        this.initialize();
        this.setOldName(oldName);
    }

    public RenameDialog(Shell shell, boolean isCaseSensitive, String[] names, String oldName) {
        super(shell);
        this.isCaseSensitive = isCaseSensitive;
        this.initialize();
        if (names != null) {
            int i = 0;
            while (i < names.length) {
                this.addOldName(names[i]);
                ++i;
            }
        }
        this.setOldName(oldName);
    }

    public void initialize() {
        this.oldNames = new ArrayList();
        this.setStatusLineAboveButtons(true);
    }

    public void addOldName(String oldName) {
        if (!this.oldNames.contains(oldName)) {
            this.oldNames.add(oldName);
        }
    }

    public void setOldName(String oldName) {
        this.oldName = oldName;
        this.addOldName(oldName);
        if (this.text != null) {
            this.text.setText(oldName);
        }
        this.newName = oldName;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 9;
        layout.marginHeight = 9;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        Label label = new Label(container, 0);
        label.setText("Enter new name");
        this.text = new Text(container, 2052);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RenameDialog.this.textChanged(RenameDialog.this.text.getText());
            }
        });
        gd = new GridData(768);
        this.text.setLayoutData((Object)gd);
        RenameDialog.applyDialogFont((Control)container);
        return container;
    }

    public int open() {
        this.text.setText(this.oldName);
        this.text.selectAll();
        Button okButton = this.getButton(0);
        this.status = new Status(0, "com.liferay.ide.eclipse.ui", 0, "", null);
        this.updateStatus(this.status);
        okButton.setEnabled(false);
        return super.open();
    }

    private void textChanged(String text) {
        String message;
        Button okButton = this.getButton(0);
        if (this.fValidator != null && (message = this.fValidator.isValid(text)) != null) {
            this.status = new Status(4, "com.liferay.ide.eclipse.ui", 4, message, null);
            this.updateStatus(this.status);
            okButton.setEnabled(false);
            return;
        }
        int i = 0;
        while (i < this.oldNames.size()) {
            if (this.isCaseSensitive && text.equals(this.oldNames.get(i)) || !this.isCaseSensitive && text.equalsIgnoreCase(this.oldNames.get(i).toString())) {
                this.status = new Status(4, "com.liferay.ide.eclipse.ui", 4, "Name already exists", null);
                this.updateStatus(this.status);
                okButton.setEnabled(false);
                break;
            }
            okButton.setEnabled(true);
            this.status = new Status(0, "com.liferay.ide.eclipse.ui", 0, "", null);
            this.updateStatus(this.status);
            ++i;
        }
    }

    public String getNewName() {
        return this.newName;
    }

    protected void okPressed() {
        this.newName = this.text.getText().trim();
        super.okPressed();
    }

    protected void computeResult() {
    }

    public void setTitle(String title) {
        this.getShell().setText(title);
    }

    public void setInputValidator(IInputValidator validator) {
        this.fValidator = validator;
    }
}

