/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jsp.jasper;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.internal.jsp.jasper.JspClassLoader;
import org.osgi.framework.Bundle;

public class JspServlet
extends HttpServlet {
    private static final long serialVersionUID = -4110476909131707652L;
    private Servlet jspServlet = new org.apache.jasper.servlet.JspServlet();
    Bundle bundle;
    private URLClassLoader jspLoader;
    String bundleResourcePath;
    String alias;

    public JspServlet(Bundle bundle, String bundleResourcePath, String alias) {
        this.bundle = bundle;
        this.bundleResourcePath = bundleResourcePath == null || bundleResourcePath.equals("/") ? "" : bundleResourcePath;
        this.alias = alias == null || alias.equals("/") ? null : alias;
        this.jspLoader = new JspClassLoader(bundle);
    }

    public JspServlet(Bundle bundle, String bundleResourcePath) {
        this(bundle, bundleResourcePath, null);
    }

    public void init(ServletConfig config) throws ServletException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.jspLoader);
            this.jspServlet.init((ServletConfig)new ServletConfigAdaptor(config));
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public void destroy() {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.jspLoader);
            this.jspServlet.destroy();
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if (pathInfo != null && pathInfo.startsWith("/WEB-INF/")) {
            response.sendError(404);
            return;
        }
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.jspLoader);
            this.jspServlet.service((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public ServletConfig getServletConfig() {
        return this.jspServlet.getServletConfig();
    }

    public String getServletInfo() {
        return this.jspServlet.getServletInfo();
    }

    private class ServletConfigAdaptor
    implements ServletConfig {
        private ServletConfig config;
        private ServletContext context;

        public ServletConfigAdaptor(ServletConfig config) {
            this.config = config;
            this.context = new ServletContextAdaptor(config.getServletContext());
        }

        public String getInitParameter(String arg0) {
            return this.config.getInitParameter(arg0);
        }

        public Enumeration getInitParameterNames() {
            return this.config.getInitParameterNames();
        }

        public ServletContext getServletContext() {
            return this.context;
        }

        public String getServletName() {
            return this.config.getServletName();
        }
    }

    private class ServletContextAdaptor
    implements ServletContext {
        private ServletContext delegate;

        public ServletContextAdaptor(ServletContext delegate) {
            this.delegate = delegate;
        }

        public URL getResource(String name) throws MalformedURLException {
            String file;
            Enumeration entryPaths;
            String resourceName;
            int lastSlash;
            if (JspServlet.this.alias != null && name.startsWith(JspServlet.this.alias)) {
                name = name.substring(JspServlet.this.alias.length());
            }
            if ((lastSlash = (resourceName = String.valueOf(JspServlet.this.bundleResourcePath) + name).lastIndexOf(47)) == -1) {
                return null;
            }
            String path = resourceName.substring(0, lastSlash);
            if (path.length() == 0) {
                path = "/";
            }
            if ((entryPaths = JspServlet.this.bundle.findEntries(path, file = this.sanitizeEntryName(resourceName.substring(lastSlash + 1)), false)) != null && entryPaths.hasMoreElements()) {
                return (URL)entryPaths.nextElement();
            }
            return this.delegate.getResource(name);
        }

        private String sanitizeEntryName(String name) {
            StringBuffer buffer = null;
            int i = 0;
            while (i < name.length()) {
                char c = name.charAt(i);
                switch (c) {
                    case '*': 
                    case '\\': {
                        if (buffer == null) {
                            buffer = new StringBuffer(name.length() + 16);
                            buffer.append(name.substring(0, i));
                        }
                        buffer.append('\\').append(c);
                        break;
                    }
                    default: {
                        if (buffer == null) break;
                        buffer.append(c);
                    }
                }
                ++i;
            }
            return buffer == null ? name : buffer.toString();
        }

        public InputStream getResourceAsStream(String name) {
            try {
                URL resourceURL = this.getResource(name);
                if (resourceURL != null) {
                    return resourceURL.openStream();
                }
            }
            catch (IOException e) {
                this.log("Error opening stream for resource '" + name + "'", e);
            }
            return null;
        }

        public Set getResourcePaths(String name) {
            HashSet<String> result = this.delegate.getResourcePaths(name);
            Enumeration e = JspServlet.this.bundle.findEntries(String.valueOf(JspServlet.this.bundleResourcePath) + name, null, false);
            if (e != null) {
                if (result == null) {
                    result = new HashSet<String>();
                }
                while (e.hasMoreElements()) {
                    URL entryURL = (URL)e.nextElement();
                    result.add(entryURL.getFile().substring(JspServlet.this.bundleResourcePath.length()));
                }
            }
            return result;
        }

        public RequestDispatcher getRequestDispatcher(String arg0) {
            return this.delegate.getRequestDispatcher(arg0);
        }

        public Object getAttribute(String arg0) {
            return this.delegate.getAttribute(arg0);
        }

        public Enumeration getAttributeNames() {
            return this.delegate.getAttributeNames();
        }

        public ServletContext getContext(String arg0) {
            return this.delegate.getContext(arg0);
        }

        public String getInitParameter(String arg0) {
            return this.delegate.getInitParameter(arg0);
        }

        public Enumeration getInitParameterNames() {
            return this.delegate.getInitParameterNames();
        }

        public int getMajorVersion() {
            return this.delegate.getMajorVersion();
        }

        public String getMimeType(String arg0) {
            return this.delegate.getMimeType(arg0);
        }

        public int getMinorVersion() {
            return this.delegate.getMinorVersion();
        }

        public RequestDispatcher getNamedDispatcher(String arg0) {
            return this.delegate.getNamedDispatcher(arg0);
        }

        public String getRealPath(String arg0) {
            return this.delegate.getRealPath(arg0);
        }

        public String getServerInfo() {
            return this.delegate.getServerInfo();
        }

        public Servlet getServlet(String arg0) throws ServletException {
            return this.delegate.getServlet(arg0);
        }

        public String getServletContextName() {
            return this.delegate.getServletContextName();
        }

        public Enumeration getServletNames() {
            return this.delegate.getServletNames();
        }

        public Enumeration getServlets() {
            return this.delegate.getServlets();
        }

        public void log(Exception arg0, String arg1) {
            this.delegate.log(arg0, arg1);
        }

        public void log(String arg0, Throwable arg1) {
            this.delegate.log(arg0, arg1);
        }

        public void log(String arg0) {
            this.delegate.log(arg0);
        }

        public void removeAttribute(String arg0) {
            this.delegate.removeAttribute(arg0);
        }

        public void setAttribute(String arg0, Object arg1) {
            this.delegate.setAttribute(arg0, arg1);
        }

        public String getContextPath() {
            try {
                Method getContextPathMethod = this.delegate.getClass().getMethod("getContextPath", null);
                return (String)getContextPathMethod.invoke((Object)this.delegate, null);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

