/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.theme.core;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.project.core.facet.IPluginFacetConstants;
import com.liferay.ide.eclipse.project.core.util.ProjectUtil;
import com.liferay.ide.eclipse.sdk.SDK;
import com.liferay.ide.eclipse.server.core.ILiferayRuntime;
import com.liferay.ide.eclipse.server.util.ServerUtil;
import com.liferay.ide.eclipse.theme.core.ThemeCore;
import com.liferay.ide.eclipse.theme.core.operation.ThemeDescriptorHelper;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;

public class ThemeCSSBuilder
extends IncrementalProjectBuilder {
    public static final String ID = "com.liferay.ide.eclipse.theme.core.cssBuilder";

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) {
        if (kind == 6) {
            this.fullBuild(args, monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(args, monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) {
        int deltaKind = delta.getKind();
        if (deltaKind == 2 || deltaKind == 16) {
            return;
        }
        final boolean[] buildCSS = new boolean[1];
        try {
            delta.accept(new IResourceDeltaVisitor(){
                private IFolder docroot = null;

                public boolean visit(IResourceDelta delta) {
                    IPath fullResourcePath = delta.getResource().getFullPath();
                    String[] stringArray = fullResourcePath.segments();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String segment = stringArray[n2];
                        if ("_diffs".equals(segment)) {
                            IFolder diffs;
                            if (this.docroot == null) {
                                this.docroot = ProjectUtil.getDocroot((IProject)ThemeCSSBuilder.this.getProject());
                            }
                            if ((diffs = this.docroot.getFolder("_diffs")).exists() && diffs.getFullPath().isPrefixOf(fullResourcePath)) {
                                buildCSS[0] = true;
                                return false;
                            }
                        }
                        ++n2;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (buildCSS[0]) {
            try {
                ThemeCSSBuilder.cssBuild(this.getProject());
            }
            catch (CoreException e) {
                ThemeCore.logError("Error in Theme CSS Builder", (Exception)((Object)e));
            }
        }
    }

    protected void fullBuild(Map args, IProgressMonitor monitor) {
        try {
            if (this.shouldFullBuild(args)) {
                ThemeCSSBuilder.cssBuild(this.getProject(args));
            }
        }
        catch (Exception e) {
            ThemeCore.logError("Full build failed for Theme CSS Builder", e);
        }
    }

    protected IProject getProject(Map args) {
        return this.getProject();
    }

    protected boolean shouldFullBuild(Map args) throws CoreException {
        Object[] diffMembers;
        IFolder diffs;
        IFolder docroot = ProjectUtil.getDocroot((IProject)this.getProject());
        return docroot != null && (diffs = docroot.getFolder("_diffs")).exists() && !CoreUtil.isNullOrEmpty((Object[])(diffMembers = diffs.members()));
    }

    public static IStatus cssBuild(IProject project) throws CoreException {
        SDK sdk = ProjectUtil.getSDK((IProject)project, (IProjectFacet)IPluginFacetConstants.LIFERAY_THEME_PROJECT_FACET);
        if (sdk == null) {
            throw new CoreException(ThemeCore.createErrorStatus("No SDK for project configured. Could not build theme."));
        }
        ILiferayRuntime liferayRuntime = ServerUtil.getLiferayRuntime((IProject)project);
        if (liferayRuntime == null) {
            throw new CoreException(ThemeCore.createErrorStatus("Could not get portal runtime for project.  Could not build theme."));
        }
        IStatus status = sdk.compileThemePlugin(project, null);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        IFolder docroot = ProjectUtil.getDocroot((IProject)project);
        IFile lookAndFeelFile = docroot.getFile("WEB-INF/liferay-look-and-feel.xml");
        if (!lookAndFeelFile.exists()) {
            String id = project.getName().replaceAll("-theme", "");
            IFile propsFile = docroot.getFile("WEB-INF/liferay-plugin-package.properties");
            String name = id;
            if (propsFile.exists()) {
                Properties props = new Properties();
                try {
                    props.load(propsFile.getContents());
                    String nameValue = props.getProperty("name");
                    if (!CoreUtil.isNullOrEmpty((String)nameValue)) {
                        name = nameValue;
                    }
                }
                catch (IOException e) {
                    ThemeCore.logError("Unable to load plugin package properties.", e);
                }
            }
            if (liferayRuntime != null) {
                ThemeDescriptorHelper.createDefaultFile(lookAndFeelFile, String.valueOf(liferayRuntime.getPortalVersion()) + "+", id, name);
            }
        }
        if (docroot != null && docroot.exists()) {
            docroot.refreshLocal(2, null);
        }
        return status;
    }
}

