/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.ClipboardCopier;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class CopyTaskDetailsAction
extends BaseSelectionListenerAction {
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.copy";
    private Mode mode;

    public CopyTaskDetailsAction(Mode mode) {
        super("");
        this.setMode(mode);
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        Assert.isNotNull((Object)((Object)mode));
        this.mode = mode;
        switch (mode) {
            case KEY: {
                this.setText(Messages.CopyTaskDetailsAction_ID_Menu_Label);
                break;
            }
            case URL: {
                this.setText(Messages.CopyTaskDetailsAction_Url_Menu_Label);
                break;
            }
            case SUMMARY: {
                this.setText(Messages.CopyTaskDetailsAction_Summary_Menu_Label);
                break;
            }
            case SUMMARY_URL: {
                this.setText(Messages.CopyTaskDetailsAction_Summary_and_Url_Menu_Label);
            }
        }
    }

    public void run() {
        ClipboardCopier.getDefault().copy(this.getStructuredSelection(), new ClipboardCopier.TextProvider(){

            public String getTextForElement(Object element) {
                return CopyTaskDetailsAction.getTextForTask(element, CopyTaskDetailsAction.this.getMode());
            }
        });
    }

    public static String getTextForTask(Object object) {
        return CopyTaskDetailsAction.getTextForTask(object, Mode.SUMMARY_URL);
    }

    public static String getTextForTask(Object object, Mode mode) {
        StringBuffer sb = new StringBuffer();
        switch (mode) {
            case KEY: {
                ITask task;
                if (!(object instanceof ITask) || (task = (ITask)object).getTaskKey() == null) break;
                sb.append(task.getTaskKey());
                break;
            }
            case URL: {
                IRepositoryElement element;
                if (!(object instanceof IRepositoryElement) || (element = (IRepositoryElement)object).getUrl() == null) break;
                sb.append(element.getUrl());
                break;
            }
            case SUMMARY: {
                if (object instanceof ITask) {
                    ITask task = (ITask)object;
                    if (task.getTaskKey() != null) {
                        sb.append(TasksUiInternal.getTaskPrefix(task.getConnectorKind()));
                        sb.append(task.getTaskKey());
                        sb.append(": ");
                    }
                    sb.append(task.getSummary());
                    break;
                }
                if (!(object instanceof IRepositoryElement)) break;
                IRepositoryElement element = (IRepositoryElement)object;
                sb.append(element.getSummary());
                break;
            }
            case SUMMARY_URL: {
                if (object instanceof ITask) {
                    ITask task = (ITask)object;
                    if (task.getTaskKey() != null) {
                        sb.append(task.getTaskKey());
                        sb.append(": ");
                    }
                    sb.append(task.getSummary());
                    if (!TasksUiInternal.isValidUrl(task.getUrl())) break;
                    sb.append(ClipboardCopier.LINE_SEPARATOR);
                    sb.append(task.getUrl());
                    break;
                }
                if (object instanceof IRepositoryQuery) {
                    RepositoryQuery query = (RepositoryQuery)object;
                    sb.append(query.getSummary());
                    if (!TasksUiInternal.isValidUrl(query.getUrl())) break;
                    sb.append(ClipboardCopier.LINE_SEPARATOR);
                    sb.append(query.getUrl());
                    break;
                }
                if (!(object instanceof IRepositoryElement)) break;
                IRepositoryElement element = (IRepositoryElement)object;
                sb.append(element.getSummary());
            }
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        KEY,
        URL,
        SUMMARY,
        SUMMARY_URL;

    }
}

