/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.preferences;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.monitor.ui.MonitorUiPlugin;
import org.eclipse.mylyn.internal.provisional.commons.core.CommonMessages;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonColors;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.RestoreTaskListAction;
import org.eclipse.mylyn.internal.tasks.ui.preferences.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class TasksUiPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.mylyn.tasks.ui.preferences";
    private static final String FORWARDSLASH = "/";
    private static final String BACKSLASH_MULTI = "\\\\";
    private static final int MS_MINUTES = 60000;
    private Button useRichEditor;
    private Button editorHighlightsCurrentLine;
    private Button useWebBrowser;
    private Text synchScheduleTime = null;
    private Button enableBackgroundSynch;
    private Text taskDirectoryText = null;
    private Button browse = null;
    private Button notificationEnabledButton = null;
    private final FormToolkit toolkit;
    private Spinner timeoutMinutes;
    private Button timeoutEnabledButton;
    private ExpandableComposite advancedComposite;
    private Combo weekStartCombo;
    private Button activityTrackingEnabledButton;
    private Label timeoutLabel1;
    private Label timeoutLabel2;
    private Button taskListTooltipEnabledButton;

    public TasksUiPreferencePage() {
        this.setPreferenceStore(TasksUiPlugin.getDefault().getPreferenceStore());
        this.toolkit = new FormToolkit(Display.getCurrent());
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        this.createTaskRefreshScheduleGroup(container);
        this.createSchedulingGroup(container);
        this.createTaskListGroup(container);
        this.createTaskEditorGroup(container);
        this.createTaskActivityGroup(container);
        Composite advanced = this.createAdvancedSection(container);
        this.createTaskDataControl(advanced);
        if (this.getContainer() instanceof IWorkbenchPreferenceContainer) {
            String message = Messages.TasksUiPreferencePage_See_X_for_configuring_Task_List_colors;
            new PreferenceLinkArea(advanced, 0, "org.eclipse.ui.preferencePages.ColorsAndFonts", message, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        }
        this.createLinks(advanced);
        this.updateRefreshGroupEnablements();
        this.applyDialogFont(container);
        return container;
    }

    private void createLinks(Composite container) {
        Hyperlink link = new Hyperlink(container, 0);
        link.setForeground(CommonColors.HYPERLINK_WIDGET);
        link.setUnderlined(true);
        link.setText(Messages.TasksUiPreferencePage_Use_the_Restore_dialog_to_recover_missing_tasks);
        link.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                TasksUiPreferencePage.this.getShell().close();
                new RestoreTaskListAction().run();
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
    }

    private Composite createAdvancedSection(Composite container) {
        this.advancedComposite = this.toolkit.createExpandableComposite(container, 290);
        this.advancedComposite.setFont(container.getFont());
        this.advancedComposite.setBackground(container.getBackground());
        this.advancedComposite.setText(Messages.TasksUiPreferencePage_Advanced);
        this.advancedComposite.setLayout((Layout)new GridLayout(1, false));
        this.advancedComposite.setLayoutData((Object)new GridData(768));
        this.advancedComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                TasksUiPreferencePage.this.getControl().getShell().pack();
            }
        });
        Composite advanced = new Composite((Composite)this.advancedComposite, 0);
        advanced.setLayout((Layout)new GridLayout(1, false));
        this.advancedComposite.setClient((Control)advanced);
        return advanced;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.notifications.enabled", this.notificationEnabledButton.getSelection());
        this.getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.reporting.open.editor", this.useRichEditor.getSelection());
        this.getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.editor.currentLineHighlight", this.editorHighlightsCurrentLine.getSelection());
        this.getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule", this.enableBackgroundSynch.getSelection());
        long miliseconds = 60000L * Long.parseLong(this.synchScheduleTime.getText());
        this.getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule.miliseconds", "" + miliseconds);
        this.getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.task.list.tool.tip", this.taskListTooltipEnabledButton.getSelection());
        this.getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.planning.week.start.day", this.getWeekStartValue());
        MonitorUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.monitor.ui.activity.timeout.enabled", this.timeoutEnabledButton.getSelection());
        MonitorUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.monitor.ui.activity.timeout", this.timeoutMinutes.getSelection() * 60000);
        MonitorUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.monitor.activity.tracking.enabled", this.activityTrackingEnabledButton.getSelection());
        String taskDirectory = this.taskDirectoryText.getText();
        taskDirectory = taskDirectory.replaceAll(BACKSLASH_MULTI, FORWARDSLASH);
        if (!taskDirectory.equals(TasksUiPlugin.getDefault().getDataDirectory())) {
            if (this.checkForExistingTasklist(taskDirectory)) {
                String originalDirectory;
                Throwable exception = null;
                try {
                    TasksUiPlugin.getDefault().setDataDirectory(taskDirectory);
                }
                catch (CoreException e) {
                    exception = e;
                    StatusHandler.log((IStatus)e.getStatus());
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.TasksUiPreferencePage_Task_Data_Directory_Error, (String)Messages.TasksUiPreferencePage_Error_applying_Task_List_data_directory_changes);
                }
                catch (OperationCanceledException ce) {
                    exception = ce;
                }
                if (exception != null && !this.taskDirectoryText.isDisposed() && !taskDirectory.equals(originalDirectory = TasksUiPlugin.getDefault().getDefaultDataDirectory())) {
                    this.taskDirectoryText.setText(originalDirectory);
                }
            } else {
                this.taskDirectoryText.setFocus();
                return false;
            }
        }
        return true;
    }

    private int getWeekStartValue() {
        return this.weekStartCombo.getSelectionIndex() + 1;
    }

    public boolean performCancel() {
        this.taskDirectoryText.setText(TasksUiPlugin.getDefault().getDefaultDataDirectory());
        this.notificationEnabledButton.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.notifications.enabled"));
        this.useRichEditor.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.reporting.open.editor"));
        this.editorHighlightsCurrentLine.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.editor.currentLineHighlight"));
        this.enableBackgroundSynch.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule"));
        this.synchScheduleTime.setText(this.getMinutesString());
        this.taskListTooltipEnabledButton.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.task.list.tool.tip"));
        this.weekStartCombo.select(this.getPreferenceStore().getInt("org.eclipse.mylyn.tasks.ui.planning.week.start.day") - 1);
        int minutes = MonitorUiPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.mylyn.monitor.ui.activity.timeout") / 60000;
        this.timeoutMinutes.setSelection(minutes);
        this.timeoutEnabledButton.setSelection(MonitorUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.monitor.ui.activity.timeout.enabled"));
        this.activityTrackingEnabledButton.setSelection(MonitorUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.monitor.activity.tracking.enabled"));
        return true;
    }

    public void performDefaults() {
        super.performDefaults();
        this.taskDirectoryText.setText(TasksUiPlugin.getDefault().getDefaultDataDirectory());
        this.notificationEnabledButton.setSelection(this.getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn.tasks.ui.notifications.enabled"));
        this.useRichEditor.setSelection(this.getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn.tasks.ui.reporting.open.editor"));
        this.editorHighlightsCurrentLine.setSelection(this.getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn.tasks.ui.editor.currentLineHighlight"));
        this.taskListTooltipEnabledButton.setSelection(this.getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn.tasks.ui.task.list.tool.tip"));
        this.enableBackgroundSynch.setSelection(this.getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule"));
        long miliseconds = this.getPreferenceStore().getDefaultLong("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule.miliseconds");
        long minutes = miliseconds / 60000L;
        this.synchScheduleTime.setText("" + minutes);
        this.weekStartCombo.select(this.getPreferenceStore().getDefaultInt("org.eclipse.mylyn.tasks.ui.planning.week.start.day") - 1);
        int activityTimeoutMinutes = MonitorUiPlugin.getDefault().getPreferenceStore().getDefaultInt("org.eclipse.mylyn.monitor.ui.activity.timeout") / 60000;
        this.timeoutMinutes.setSelection(activityTimeoutMinutes);
        this.timeoutEnabledButton.setSelection(MonitorUiPlugin.getDefault().getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn.monitor.ui.activity.timeout.enabled"));
        this.activityTrackingEnabledButton.setSelection(MonitorUiPlugin.getDefault().getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn.monitor.activity.tracking.enabled"));
        this.updateRefreshGroupEnablements();
    }

    private void createTaskRefreshScheduleGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText(Messages.TasksUiPreferencePage_Synchronization);
        GridLayout gridLayout = new GridLayout(1, false);
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        Composite enableSynch = new Composite((Composite)group, 0);
        gridLayout = new GridLayout(4, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        enableSynch.setLayout((Layout)gridLayout);
        this.enableBackgroundSynch = new Button(enableSynch, 32);
        this.enableBackgroundSynch.setText(Messages.TasksUiPreferencePage_Synchronize_with_repositories_every);
        this.enableBackgroundSynch.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule"));
        this.enableBackgroundSynch.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TasksUiPreferencePage.this.updateRefreshGroupEnablements();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.synchScheduleTime = new Text(enableSynch, 133120);
        GridData gridData = new GridData();
        gridData.widthHint = 25;
        this.synchScheduleTime.setLayoutData((Object)gridData);
        this.synchScheduleTime.setText(this.getMinutesString());
        this.synchScheduleTime.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TasksUiPreferencePage.this.updateRefreshGroupEnablements();
            }
        });
        Label label = new Label(enableSynch, 0);
        label.setText(Messages.TasksUiPreferencePage_minutes);
        this.notificationEnabledButton = new Button((Composite)group, 32);
        this.notificationEnabledButton.setText(Messages.TasksUiPreferencePage_Display_notifications_for_overdue_tasks_and_incoming_changes);
        this.notificationEnabledButton.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.notifications.enabled"));
    }

    private void createTaskEditorGroup(Composite parent) {
        Group container = new Group(parent, 16);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(768));
        container.setText(Messages.TasksUiPreferencePage_Task_Editing);
        this.useRichEditor = new Button((Composite)container, 16);
        this.useRichEditor.setText(Messages.TasksUiPreferencePage_Rich_Editor__Recommended_);
        this.useRichEditor.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.reporting.open.editor"));
        this.useWebBrowser = new Button((Composite)container, 16);
        this.useWebBrowser.setText(Messages.TasksUiPreferencePage_Web_Browser);
        this.useWebBrowser.setSelection(!this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.reporting.open.editor"));
        this.editorHighlightsCurrentLine = new Button((Composite)container, 32);
        this.editorHighlightsCurrentLine.setText(Messages.TasksUiPreferencePage_highlight_current_line);
        this.editorHighlightsCurrentLine.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.editor.currentLineHighlight"));
    }

    private void createTaskDataControl(Composite parent) {
        Group taskDataGroup = new Group(parent, 16);
        taskDataGroup.setText(Messages.TasksUiPreferencePage_Task_Data);
        taskDataGroup.setLayout((Layout)new GridLayout(1, false));
        taskDataGroup.setLayoutData((Object)new GridData(768));
        Composite dataDirComposite = new Composite((Composite)taskDataGroup, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        dataDirComposite.setLayout((Layout)gridLayout);
        dataDirComposite.setLayoutData((Object)new GridData(768));
        Label label = new Label(dataDirComposite, 0);
        label.setText(Messages.TasksUiPreferencePage_Data_directory_);
        String taskDirectory = TasksUiPlugin.getDefault().getDataDirectory();
        taskDirectory = taskDirectory.replaceAll(BACKSLASH_MULTI, FORWARDSLASH);
        this.taskDirectoryText = new Text(dataDirComposite, 2048);
        this.taskDirectoryText.setText(taskDirectory);
        this.taskDirectoryText.setLayoutData((Object)new GridData(768));
        this.browse = new Button(dataDirComposite, 131072);
        this.browse.setText(Messages.TasksUiPreferencePage_Browse_);
        this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(TasksUiPreferencePage.this.getShell());
                dialog.setText(Messages.TasksUiPreferencePage_Folder_Selection);
                dialog.setMessage(Messages.TasksUiPreferencePage_Specify_the_folder_for_tasks);
                String dir = TasksUiPreferencePage.this.taskDirectoryText.getText();
                dir = dir.replaceAll(TasksUiPreferencePage.BACKSLASH_MULTI, TasksUiPreferencePage.FORWARDSLASH);
                dialog.setFilterPath(dir);
                dir = dialog.open();
                if (dir == null || dir.equals("")) {
                    return;
                }
                dir = dir.replaceAll(TasksUiPreferencePage.BACKSLASH_MULTI, TasksUiPreferencePage.FORWARDSLASH);
                TasksUiPreferencePage.this.taskDirectoryText.setText(dir);
            }
        });
    }

    private void createSchedulingGroup(Composite container) {
        Group group = new Group(container, 16);
        group.setText(Messages.TasksUiPreferencePage_Scheduling);
        group.setLayout((Layout)new GridLayout(5, false));
        group.setLayoutData((Object)new GridData(768));
        Label weekStartLabel = new Label((Composite)group, 0);
        weekStartLabel.setText(Messages.TasksUiPreferencePage_Week_Start);
        this.weekStartCombo = new Combo((Composite)group, 8);
        this.weekStartCombo.add(CommonMessages.Sunday);
        this.weekStartCombo.add(CommonMessages.Monday);
        this.weekStartCombo.add(CommonMessages.Tuesday);
        this.weekStartCombo.add(CommonMessages.Wednesday);
        this.weekStartCombo.add(CommonMessages.Thursday);
        this.weekStartCombo.add(CommonMessages.Friday);
        this.weekStartCombo.add(CommonMessages.Saturday);
        this.weekStartCombo.select(this.getPreferenceStore().getInt("org.eclipse.mylyn.tasks.ui.planning.week.start.day") - 1);
    }

    private void createTaskListGroup(Composite container) {
        Group group = new Group(container, 16);
        group.setText(Messages.TasksUiPreferencePage_Task_List_Group);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(768));
        this.taskListTooltipEnabledButton = new Button((Composite)group, 32);
        this.taskListTooltipEnabledButton.setText(Messages.TasksUiPreferencePage_Show_tooltip_on_hover_Label);
        this.taskListTooltipEnabledButton.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.task.list.tool.tip"));
    }

    private void createTaskActivityGroup(Composite container) {
        Group group = new Group(container, 16);
        group.setText(Messages.TasksUiPreferencePage_Task_Timing);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(768));
        boolean activityTrackingEnabled = MonitorUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.monitor.activity.tracking.enabled");
        boolean timeoutEnabled = MonitorUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.monitor.ui.activity.timeout.enabled");
        this.activityTrackingEnabledButton = new Button((Composite)group, 32);
        this.activityTrackingEnabledButton.setText(Messages.TasksUiPreferencePage_Enable_Time_Tracking);
        this.activityTrackingEnabledButton.setSelection(activityTrackingEnabled);
        this.activityTrackingEnabledButton.setToolTipText(Messages.TasksUiPreferencePage_Track_Time_Spent);
        this.activityTrackingEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TasksUiPreferencePage.this.updateRefreshGroupEnablements();
            }
        });
        GridDataFactory.swtDefaults().span(3, 1).applyTo((Control)this.activityTrackingEnabledButton);
        this.timeoutEnabledButton = new Button((Composite)group, 32);
        this.timeoutEnabledButton.setText(Messages.TasksUiPreferencePage_Enable_inactivity_timeouts);
        this.timeoutEnabledButton.setSelection(timeoutEnabled);
        this.timeoutEnabledButton.setToolTipText(Messages.TasksUiPreferencePage_If_disabled);
        this.timeoutEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TasksUiPreferencePage.this.updateRefreshGroupEnablements();
            }
        });
        GridDataFactory.swtDefaults().span(3, 1).applyTo((Control)this.timeoutEnabledButton);
        this.timeoutLabel1 = new Label((Composite)group, 0);
        this.timeoutLabel1.setText(Messages.TasksUiPreferencePage_Stop_time_accumulation_after);
        this.timeoutMinutes = new Spinner((Composite)group, 2048);
        this.timeoutMinutes.setDigits(0);
        this.timeoutMinutes.setIncrement(5);
        this.timeoutMinutes.setMaximum(60);
        this.timeoutMinutes.setMinimum(1);
        long minutes = MonitorUiPlugin.getDefault().getPreferenceStore().getLong("org.eclipse.mylyn.monitor.ui.activity.timeout") / 60000L;
        this.timeoutMinutes.setSelection((int)minutes);
        this.timeoutMinutes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TasksUiPreferencePage.this.updateRefreshGroupEnablements();
            }
        });
        this.timeoutLabel2 = new Label((Composite)group, 0);
        this.timeoutLabel2.setText(Messages.TasksUiPreferencePage_minutes_of_inactivity);
    }

    public void updateRefreshGroupEnablements() {
        String errorMessage = null;
        if (this.enableBackgroundSynch.getSelection()) {
            try {
                long number = Long.parseLong(this.synchScheduleTime.getText());
                if (number <= 0L) {
                    errorMessage = Messages.TasksUiPreferencePage_Synchronize_schedule_time_must_be_GT_0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                errorMessage = Messages.TasksUiPreferencePage_Synchronize_schedule_time_must_be_valid_integer;
            }
        }
        this.setErrorMessage(errorMessage);
        this.setValid(errorMessage == null);
        if (this.activityTrackingEnabledButton.getSelection()) {
            this.timeoutEnabledButton.setEnabled(true);
            this.timeoutMinutes.setEnabled(this.timeoutEnabledButton.getSelection());
            this.timeoutLabel1.setEnabled(this.timeoutEnabledButton.getSelection());
            this.timeoutLabel2.setEnabled(this.timeoutEnabledButton.getSelection());
        } else {
            this.timeoutEnabledButton.setEnabled(false);
            this.timeoutMinutes.setEnabled(false);
            this.timeoutLabel1.setEnabled(false);
            this.timeoutLabel2.setEnabled(false);
        }
        this.synchScheduleTime.setEnabled(this.enableBackgroundSynch.getSelection());
    }

    private String getMinutesString() {
        long miliseconds = this.getPreferenceStore().getLong("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule.miliseconds");
        long minutes = miliseconds / 60000L;
        return "" + minutes;
    }

    private boolean checkForExistingTasklist(String dir) {
        File newDataFolder = new File(dir);
        if (!newDataFolder.exists() && !newDataFolder.mkdirs()) {
            MessageDialog.openWarning((Shell)this.getControl().getShell(), (String)Messages.TasksUiPreferencePage_Change_data_directory, (String)Messages.TasksUiPreferencePage_Destination_folder_cannot_be_created);
            return false;
        }
        MessageDialog dialogConfirm = new MessageDialog(null, Messages.TasksUiPreferencePage_Confirm_Task_List_data_directory_change, null, Messages.TasksUiPreferencePage_A_new_empty_Task_List_will_be_created_in_the_chosen_directory_if_one_does_not_already_exists, 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
        int taskDataDirectoryAction = dialogConfirm.open();
        if (taskDataDirectoryAction != 0) {
            return false;
        }
        for (TaskEditor taskEditor : TasksUiInternal.getActiveRepositoryTaskEditors()) {
            TasksUiInternal.closeTaskEditorInAllPages(taskEditor.getTaskEditorInput().getTask(), true);
        }
        return true;
    }

    public void dispose() {
        if (this.toolkit != null && this.toolkit.getColors() != null) {
            this.toolkit.dispose();
        }
        super.dispose();
    }
}

