/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui;

import java.util.Iterator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.MultipleHyperlinkPresenter;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TaskHyperlink;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.RGB;

public final class TaskHyperlinkPresenter
extends MultipleHyperlinkPresenter {
    private IRegion activeRegion;
    private ITask currentTask;
    private TaskHyperlink currentTaskHyperlink;
    private ITextViewer textViewer;

    public TaskHyperlinkPresenter(IPreferenceStore store) {
        super(store);
    }

    public TaskHyperlinkPresenter(RGB color) {
        super(color);
    }

    public void install(ITextViewer textViewer) {
        this.textViewer = textViewer;
        super.install(textViewer);
    }

    public void uninstall() {
        this.hideHyperlinks();
        this.textViewer = null;
        super.uninstall();
    }

    public void applyTextPresentation(TextPresentation textPresentation) {
        super.applyTextPresentation(textPresentation);
        if (this.activeRegion != null && this.currentTask != null && this.currentTask.isCompleted()) {
            Iterator styleRangeIterator = textPresentation.getAllStyleRangeIterator();
            while (styleRangeIterator.hasNext()) {
                StyleRange styleRange = (StyleRange)styleRangeIterator.next();
                if (this.activeRegion.getOffset() != styleRange.start || this.activeRegion.getLength() != styleRange.length) continue;
                styleRange.strikeout = true;
                break;
            }
        }
    }

    public void showHyperlinks(IHyperlink[] hyperlinks) {
        if (hyperlinks.length > 1) {
            super.showHyperlinks(hyperlinks);
        } else {
            this.activeRegion = null;
            if (hyperlinks.length > 0 && hyperlinks[0] instanceof TaskHyperlink) {
                String repositoryUrl;
                TaskHyperlink hyperlink = (TaskHyperlink)hyperlinks[0];
                TaskList taskList = TasksUiPlugin.getTaskList();
                ITask task = taskList.getTask(repositoryUrl = hyperlink.getRepository().getRepositoryUrl(), hyperlink.getTaskId());
                if (task == null) {
                    task = taskList.getTaskByKey(repositoryUrl, hyperlink.getTaskId());
                }
                if (!hyperlinks[0].equals(this.currentTaskHyperlink)) {
                    this.currentTaskHyperlink = (TaskHyperlink)hyperlinks[0];
                    this.currentTask = task;
                    this.activeRegion = hyperlink.getHyperlinkRegion();
                    if (this.textViewer != null && this.textViewer.getTextWidget() != null && !this.textViewer.getTextWidget().isDisposed()) {
                        if (task == null) {
                            String taskLabel = TasksUiInternal.getTaskPrefix(hyperlink.getRepository().getConnectorKind());
                            taskLabel = String.valueOf(taskLabel) + this.currentTaskHyperlink.getTaskId();
                            this.textViewer.getTextWidget().setToolTipText(NLS.bind((String)Messages.TaskHyperlinkPresenter_Not_In_Task_List, (Object)taskLabel));
                        } else if (task.getTaskKey() == null) {
                            this.textViewer.getTextWidget().setToolTipText(task.getSummary());
                        } else {
                            this.textViewer.getTextWidget().setToolTipText(String.valueOf(task.getTaskKey()) + ": " + task.getSummary());
                        }
                    }
                }
            }
            super.showHyperlinks(hyperlinks);
        }
    }

    public void hideHyperlinks() {
        if (this.currentTaskHyperlink != null) {
            if (this.textViewer != null && this.textViewer.getTextWidget() != null && !this.textViewer.getTextWidget().isDisposed()) {
                this.textViewer.getTextWidget().setToolTipText(null);
            }
            this.currentTaskHyperlink = null;
            this.currentTask = null;
        }
        super.hideHyperlinks();
    }
}

