/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.sdk.job;

import com.liferay.ide.eclipse.sdk.SDK;
import com.liferay.ide.eclipse.sdk.SDKManager;
import com.liferay.ide.eclipse.sdk.util.SDKUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.osgi.service.prefs.Preferences;

public abstract class SDKJob
extends Job {
    public static final String PREF_NODE_LIFERAY_PLUGIN_PROJECT = "liferay-plugin-project";
    protected IProject project;

    public SDKJob(String name) {
        super(name);
    }

    protected IProject getProject() {
        return this.project;
    }

    protected SDK getSDK() {
        if (this.project == null) {
            return null;
        }
        SDK retval = null;
        try {
            IFacetedProject fProject = ProjectFacetsManager.create((IProject)this.project);
            for (IProjectFacetVersion fv : fProject.getProjectFacets()) {
                Preferences preferences = fProject.getPreferences(fv.getProjectFacet());
                if (!preferences.nodeExists(PREF_NODE_LIFERAY_PLUGIN_PROJECT)) continue;
                String name = preferences.node(PREF_NODE_LIFERAY_PLUGIN_PROJECT).get("sdk-name", "");
                SDK sdk = SDKManager.getInstance().getSDK(name);
                if (sdk == null) {
                    IPath sdkLocation = this.project.getRawLocation().removeLastSegments(2);
                    sdk = SDKManager.getInstance().getSDK(sdkLocation);
                    if (sdk == null) {
                        sdk = SDKUtil.createSDKFromLocation(sdkLocation);
                        SDKManager.getInstance().addSDK(sdk);
                    } else {
                        retval = sdk;
                    }
                    preferences.node(PREF_NODE_LIFERAY_PLUGIN_PROJECT).put("sdk-name", sdk.getName());
                    preferences.flush();
                    continue;
                }
                retval = sdk;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retval;
    }

    protected IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    protected void setProject(IProject project) {
        this.project = project;
    }
}

