/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.sdk.pref;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.sdk.ISDKConstants;
import com.liferay.ide.eclipse.sdk.SDK;
import com.liferay.ide.eclipse.sdk.SDKPlugin;
import com.liferay.ide.eclipse.sdk.util.SDKUtil;
import com.liferay.ide.eclipse.ui.util.SWTUtil;
import java.io.File;
import java.net.URL;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public class AddSDKDialog
extends TitleAreaDialog
implements ModifyListener {
    protected SDK[] existingSDKs;
    protected String lastLocation;
    protected String lastName;
    protected Text location;
    protected Text name;
    protected SDK sdkToEdit;
    protected Combo serverTargetCombo;

    public AddSDKDialog(Shell parent, SDK[] existingSDKs) {
        super(parent);
        this.configure(existingSDKs);
    }

    public AddSDKDialog(Shell shell, SDK[] existingSDKs, SDK sdk) {
        super(shell);
        this.sdkToEdit = sdk;
        this.configure(existingSDKs);
    }

    public String getLocation() {
        return this.lastLocation;
    }

    public String getName() {
        return this.lastName;
    }

    public void modifyText(ModifyEvent e) {
        IStatus status = this.validate();
        if (!status.isOK()) {
            switch (status.getSeverity()) {
                case 2: {
                    this.setMessage(status.getMessage(), 2);
                    break;
                }
                case 4: {
                    this.setMessage(status.getMessage(), 3);
                    this.getButton(0).setEnabled(false);
                }
            }
        } else {
            this.getButton(0).setEnabled(true);
            this.setMessage(this.getDefaultMessage(), 0);
        }
    }

    protected void configure(SDK[] existingSdks) {
        this.existingSDKs = existingSdks;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitleImage(ImageDescriptor.createFromURL((URL)SDKPlugin.getDefault().getBundle().getEntry("/icons/wizban/sdk_wiz.png")).createImage());
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(String.valueOf(this.sdkToEdit == null ? "New" : "Edit") + " Liferay Plugin SDK");
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(String.valueOf(this.sdkToEdit == null ? "Add" : "Edit") + " Liferay Plugin SDK");
        this.setMessage(this.getDefaultMessage());
        Composite container = SWTUtil.createTopComposite((Composite)parent, (int)3);
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        SWTUtil.createLabel((Composite)container, (String)"Location", (int)1);
        this.location = SWTUtil.createSingleText((Composite)container, (int)1);
        Button browse = SWTUtil.createButton((Composite)container, (String)"Browse");
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddSDKDialog.this.doBrowse();
            }
        });
        if (this.sdkToEdit == null) {
            this.location.addModifyListener((ModifyListener)this);
        } else {
            this.location.setText(this.sdkToEdit.getLocation().toOSString());
            this.location.setEnabled(false);
            browse.setEnabled(false);
        }
        SWTUtil.createLabel((Composite)container, (String)"Name", (int)1);
        this.name = SWTUtil.createSingleText((Composite)container, (int)1);
        if (this.sdkToEdit != null) {
            this.name.setText(this.sdkToEdit.getName());
        }
        this.name.addModifyListener((ModifyListener)this);
        SWTUtil.createLabel((Composite)container, (String)"", (int)1);
        if (this.sdkToEdit != null) {
            this.validate();
        }
        return container;
    }

    protected void doBrowse() {
        String dir;
        DirectoryDialog dd = new DirectoryDialog(this.getShell(), 4096);
        dd.setText("Select Liferay Plugin SDK folder");
        if (CoreUtil.isNullOrEmpty((String)this.location.getText())) {
            dd.setFilterPath(this.location.getText());
        }
        if (!CoreUtil.isNullOrEmpty((String)(dir = dd.open()))) {
            Path path;
            this.location.setText(dir);
            if (SDKUtil.isValidSDKLocation(dir) && CoreUtil.isNullOrEmpty((String)this.name.getText()) && (path = new Path(dir)).isValidPath(dir)) {
                this.name.setText(path.lastSegment());
            }
        }
    }

    protected String getDefaultMessage() {
        return "Configure a Liferay Plugin SDK location.";
    }

    protected void updateRuntimeItems() {
        HashSet<String> validRuntimes = new HashSet<String>();
        IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
        int n = iRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime runtime = iRuntimeArray[n2];
            if (runtime.getRuntimeType().getId().startsWith("com.liferay.ide.eclipse.server")) {
                validRuntimes.add(runtime.getName());
            }
            ++n2;
        }
        String[] runtimes = validRuntimes.toArray(new String[0]);
        this.serverTargetCombo.setItems(runtimes);
        if (this.serverTargetCombo.getSelectionIndex() < 0 && runtimes.length > 0) {
            this.serverTargetCombo.select(0);
        }
    }

    protected IStatus validate() {
        this.lastName = this.name.getText();
        if (CoreUtil.isNullOrEmpty((String)this.lastName)) {
            return CoreUtil.createErrorStatus((String)"Name must have a value.");
        }
        if (this.existingSDKs != null) {
            SDK[] sDKArray = this.existingSDKs;
            int n = this.existingSDKs.length;
            int n2 = 0;
            while (n2 < n) {
                SDK sdk = sDKArray[n2];
                if (this.lastName.equals(sdk.getName())) {
                    return CoreUtil.createErrorStatus((String)"Name already exists.");
                }
                ++n2;
            }
        }
        this.lastLocation = this.location.getText();
        if (CoreUtil.isNullOrEmpty((String)this.lastLocation)) {
            return CoreUtil.createErrorStatus((String)"Location must have a value.");
        }
        if (!new File(this.lastLocation).exists()) {
            return CoreUtil.createErrorStatus((String)"Location must exist.");
        }
        if (!SDKUtil.isValidSDKLocation(this.lastLocation)) {
            return CoreUtil.createErrorStatus((String)"Location must be a valid Liferay Plugin SDK.");
        }
        if (!SDKUtil.isSDKSupported(this.lastLocation)) {
            return CoreUtil.createErrorStatus((String)("SDK version must be greater or equal to " + ISDKConstants.LEAST_SUPPORTED_SDK_VERSION));
        }
        return Status.OK_STATUS;
    }
}

