/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.sdk.pref;

import com.liferay.ide.eclipse.sdk.SDK;
import com.liferay.ide.eclipse.sdk.SDKManager;
import com.liferay.ide.eclipse.sdk.SDKPlugin;
import com.liferay.ide.eclipse.sdk.pref.AddSDKDialog;
import com.liferay.ide.eclipse.sdk.util.SDKUtil;
import com.liferay.ide.eclipse.ui.util.SWTUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class InstalledSDKsCompostite
extends Composite {
    protected Button fAddButton;
    protected Button fEditButton;
    protected ISelection fPrevSelection;
    protected Button fRemoveButton;
    protected PreferencePage page;
    protected List<SDK> sdkList = new ArrayList<SDK>();
    protected Table table;
    protected CheckboxTableViewer tableViewer;

    public InstalledSDKsCompostite(Composite parent, int style) {
        super(parent, style);
        GridLayout gl = new GridLayout(2, false);
        this.setLayout((Layout)gl);
        this.createControl(this);
    }

    public SDK getCheckedSDK() {
        Object[] checkedElements = this.tableViewer.getCheckedElements();
        if (checkedElements != null && checkedElements.length == 1 && checkedElements[0] instanceof SDK) {
            return (SDK)checkedElements[0];
        }
        return null;
    }

    public SDK[] getSDKs() {
        return this.sdkList.toArray(new SDK[this.sdkList.size()]);
    }

    public ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    public void setPreferencePage(PreferencePage prefPage) {
        this.page = prefPage;
    }

    protected void addSDK() {
        AddSDKDialog dialog = new AddSDKDialog(this.getShell(), this.sdkList.toArray(new SDK[0]));
        int retval = dialog.open();
        if (retval == 0) {
            String name = dialog.getName();
            SDK newSDK = SDKUtil.createSDKFromLocation((IPath)new Path(dialog.getLocation()));
            newSDK.setName(name);
            this.sdkList.add(newSDK);
            this.tableViewer.refresh();
            this.ensureDefaultSDK();
            this.tableViewer.refresh();
        }
    }

    protected void createControl(Composite parent) {
        SWTUtil.createLabel((Composite)parent, (String)"Installed Liferay Plugin SDKs:", (int)2);
        this.table = new Table(parent, 67618);
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        gd.widthHint = 350;
        this.table.setLayoutData((Object)gd);
        this.table.setFont(parent.getFont());
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn column = new TableColumn(this.table, 0);
        column.setText("Name");
        int defaultwidth = gd.widthHint / 3 + 1;
        column.setWidth(defaultwidth);
        column = new TableColumn(this.table, 0);
        column.setText("Version");
        column.setWidth(defaultwidth - 60);
        column = new TableColumn(this.table, 0);
        column.setText("Location");
        column.setWidth(defaultwidth + 90);
        this.tableViewer = new CheckboxTableViewer(this.table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new SDKLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new SDKContentProvider());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                InstalledSDKsCompostite.this.enableButtons();
            }
        });
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    InstalledSDKsCompostite.this.setCheckedSDK((SDK)event.getElement());
                } else {
                    InstalledSDKsCompostite.this.setCheckedSDK(null);
                }
            }
        });
        Composite buttons = SWTUtil.createComposite((Composite)parent, (int)1, (int)1, (int)2, (int)0, (int)0);
        this.fAddButton = SWTUtil.createPushButton((Composite)buttons, (String)"Add...", null);
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledSDKsCompostite.this.addSDK();
            }
        });
        this.fEditButton = SWTUtil.createPushButton((Composite)buttons, (String)"Edit...", null);
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledSDKsCompostite.this.editSDK(InstalledSDKsCompostite.this.getFirstSelectedSDK());
            }
        });
        this.fRemoveButton = SWTUtil.createPushButton((Composite)buttons, (String)"Remove", null);
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledSDKsCompostite.this.removeSelectedSDKs();
            }
        });
        this.setSDKs(SDKManager.getInstance().getSDKs());
        this.enableButtons();
        this.fAddButton.setEnabled(true);
    }

    protected void editSDK(SDK sdk) {
        AddSDKDialog dialog = new AddSDKDialog(this.getShell(), this.sdkList.toArray(new SDK[0]), sdk);
        int retval = dialog.open();
        if (retval == 0) {
            String newName = dialog.getName();
            String newLocation = dialog.getLocation();
            sdk.setName(newName);
            sdk.setLocation((IPath)new Path(newLocation));
            this.tableViewer.refresh();
            this.ensureDefaultSDK();
            this.tableViewer.refresh();
        }
    }

    protected void enableButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        int selectionCount = selection.size();
        if (selectionCount > 0 && selectionCount <= this.tableViewer.getTable().getItemCount()) {
            for (SDK install : selection) {
                if (!this.isContributed(install)) continue;
                this.fEditButton.setEnabled(false);
                this.fRemoveButton.setEnabled(false);
                return;
            }
            this.fEditButton.setEnabled(true);
            this.fRemoveButton.setEnabled(true);
        } else {
            this.fEditButton.setEnabled(false);
            this.fRemoveButton.setEnabled(false);
        }
    }

    protected void ensureDefaultSDK() {
        if (this.sdkList.size() == 1) {
            this.setCheckedSDK(this.sdkList.get(0));
        }
    }

    protected void fireSelectionChanged() {
    }

    protected SDK getFirstSelectedSDK() {
        Object next;
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        Iterator iterator = selection.iterator();
        if (iterator.hasNext() && (next = iterator.next()) instanceof SDK) {
            return (SDK)next;
        }
        return null;
    }

    protected boolean isContributed(SDK install) {
        return install.isContributed();
    }

    protected void removeSDKs(SDK[] sdks) {
        IStructuredSelection prev = (IStructuredSelection)this.getSelection();
        int i = 0;
        while (i < sdks.length) {
            this.sdkList.remove(sdks[i]);
            ++i;
        }
        this.ensureDefaultSDK();
        this.tableViewer.refresh();
        IStructuredSelection curr = (IStructuredSelection)this.getSelection();
        if (!curr.equals(prev)) {
            SDK[] curSdks = this.getSDKs();
            if (curr.size() == 0 && curSdks.length == 1) {
                this.setSelection((ISelection)new StructuredSelection((Object)curSdks[0]));
            } else {
                this.fireSelectionChanged();
            }
        }
    }

    protected void removeSelectedSDKs() {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        SDK[] sdks = new SDK[selection.size()];
        Iterator iterator = selection.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            SDK sdk = null;
            Object next = iterator.next();
            if (next instanceof SDK) {
                sdk = (SDK)next;
            } else if (next instanceof IStructuredSelection) {
                sdk = (SDK)((IStructuredSelection)next).getFirstElement();
            }
            sdks[i++] = sdk;
        }
        this.removeSDKs(sdks);
    }

    protected void setCheckedSDK(SDK element) {
        if (element == null) {
            this.setSelection((ISelection)new StructuredSelection());
        } else {
            this.setSelection((ISelection)new StructuredSelection((Object)element));
            SDK[] sDKArray = this.getSDKs();
            int n = sDKArray.length;
            int n2 = 0;
            while (n2 < n) {
                SDK sdk = sDKArray[n2];
                sdk.setDefault(false);
                ++n2;
            }
            element.setDefault(true);
        }
        if (this.page != null) {
            this.page.getContainer().updateButtons();
        }
    }

    protected void setSDKs(SDK[] sdks) {
        SDK defaultSDK = null;
        this.sdkList.clear();
        SDK[] sDKArray = sdks;
        int n = sdks.length;
        int n2 = 0;
        while (n2 < n) {
            SDK sdk = sDKArray[n2];
            this.sdkList.add(sdk);
            if (sdk.isDefault()) {
                defaultSDK = sdk;
            }
            ++n2;
        }
        this.tableViewer.setInput((Object)sdks);
        if (defaultSDK != null) {
            this.setCheckedSDK(defaultSDK);
        }
        this.tableViewer.refresh();
    }

    protected void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.equals(this.fPrevSelection)) {
            this.fPrevSelection = selection;
            Object sdk = ((IStructuredSelection)selection).getFirstElement();
            if (sdk == null) {
                this.tableViewer.setCheckedElements(new Object[0]);
            } else {
                this.tableViewer.setCheckedElements(new Object[]{sdk});
                this.tableViewer.reveal(sdk);
            }
            this.fireSelectionChanged();
        }
    }

    protected class SDKContentProvider
    implements IStructuredContentProvider {
        protected SDKContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return InstalledSDKsCompostite.this.sdkList.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected class SDKLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected SDKLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return SDKPlugin.getDefault().getImage("IMG_ICON_SDK_SMALL");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String retval = null;
            if (element instanceof SDK) {
                SDK sdk = (SDK)element;
                switch (columnIndex) {
                    case 0: {
                        retval = sdk.getName();
                        break;
                    }
                    case 1: {
                        retval = sdk.getVersion();
                        break;
                    }
                    case 2: {
                        retval = sdk.getLocation().toOSString();
                    }
                }
            } else {
                retval = "";
            }
            return retval;
        }
    }
}

