/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.sdk.util;

import com.liferay.ide.eclipse.sdk.ISDKConstants;
import com.liferay.ide.eclipse.sdk.SDK;
import com.liferay.ide.eclipse.sdk.SDKManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Version;

public class SDKUtil {
    public static boolean isSDKSupported(String location) {
        boolean retval = false;
        try {
            String version = SDKUtil.readSDKVersion(location);
            retval = new Version(version).compareTo((Object)ISDKConstants.LEAST_SUPPORTED_SDK_VERSION) >= 0;
        }
        catch (Exception exception) {}
        return retval;
    }

    public static boolean isValidSDKLocation(String loc) {
        boolean retval = false;
        try {
            String version = SDKUtil.readSDKVersion(loc);
            new Version(version);
            File sdkDir = new File(loc);
            File portletsBuildXml = new File(sdkDir, ISDKConstants.PORTLET_PLUGIN_ANT_BUILD);
            File hooksBuildXml = new File(sdkDir, ISDKConstants.HOOK_PLUGIN_ANT_BUILD);
            File extBuildXml = new File(sdkDir, ISDKConstants.EXT_PLUGIN_ANT_BUILD);
            retval = portletsBuildXml.exists() && hooksBuildXml.exists() && extBuildXml.exists();
        }
        catch (Exception exception) {}
        return retval;
    }

    public static boolean isValidSDKVersion(String sdkVersion, Version lowestValidVersion) {
        Version sdkVersionValue = null;
        try {
            sdkVersionValue = new Version(sdkVersion);
        }
        catch (Exception exception) {}
        return sdkVersionValue != null && sdkVersionValue.compareTo((Object)lowestValidVersion) >= 0;
    }

    public static String readSDKVersion(String path) throws FileNotFoundException, IOException {
        Properties properties = new Properties();
        properties.load(new FileInputStream(new Path(path).append("build.properties").toFile()));
        return properties.getProperty("lp.version");
    }

    public static SDK getSDKFromProjectDir(File projectDir) {
        File sdkDir = projectDir.getParentFile().getParentFile();
        if (sdkDir.exists() && SDKUtil.isValidSDKLocation(sdkDir.getPath())) {
            Path sdkLocation = new Path(sdkDir.getPath());
            SDK existingSDK = SDKManager.getInstance().getSDK((IPath)sdkLocation);
            if (existingSDK != null) {
                return existingSDK;
            }
            return SDKUtil.createSDKFromLocation((IPath)sdkLocation);
        }
        return null;
    }

    public static SDK createSDKFromLocation(IPath path) {
        try {
            SDK sdk = new SDK(path);
            sdk.setVersion(SDKUtil.readSDKVersion(path.toString()));
            sdk.setName(path.lastSegment());
            return sdk;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

