/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.server.core;

import com.liferay.ide.eclipse.core.CorePlugin;
import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.server.core.AbstractPluginPublisher;
import com.liferay.ide.eclipse.server.core.AbstractRuntimeDelegateValidator;
import com.liferay.ide.eclipse.server.core.IPluginPublisher;
import com.liferay.ide.eclipse.server.core.IRuntimeDelegateValidator;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.model.RuntimeDelegate;
import org.osgi.framework.BundleContext;

public class LiferayServerCorePlugin
extends CorePlugin {
    public static final String PLUGIN_ID = "com.liferay.ide.eclipse.server.core";
    private static LiferayServerCorePlugin plugin;
    private static IPluginPublisher[] pluginPublishers;
    private static IRuntimeDelegateValidator[] runtimeDelegateValidators;

    static {
        pluginPublishers = null;
    }

    public static IStatus createErrorStatus(String msg) {
        return LiferayServerCorePlugin.createErrorStatus((String)PLUGIN_ID, (String)msg);
    }

    public static LiferayServerCorePlugin getDefault() {
        return plugin;
    }

    public static IPluginPublisher getPluginPublisher(String facetId, String runtimeTypeId) {
        if (CoreUtil.isNullOrEmpty((String)facetId) || CoreUtil.isNullOrEmpty((String)runtimeTypeId)) {
            return null;
        }
        IPluginPublisher retval = null;
        IPluginPublisher[] publishers = LiferayServerCorePlugin.getPluginPublishers();
        if (publishers != null && publishers.length > 0) {
            IPluginPublisher[] iPluginPublisherArray = publishers;
            int n = publishers.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginPublisher publisher = iPluginPublisherArray[n2];
                if (publisher != null && facetId.equals(publisher.getFacetId()) && runtimeTypeId.equals(publisher.getRuntimeTypeId())) {
                    retval = publisher;
                    break;
                }
                ++n2;
            }
        }
        return retval;
    }

    public static IPluginPublisher[] getPluginPublishers() {
        if (pluginPublishers == null) {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.liferay.ide.eclipse.server.core.pluginPublishers");
            try {
                ArrayList<AbstractPluginPublisher> deployers = new ArrayList<AbstractPluginPublisher>();
                IConfigurationElement[] iConfigurationElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    Object o = element.createExecutableExtension("class");
                    if (o instanceof AbstractPluginPublisher) {
                        AbstractPluginPublisher pluginDeployer = (AbstractPluginPublisher)o;
                        pluginDeployer.setFacetId(element.getAttribute("facetId"));
                        pluginDeployer.setRuntimeTypeId(element.getAttribute("runtimeTypeId"));
                        deployers.add(pluginDeployer);
                    }
                    ++n2;
                }
                pluginPublishers = deployers.toArray(new IPluginPublisher[0]);
            }
            catch (Exception e) {
                LiferayServerCorePlugin.logError("Unable to get plugin deployer extensions", e);
            }
        }
        return pluginPublishers;
    }

    public static IRuntimeDelegateValidator[] getRuntimeDelegateValidators() {
        if (runtimeDelegateValidators == null) {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.liferay.ide.eclipse.server.core.runtimeDelegateValidators");
            try {
                ArrayList<AbstractRuntimeDelegateValidator> validators = new ArrayList<AbstractRuntimeDelegateValidator>();
                IConfigurationElement[] iConfigurationElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    Object o = element.createExecutableExtension("class");
                    String runtimeTypeId = element.getAttribute("runtimeTypeId");
                    if (o instanceof AbstractRuntimeDelegateValidator) {
                        AbstractRuntimeDelegateValidator validator = (AbstractRuntimeDelegateValidator)o;
                        validator.setRuntimeTypeId(runtimeTypeId);
                        validators.add(validator);
                    }
                    ++n2;
                }
                runtimeDelegateValidators = validators.toArray(new IRuntimeDelegateValidator[0]);
            }
            catch (Exception e) {
                LiferayServerCorePlugin.logError("Unable to get IRuntimeDelegateValidator extensions", e);
            }
        }
        return runtimeDelegateValidators;
    }

    public static void logError(Exception e) {
        LiferayServerCorePlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e));
    }

    public static void logError(String msg, Exception e) {
        LiferayServerCorePlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, msg, (Throwable)e));
    }

    public static IStatus validateRuntimeDelegate(RuntimeDelegate runtimeDelegate) {
        if (runtimeDelegate.getRuntime().isStub()) {
            return Status.OK_STATUS;
        }
        String runtimeTypeId = runtimeDelegate.getRuntime().getRuntimeType().getId();
        Object[] validators = LiferayServerCorePlugin.getRuntimeDelegateValidators();
        if (!CoreUtil.isNullOrEmpty((Object[])validators)) {
            Object[] objectArray = validators;
            int n = validators.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus status;
                Object validator = objectArray[n2];
                if (runtimeTypeId.equals(validator.getRuntimeTypeId()) && !(status = validator.validateRuntimeDelegate(runtimeDelegate)).isOK()) {
                    return status;
                }
                ++n2;
            }
        }
        return Status.OK_STATUS;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static /* bridge */ /* synthetic */ CorePlugin getDefault() {
        return LiferayServerCorePlugin.getDefault();
    }
}

