/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.server.util;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.server.core.ILiferayRuntime;
import com.liferay.ide.eclipse.server.core.LiferayServerCorePlugin;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.internal.BridgedRuntime;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerUtil {
    protected static final IStatus emptyInstallDirStatus = ServerUtil.createErrorStatus("Install directory is empty.");
    protected static final IStatus installDirDoesNotExist = ServerUtil.createErrorStatus("Install directory does not exist.");
    protected static final IStatus invalidInstallDirStatus = ServerUtil.createErrorStatus("Invalid installation directory.");

    public static IStatus createErrorStatus(String msg) {
        return new Status(4, "com.liferay.ide.eclipse.server.core", msg);
    }

    public static IServerWorkingCopy createServerForRuntime(IRuntime runtime) {
        IServerType[] iServerTypeArray = ServerCore.getServerTypes();
        int n = iServerTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServerType serverType = iServerTypeArray[n2];
            if (serverType.getRuntimeType().equals(runtime.getRuntimeType())) {
                try {
                    return serverType.createServer("server", null, runtime, null);
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
        return null;
    }

    public static IPath getAppServerDir(org.eclipse.wst.common.project.facet.core.runtime.IRuntime serverRuntime) {
        ILiferayRuntime runtime = (ILiferayRuntime)ServerUtil.getRuntimeAdapter(serverRuntime, ILiferayRuntime.class);
        return runtime != null ? runtime.getAppServerDir() : null;
    }

    public static IPath getPortalDir(IJavaProject project) {
        return ServerUtil.getPortalDir(project.getProject());
    }

    public static IPath getPortalDir(IProject project) {
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = facetedProject.getPrimaryRuntime();
            if (runtime != null) {
                return ServerUtil.getPortalDir(runtime);
            }
        }
        catch (CoreException e) {
            LiferayServerCorePlugin.logError((Exception)((Object)e));
        }
        return null;
    }

    public static IPath getPortalDir(org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime) {
        ILiferayRuntime runtime = (ILiferayRuntime)ServerUtil.getRuntimeAdapter(facetRuntime, ILiferayRuntime.class);
        return runtime != null ? runtime.getPortalDir() : null;
    }

    public static ILiferayRuntime getLiferayRuntime(IProject project) throws CoreException {
        return (ILiferayRuntime)ServerUtil.getRuntimeAdapter(ProjectFacetsManager.create((IProject)project).getPrimaryRuntime(), ILiferayRuntime.class);
    }

    public static ILiferayRuntime getLiferayRuntime(IRuntime runtime) {
        if (runtime != null) {
            return (ILiferayRuntime)runtime.createWorkingCopy().loadAdapter(ILiferayRuntime.class, null);
        }
        return null;
    }

    public static ILiferayRuntime getLiferayRuntime(IServer server) {
        if (server != null) {
            return ServerUtil.getLiferayRuntime(server.getRuntime());
        }
        return null;
    }

    public static IRuntime getRuntime(IProject project) throws CoreException {
        return (IRuntime)ServerUtil.getRuntimeAdapter(ProjectFacetsManager.create((IProject)project).getPrimaryRuntime(), IRuntime.class);
    }

    public static IRuntime getRuntime(org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime) {
        return ServerCore.findRuntime((String)runtime.getProperty("id"));
    }

    public static IRuntimeWorkingCopy getRuntime(String runtimeTypeId, IPath location) {
        IRuntimeType runtimeType = ServerCore.findRuntimeType((String)runtimeTypeId);
        try {
            IRuntimeWorkingCopy runtime = runtimeType.createRuntime("runtime", null);
            IRuntimeWorkingCopy runtimeWC = runtime.createWorkingCopy();
            runtimeWC.setName("Runtime");
            runtimeWC.setLocation(location);
            return runtimeWC;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getRuntimeAdapter(org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime, Class<?> adapterClass) {
        String runtimeId = facetRuntime.getProperty("id");
        IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
        int n = iRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime runtime = iRuntimeArray[n2];
            if (runtime.getId().equals(runtimeId)) {
                if (IRuntime.class.equals(adapterClass)) {
                    return runtime;
                }
                IRuntimeWorkingCopy runtimeWC = null;
                runtimeWC = !runtime.isWorkingCopy() ? runtime.createWorkingCopy() : (IRuntimeWorkingCopy)runtime;
                return (ILiferayRuntime)runtimeWC.loadAdapter(adapterClass, null);
            }
            ++n2;
        }
        return null;
    }

    public static IServer[] getServersForRuntime(IRuntime runtime) {
        Object[] servers;
        ArrayList<Object> serverList = new ArrayList<Object>();
        if (runtime != null && !CoreUtil.isNullOrEmpty((Object[])(servers = ServerCore.getServers()))) {
            Object[] objectArray = servers;
            int n = servers.length;
            int n2 = 0;
            while (n2 < n) {
                Object server = objectArray[n2];
                if (runtime.equals(server.getRuntime())) {
                    serverList.add(server);
                }
                ++n2;
            }
        }
        return serverList.toArray(new IServer[0]);
    }

    public static boolean isExistingVMName(String name) {
        IVMInstall[] iVMInstallArray = JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType").getVMInstalls();
        int n = iVMInstallArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstall vm = iVMInstallArray[n2];
            if (vm.getName().equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isLiferayRuntime(BridgedRuntime bridgedRuntime) {
        IRuntime runtime = ServerCore.findRuntime((String)bridgedRuntime.getProperty("id"));
        return ServerUtil.isLiferayRuntime(runtime);
    }

    public static boolean isLiferayRuntime(IRuntime runtime) {
        return ServerUtil.getLiferayRuntime(runtime) != null;
    }

    public static boolean isLiferayRuntime(IServer server) {
        return ServerUtil.getLiferayRuntime(server) != null;
    }

    public static boolean isValidPropertiesFile(File file) {
        if (file == null || !file.exists()) {
            return false;
        }
        try {
            new PropertiesConfiguration(file);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

