/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.ui.internal.assembly.wizard;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.viewsupport.FilteredElementTreeSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.common.ui.internal.JstCommonUIPlugin;
import org.eclipse.jst.common.ui.internal.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.IWizardHandle;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.WizardFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarReferenceWizardFragment
extends WizardFragment {
    protected LabelProvider labelProvider = null;
    protected ITreeContentProvider contentProvider = null;
    protected TreeViewer viewer;
    protected Button add;
    protected Button remove;
    protected IPath[] paths;
    protected IWizardHandle handle;
    protected IPath[] selected = new IPath[0];
    protected Map<IPath, IPath> archives = new HashMap<IPath, IPath>();
    boolean isComplete = false;

    public boolean isComplete() {
        return this.isComplete;
    }

    public boolean hasComposite() {
        return true;
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.handle = handle;
        handle.setTitle(Messages.ArchiveTitle);
        handle.setDescription(Messages.ArchiveDescription);
        handle.setImageDescriptor(JavaPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        Composite c = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)c, "org.eclipse.jst.common.ui.DEPLOYMENT_ASSEMBLY_NEW_ARCHIVE_REFERENCE_P1");
        c.setLayout((Layout)new GridLayout(2, false));
        this.viewer = new TreeViewer(c, 2050);
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace());
        Composite buttonColumn = new Composite(c, 0);
        buttonColumn.setLayoutData((Object)new GridData(1040));
        GridLayout gl = new GridLayout();
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        buttonColumn.setLayout((Layout)gl);
        this.add = new Button(buttonColumn, 0);
        this.add.setText(Messages.Add);
        GridDataFactory.defaultsFor((Control)this.add).applyTo((Control)this.add);
        this.remove = new Button(buttonColumn, 0);
        this.remove.setText(Messages.Remove);
        GridDataFactory.defaultsFor((Control)this.remove).applyTo((Control)this.remove);
        this.add.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JarReferenceWizardFragment.this.buttonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.remove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JarReferenceWizardFragment.this.removeButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return c;
    }

    protected void buttonPressed() {
        IProject project = (IProject)this.getTaskModel().getObject("root.project");
        this.selected = JarReferenceWizardFragment.chooseEntries(this.add.getShell(), project.getFullPath());
        if (this.selected != null) {
            this.removeInvalidArchiveFiles();
            IPath[] iPathArray = this.selected;
            int n = this.selected.length;
            int n2 = 0;
            while (n2 < n) {
                IPath path = iPathArray[n2];
                if (!this.archives.containsKey(path)) {
                    this.archives.put(path, path);
                }
                ++n2;
            }
            this.viewer.refresh();
            this.isComplete = this.archives != null && this.archives.size() > 0;
            this.handle.update();
        }
    }

    protected void removeButtonPressed() {
        TreeItem[] toRemove = this.viewer.getTree().getSelection();
        if (toRemove != null && toRemove.length > 0) {
            int i = 0;
            while (i < toRemove.length) {
                Path path = (Path)toRemove[i].getData();
                if (this.archives.containsKey(path)) {
                    this.archives.remove(path);
                }
                ++i;
            }
            this.viewer.refresh();
            this.isComplete = this.archives != null && this.archives.size() > 0;
            this.handle.update();
        }
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        IVirtualComponent rootComponent = (IVirtualComponent)this.getTaskModel().getObject("root.component");
        String runtimeLoc = (String)this.getTaskModel().getObject("default.library.location");
        if (this.archives != null && this.archives.size() > 0) {
            ArrayList<VirtualReference> refList = new ArrayList<VirtualReference>();
            for (Path path : this.archives.values()) {
                String type = "lib/";
                IVirtualComponent archive = ComponentCore.createArchiveComponent((IProject)rootComponent.getProject(), (String)(String.valueOf(type) + path.makeRelative().toString()));
                VirtualReference ref = new VirtualReference(rootComponent, archive);
                ref.setArchiveName(path.lastSegment());
                if (runtimeLoc != null) {
                    ref.setRuntimePath(new Path(runtimeLoc).makeAbsolute());
                }
                refList.add(ref);
            }
            IVirtualReference[] iVirtualReferenceArray = refList.toArray(new IVirtualReference[refList.size()]);
            this.getTaskModel().putObject("dependency.reference.final", (Object)iVirtualReferenceArray);
        }
    }

    protected LabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new LabelProvider(){

                public Image getImage(Object element) {
                    return null;
                }

                public String getText(Object element) {
                    return element == null ? "" : element.toString();
                }
            };
        }
        return this.labelProvider;
    }

    protected ITreeContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = new ITreeContentProvider(){

                public Object[] getElements(Object inputElement) {
                    return JarReferenceWizardFragment.this.archives == null ? new Object[]{} : JarReferenceWizardFragment.this.archives.values().toArray();
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public boolean hasChildren(Object element) {
                    return false;
                }

                public Object getParent(Object element) {
                    return null;
                }

                public Object[] getChildren(Object parentElement) {
                    return null;
                }
            };
        }
        return this.contentProvider;
    }

    private static IPath[] chooseEntries(Shell shell, IPath initialSelection) {
        Class[] acceptedClasses = new Class[]{IFile.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, true);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        FilteredElementTreeSelectionDialog dialog = new FilteredElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setHelpAvailable(false);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(Messages.ArchiveDialogNewTitle);
        dialog.setMessage(Messages.ArchiveDialogNewDescription);
        dialog.addFilter(JarReferenceWizardFragment.getDialogViewerFilter());
        dialog.setInput((Object)root);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setInitialFilter("*.jar,*.war,*.rar,*.zip");
        dialog.create();
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            IPath[] res = new IPath[elements.length];
            int i = 0;
            while (i < res.length) {
                IResource elem = (IResource)elements[i];
                res[i] = elem.getFullPath();
                ++i;
            }
            return res;
        }
        return null;
    }

    protected void removeInvalidArchiveFiles() {
        ArrayList<IPath> invalidArchiveFiles = new ArrayList<IPath>();
        ArrayList<IPath> validArchiveFiles = new ArrayList<IPath>();
        ZipFile zipFile = null;
        IPath[] iPathArray = this.selected;
        int n = this.selected.length;
        int n2 = 0;
        while (n2 < n) {
            block21: {
                IPath path = iPathArray[n2];
                try {
                    IPath loc;
                    IFile file;
                    String osPath = null;
                    if (path.segmentCount() > 1 && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)).exists() && (loc = file.getLocation()) != null) {
                        osPath = loc.toOSString();
                    }
                    if (osPath == null) {
                        osPath = path.toOSString();
                    }
                    zipFile = new ZipFile(new File(osPath));
                    validArchiveFiles.add(path);
                }
                catch (ZipException zipException) {
                    invalidArchiveFiles.add(path);
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException e) {
                            JstCommonUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.jst.common.ui", e.getMessage(), (Throwable)e));
                        }
                    }
                    break block21;
                }
                catch (IOException iOException) {
                    try {
                        invalidArchiveFiles.add(path);
                        break block21;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (zipFile != null) {
                            try {
                                zipFile.close();
                            }
                            catch (IOException e) {
                                JstCommonUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.jst.common.ui", e.getMessage(), (Throwable)e));
                            }
                        }
                    }
                }
                if (zipFile == null) break block21;
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    JstCommonUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.jst.common.ui", e.getMessage(), (Throwable)e));
                }
            }
            ++n2;
        }
        if (invalidArchiveFiles.size() > 0) {
            this.selected = validArchiveFiles.toArray(new IPath[validArchiveFiles.size()]);
            this.showInvalidArchiveFilesAsWarning(invalidArchiveFiles);
        }
    }

    private void showInvalidArchiveFilesAsWarning(ArrayList<IPath> invalidArchiveFiles) {
        String message = Messages.InvalidArchivesWarning;
        boolean first = true;
        for (IPath path : invalidArchiveFiles) {
            if (!first) {
                message = String.valueOf(message) + ", '";
            } else {
                message = String.valueOf(message) + "'";
                first = false;
            }
            message = String.valueOf(message) + path.lastSegment() + "'";
        }
        MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Warning", (String)message);
    }

    private static ViewerFilter getDialogViewerFilter() {
        return new ViewerFilter(){
            private final String[] excludedExtensions = new String[]{"txt", "css", "dll", "htm", "html", "class", "java", "classpath", "compatibility", "component", "container", "cvsignore", "del", "dnx", "dtd", "mf", "project", "properties", "psf", "rc", "runtime", "sh", "spec", "sql", "tld", "xmi", "xml", "xsd", "gif", "jpg", "js", "vsd", "png", "bat", "xsl", "factorypath"};
            private HashMap<String, String> excludedExtensionsMap = null;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean select(Viewer viewer, Object parent, Object element) {
                IFolder folder;
                if (this.excludedExtensionsMap == null) {
                    this.initializeExludeMap();
                }
                if (element instanceof IFile) {
                    IFile file = (IFile)element;
                    String ext = file.getFileExtension();
                    if (ext == null) return true;
                    if (this.excludedExtensionsMap.get(ext = ext.toLowerCase()) == null) return true;
                    return false;
                }
                if (!(element instanceof IContainer)) return false;
                if (element instanceof IProject && !((IProject)element).isOpen()) {
                    return false;
                }
                if (element instanceof IFolder && (folder = (IFolder)element).getName().equals(".settings")) {
                    return false;
                }
                try {
                    IResource[] resources = ((IContainer)element).members();
                    int i = 0;
                    while (true) {
                        if (i >= resources.length) {
                            return false;
                        }
                        if (this.select(viewer, parent, resources[i])) {
                            return true;
                        }
                        ++i;
                    }
                }
                catch (CoreException e) {
                    JavaPlugin.log((IStatus)e.getStatus());
                }
                return false;
            }

            private void initializeExludeMap() {
                this.excludedExtensionsMap = new HashMap();
                int i = 0;
                while (i < this.excludedExtensions.length) {
                    this.excludedExtensionsMap.put(this.excludedExtensions[i], this.excludedExtensions[i]);
                    ++i;
                }
            }
        };
    }
}

