/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.provisional.commons.ui;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.mylyn.internal.commons.ui.Messages;
import org.eclipse.mylyn.internal.provisional.commons.ui.DatePickerPanel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DateSelectionDialog
extends Dialog {
    private Date selectedDate = null;
    private String title = Messages.DateSelectionDialog_Date_Selection;
    private final Calendar initialCalendar = Calendar.getInstance();
    private boolean includeTime = true;
    private int hourOfDay = 0;

    public DateSelectionDialog(Shell parentShell, Calendar initialDate, String title, boolean includeTime, int hourOfDay) {
        super(parentShell);
        this.includeTime = includeTime;
        this.hourOfDay = hourOfDay;
        if (title != null) {
            this.title = title;
        }
        if (initialDate != null) {
            this.initialCalendar.setTime(initialDate.getTime());
        }
        this.selectedDate = this.initialCalendar.getTime();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        DatePickerPanel datePanel = new DatePickerPanel(parent, 0, this.initialCalendar, this.includeTime, this.hourOfDay);
        datePanel.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    DatePickerPanel.DateSelection dateSelection = (DatePickerPanel.DateSelection)event.getSelection();
                    DateSelectionDialog.this.selectedDate = dateSelection.getDate().getTime();
                    if (dateSelection.isDefaultSelection()) {
                        DateSelectionDialog.this.okPressed();
                    }
                }
            }
        });
        datePanel.setLayoutData(new GridData(0x1000000, 0x1000000, false, false));
        DateSelectionDialog.applyDialogFont((Control)datePanel);
        return datePanel;
    }

    public boolean close() {
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 1025) {
            this.selectedDate = null;
            this.okPressed();
        }
    }

    public Date getDate() {
        return this.selectedDate;
    }
}

