/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.portlet.vaadin.core.dd;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.portlet.core.PluginPropertiesConfiguration;
import com.liferay.ide.eclipse.portlet.core.dd.PortletDescriptorHelper;
import com.liferay.ide.eclipse.portlet.vaadin.core.VaadinCore;
import com.liferay.ide.eclipse.portlet.vaadin.core.operation.INewVaadinPortletClassDataModelProperties;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class VaadinPortletDescriptorHelper
extends PortletDescriptorHelper
implements INewVaadinPortletClassDataModelProperties {
    public VaadinPortletDescriptorHelper(IProject project) {
        super(project);
    }

    public IStatus addNewPortlet(IDataModel model) {
        IStatus status = super.addNewPortlet(model);
        if (!status.isOK()) {
            return status;
        }
        return this.addPortalDependency("portal-dependency-jars", "vaadin.jar");
    }

    public IStatus addPortalDependency(String propertyName, String value) {
        if (CoreUtil.isNullOrEmpty((String)value)) {
            return Status.OK_STATUS;
        }
        try {
            String[] existingValues;
            IVirtualComponent comp = ComponentCore.createComponent((IProject)this.project.getProject());
            if (comp == null) {
                IStatus warning = VaadinCore.createWarningStatus("Could not add Vaadin dependency to the project.");
                VaadinCore.getDefault().getLog().log(warning);
                return Status.OK_STATUS;
            }
            IFolder webroot = (IFolder)comp.getRootFolder().getUnderlyingFolder();
            IFile pluginPackageFile = webroot.getFile("WEB-INF/liferay-plugin-package.properties");
            if (!pluginPackageFile.exists()) {
                IStatus warning = VaadinCore.createWarningStatus("No liferay-plugin-package.properties file in the project, not adding Vaadin dependency.");
                VaadinCore.getDefault().getLog().log(warning);
                return Status.OK_STATUS;
            }
            File osfile = new File(pluginPackageFile.getLocation().toOSString());
            PluginPropertiesConfiguration pluginPackageProperties = new PluginPropertiesConfiguration();
            pluginPackageProperties.load(osfile);
            String existingDeps = pluginPackageProperties.getString(propertyName, "");
            String[] stringArray = existingValues = existingDeps.split(",");
            int n = existingValues.length;
            int n2 = 0;
            while (n2 < n) {
                String existingValue = stringArray[n2];
                if (value.equals(existingValue)) {
                    return Status.OK_STATUS;
                }
                ++n2;
            }
            String newPortalDeps = null;
            newPortalDeps = CoreUtil.isNullOrEmpty((String)existingDeps) ? value : String.valueOf(existingDeps) + "," + value;
            pluginPackageProperties.setProperty(propertyName, (Object)newPortalDeps);
            FileWriter output = new FileWriter(osfile);
            try {
                pluginPackageProperties.save((Writer)output);
            }
            finally {
                output.close();
            }
            pluginPackageFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            VaadinCore.logError(e);
            return VaadinCore.createErrorStatus("Could not add dependency to vaadin.jar in liferay-plugin-package.properties .");
        }
        return Status.OK_STATUS;
    }

    protected String getPortletClassText(IDataModel model) {
        return model.getStringProperty("INewVaadinPortletClassDataModelProperties.VAADIN_PORTLET_CLASS");
    }
}

