/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.server.tomcat.ui;

import com.liferay.ide.eclipse.project.ui.ProjectUIPlugin;
import com.liferay.ide.eclipse.project.ui.action.AbstractProjectAction;
import com.liferay.ide.eclipse.server.tomcat.core.ILiferayTomcatRuntime;
import com.liferay.ide.eclipse.server.tomcat.core.job.CleanAppServerJob;
import com.liferay.ide.eclipse.server.tomcat.core.util.LiferayTomcatUtil;
import com.liferay.ide.eclipse.server.util.ServerUtil;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.internal.wizard.WizardTaskUtil;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class CleanAppServerAction
extends AbstractProjectAction {
    public void run(IAction action) {
        try {
            if (!(this.fSelection instanceof IStructuredSelection)) {
                return;
            }
            Object elem = ((IStructuredSelection)this.fSelection).toArray()[0];
            if (!(elem instanceof IProject)) {
                return;
            }
            IProject project = (IProject)elem;
            IRuntime runtime = ServerUtil.getRuntime((IProject)project);
            ILiferayTomcatRuntime portalTomcatRuntime = LiferayTomcatUtil.getLiferayTomcatRuntime((IRuntime)runtime);
            if (portalTomcatRuntime == null) {
                return;
            }
            IStatus status = runtime.validate((IProgressMonitor)new NullProgressMonitor());
            IPath bundleZipLocation = portalTomcatRuntime.getBundleZipLocation();
            if (!status.isOK() || bundleZipLocation == null || !bundleZipLocation.toFile().exists()) {
                boolean retval = MessageDialog.openQuestion((Shell)this.getDisplay().getActiveShell(), (String)this.getTitle(), (String)("A valid bundle zip location is required for performing this action.  The runtime \"" + runtime.getName() + "\" does not have a valid zip location.\n\nDo you want to specify the location of the bundle zip file now?"));
                if (retval) {
                    this.editRuntime(runtime);
                    portalTomcatRuntime = LiferayTomcatUtil.getLiferayTomcatRuntime((IRuntime)runtime);
                    bundleZipLocation = portalTomcatRuntime.getBundleZipLocation();
                    if (bundleZipLocation == null) {
                        return;
                    }
                    this.run(action);
                    return;
                }
                return;
            }
            this.cleanAppServer(project);
        }
        catch (Exception ex) {
            ProjectUIPlugin.logError((Exception)ex);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
    }

    protected void cleanAppServer(IProject project) throws CoreException {
        String[] labels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
        MessageDialog dialog = new MessageDialog(this.getDisplay().getActiveShell(), this.getTitle(), null, "Performing this action will delete the entire tomcat directory including all configuration, data, and deployed webapps.  If you have other plugins deployed they will have to be republished.\n\nDo you wish to continue?", 4, labels, 1);
        int retval = dialog.open();
        if (retval == 0) {
            new CleanAppServerJob(project).schedule();
        }
    }

    protected void editRuntime(IRuntime runtime) {
        IRuntimeWorkingCopy runtimeWorkingCopy = runtime.createWorkingCopy();
        if (this.showWizard(runtimeWorkingCopy) != 1) {
            try {
                runtimeWorkingCopy.save(false, null);
            }
            catch (Exception exception) {}
        }
    }

    protected String getTitle() {
        return "Clean App Server";
    }

    protected int showWizard(IRuntimeWorkingCopy runtimeWorkingCopy) {
        String title = Messages.wizEditRuntimeWizardTitle;
        final WizardFragment fragment2 = ServerUIPlugin.getWizardFragment((String)runtimeWorkingCopy.getRuntimeType().getId());
        if (fragment2 == null) {
            return 1;
        }
        TaskModel taskModel = new TaskModel();
        taskModel.putObject("runtime", (Object)runtimeWorkingCopy);
        WizardFragment fragment = new WizardFragment(){

            protected void createChildFragments(List<WizardFragment> list) {
                list.add((WizardFragment)fragment2.getChildFragments().get(0));
                list.add(WizardTaskUtil.SaveRuntimeFragment);
            }
        };
        TaskWizard wizard = new TaskWizard(title, fragment, taskModel);
        wizard.setForcePreviousAndNextButtons(true);
        WizardDialog dialog = new WizardDialog(this.getDisplay().getActiveShell(), (IWizard)wizard);
        return dialog.open();
    }
}

