/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.server.tomcat.ui.wizard;

import com.liferay.ide.eclipse.server.tomcat.core.ILiferayTomcatRuntime;
import com.liferay.ide.eclipse.server.tomcat.core.util.LiferayTomcatUtil;
import com.liferay.ide.eclipse.server.ui.LiferayServerUIPlugin;
import com.liferay.ide.eclipse.ui.util.SWTUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jst.server.core.IJavaRuntime;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatRuntimeWorkingCopy;
import org.eclipse.jst.server.tomcat.ui.internal.TomcatRuntimeComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class LiferayTomcatRuntimeOptionalComposite
extends TomcatRuntimeComposite
implements ModifyListener {
    protected Text bundleZipField;
    protected boolean ignoreModifyEvent;

    public static void setFieldValue(Text field, String value) {
        if (field != null && !field.isDisposed()) {
            field.setText(value != null ? value : "");
        }
    }

    public LiferayTomcatRuntimeOptionalComposite(Composite parent, IWizardHandle wizard) {
        super(parent, wizard);
        wizard.setTitle("Liferay Runtime Tomcat Bundle");
        wizard.setDescription("Specify extra settings for Liferay Tomcat bundle (required for Ext plugins)");
        wizard.setImageDescriptor(LiferayServerUIPlugin.getImageDescriptor((String)"imgWizRuntime"));
    }

    public void modifyText(ModifyEvent e) {
        if (this.ignoreModifyEvent) {
            this.ignoreModifyEvent = false;
            return;
        }
        if (e.getSource().equals(this.bundleZipField)) {
            this.geLiferayTomcatRuntime().setBundleZipLocation((IPath)new Path(this.bundleZipField.getText()));
        }
        this.validate();
    }

    public void setRuntime(IRuntimeWorkingCopy newRuntime) {
        if (newRuntime == null) {
            this.runtimeWC = null;
            this.runtime = null;
        } else {
            this.runtimeWC = newRuntime;
            this.runtime = (ITomcatRuntimeWorkingCopy)newRuntime.loadAdapter(ITomcatRuntimeWorkingCopy.class, null);
        }
        this.init();
        this.validate();
    }

    protected Button createButton(String text, int style) {
        Button button = new Button((Composite)this, style);
        button.setText(text);
        GridDataFactory.generate((Control)button, (int)2, (int)1);
        return button;
    }

    protected void createControl() {
        this.setLayout(this.createLayout());
        this.setLayoutData(new GridData(1808));
        this.createFields();
        this.init();
        this.validate();
        Dialog.applyDialogFont((Control)this);
    }

    protected void createFields() {
        this.bundleZipField = this.createTextField("Liferay Tomcat bundle zip file (required for Ext plugins)");
        this.bundleZipField.addModifyListener((ModifyListener)this);
        SWTUtil.createButton((Composite)this, (String)"Browse...").addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(LiferayTomcatRuntimeOptionalComposite.this.getShell());
                fd.setText("Select Liferay Tomcat bundle zip file");
                fd.setFilterPath(LiferayTomcatRuntimeOptionalComposite.this.bundleZipField.getText());
                String selectedFile = fd.open();
                if (selectedFile != null) {
                    LiferayTomcatRuntimeOptionalComposite.this.bundleZipField.setText(selectedFile);
                }
            }
        });
    }

    protected Label createLabel(String text) {
        Label label = new Label((Composite)this, 0);
        label.setText(text);
        GridDataFactory.generate((Control)label, (int)2, (int)1);
        return label;
    }

    protected Layout createLayout() {
        GridLayout layout = new GridLayout(2, false);
        return layout;
    }

    protected void createSpacer() {
        new Label((Composite)this, 0);
    }

    protected Text createTextField(String labelText) {
        this.createLabel(labelText);
        Text text = new Text((Composite)this, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    protected IJavaRuntime getJavaRuntime() {
        return this.runtime;
    }

    protected ILiferayTomcatRuntime geLiferayTomcatRuntime() {
        return LiferayTomcatUtil.getLiferayTomcatRuntime((IRuntime)this.runtimeWC);
    }

    protected IRuntimeWorkingCopy getRuntime() {
        return this.runtimeWC;
    }

    protected void init() {
        if (this.bundleZipField == null || this.getRuntime() == null) {
            return;
        }
        IPath bundleZipLocation = this.geLiferayTomcatRuntime().getBundleZipLocation();
        LiferayTomcatRuntimeOptionalComposite.setFieldValue(this.bundleZipField, bundleZipLocation != null ? bundleZipLocation.toOSString() : "");
    }
}

