/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.repository;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.security.ConnectContextFactory;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.filetransfer.UserCancelledException;
import org.eclipse.equinox.internal.p2.repository.Activator;
import org.eclipse.equinox.internal.p2.repository.AuthenticationFailedException;
import org.eclipse.equinox.internal.p2.repository.Credentials;
import org.eclipse.equinox.internal.p2.repository.DownloadStatus;
import org.eclipse.equinox.internal.p2.repository.FileInfo;
import org.eclipse.equinox.internal.p2.repository.FileInfoReader;
import org.eclipse.equinox.internal.p2.repository.FileReader;
import org.eclipse.equinox.internal.p2.repository.JREHttpClientRequiredException;
import org.eclipse.equinox.internal.p2.repository.Messages;
import org.eclipse.equinox.internal.p2.repository.RepositoryPreferences;
import org.eclipse.equinox.internal.p2.repository.RepositoryStatus;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.provisional.p2.repository.IStateful;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.osgi.util.NLS;

public class RepositoryTransport
extends Transport {
    private static RepositoryTransport instance;

    public static synchronized RepositoryTransport getInstance() {
        if (instance == null) {
            instance = new RepositoryTransport();
        }
        return instance;
    }

    public IStatus download(URI toDownload, OutputStream target, long startPos, IProgressMonitor monitor) {
        boolean promptUser = false;
        boolean useJREHttp = false;
        UIServices.AuthenticationInfo loginDetails = null;
        int i = RepositoryPreferences.getLoginRetryCount();
        while (i > 0) {
            block13: {
                FileReader reader = null;
                try {
                    loginDetails = Credentials.forLocation(toDownload, promptUser, loginDetails);
                    IConnectContext context = loginDetails == null ? null : ConnectContextFactory.createUsernamePasswordConnectContext((String)loginDetails.getUserName(), (Object)loginDetails.getPassword());
                    reader = new FileReader(context);
                    reader.readInto(toDownload, target, startPos, monitor);
                    IStatus result = reader.getResult();
                    if (result == null) {
                        String msg = NLS.bind((String)Messages.RepositoryTransport_failedReadRepo, (Object)toDownload);
                        DownloadStatus ds = new DownloadStatus(4, "org.eclipse.equinox.p2.repository", 1002, msg, null);
                        return RepositoryTransport.statusOn(target, ds, reader);
                    }
                    if (result.getSeverity() == 8) {
                        throw new UserCancelledException();
                    }
                    if (!result.isOK()) {
                        throw new CoreException(result);
                    }
                    DownloadStatus status = new DownloadStatus(0, "org.eclipse.equinox.p2.repository", Status.OK_STATUS.getMessage());
                    return RepositoryTransport.statusOn(target, status, reader);
                }
                catch (UserCancelledException userCancelledException) {
                    RepositoryTransport.statusOn(target, new DownloadStatus(8, "org.eclipse.equinox.p2.repository", 1, "", null), reader);
                    throw new OperationCanceledException();
                }
                catch (OperationCanceledException e) {
                    RepositoryTransport.statusOn(target, new DownloadStatus(8, "org.eclipse.equinox.p2.repository", 1, "", null), reader);
                    throw e;
                }
                catch (CoreException e) {
                    if (e.getStatus().getException() == null) {
                        return RepositoryTransport.statusOn(target, RepositoryStatus.forException(e, toDownload), reader);
                    }
                    return RepositoryTransport.statusOn(target, RepositoryStatus.forStatus(e.getStatus(), toDownload), reader);
                }
                catch (FileNotFoundException e) {
                    return RepositoryTransport.statusOn(target, RepositoryStatus.forException(e, toDownload), reader);
                }
                catch (AuthenticationFailedException authenticationFailedException) {
                    promptUser = true;
                }
                catch (Credentials.LoginCanceledException loginCanceledException) {
                    DownloadStatus status = new DownloadStatus(4, "org.eclipse.equinox.p2.repository", 1007, NLS.bind((String)Messages.UnableToRead_0_UserCanceled, (Object)toDownload), null);
                    return RepositoryTransport.statusOn(target, status, null);
                }
                catch (JREHttpClientRequiredException jREHttpClientRequiredException) {
                    if (useJREHttp) break block13;
                    useJREHttp = true;
                    ++i;
                    Activator.getDefault().useJREHttpClient();
                }
            }
            --i;
        }
        DownloadStatus status = new DownloadStatus(4, "org.eclipse.equinox.p2.repository", 1007, NLS.bind((String)Messages.UnableToRead_0_TooManyAttempts, (Object)toDownload), null);
        return RepositoryTransport.statusOn(target, status, null);
    }

    public IStatus download(URI toDownload, OutputStream target, IProgressMonitor monitor) {
        return this.download(toDownload, target, -1L, monitor);
    }

    public InputStream stream(URI toDownload, IProgressMonitor monitor) throws FileNotFoundException, CoreException, AuthenticationFailedException {
        boolean promptUser = false;
        boolean useJREHttp = false;
        UIServices.AuthenticationInfo loginDetails = null;
        int i = RepositoryPreferences.getLoginRetryCount();
        while (i > 0) {
            block8: {
                FileReader reader = null;
                try {
                    loginDetails = Credentials.forLocation(toDownload, promptUser, loginDetails);
                    IConnectContext context = loginDetails == null ? null : ConnectContextFactory.createUsernamePasswordConnectContext((String)loginDetails.getUserName(), (Object)loginDetails.getPassword());
                    reader = new FileReader(context);
                    return reader.read(toDownload, monitor);
                }
                catch (UserCancelledException userCancelledException) {
                    throw new OperationCanceledException();
                }
                catch (AuthenticationFailedException authenticationFailedException) {
                    promptUser = true;
                }
                catch (CoreException e) {
                    if (e.getStatus().getException() == null) {
                        throw new CoreException((IStatus)RepositoryStatus.forException(e, toDownload));
                    }
                    throw new CoreException((IStatus)RepositoryStatus.forStatus(e.getStatus(), toDownload));
                }
                catch (Credentials.LoginCanceledException loginCanceledException) {
                    throw new AuthenticationFailedException();
                }
                catch (JREHttpClientRequiredException jREHttpClientRequiredException) {
                    if (useJREHttp) break block8;
                    useJREHttp = true;
                    ++i;
                    Activator.getDefault().useJREHttpClient();
                }
            }
            --i;
        }
        throw new AuthenticationFailedException();
    }

    private static DownloadStatus statusOn(OutputStream target, DownloadStatus status, FileReader reader) {
        FileInfo fi;
        if (reader != null && (fi = reader.getLastFileInfo()) != null) {
            status.setFileSize(fi.getSize());
            status.setLastModified(fi.getLastModified());
            status.setTransferRate(fi.getAverageSpeed());
        }
        if (target instanceof IStateful) {
            ((IStateful)((Object)target)).setStatus((IStatus)status);
        }
        return status;
    }

    public long getLastModified(URI toDownload, IProgressMonitor monitor) throws CoreException, FileNotFoundException, AuthenticationFailedException {
        boolean promptUser = false;
        boolean useJREHttp = false;
        UIServices.AuthenticationInfo loginDetails = null;
        int i = RepositoryPreferences.getLoginRetryCount();
        while (i > 0) {
            block8: {
                try {
                    loginDetails = Credentials.forLocation(toDownload, promptUser, loginDetails);
                    IConnectContext context = loginDetails == null ? null : ConnectContextFactory.createUsernamePasswordConnectContext((String)loginDetails.getUserName(), (Object)loginDetails.getPassword());
                    FileInfoReader reader = new FileInfoReader(context);
                    return reader.getLastModified(toDownload, monitor);
                }
                catch (UserCancelledException userCancelledException) {
                    throw new OperationCanceledException();
                }
                catch (CoreException e) {
                    if (e.getStatus().getException() == null) {
                        throw new CoreException((IStatus)RepositoryStatus.forException(e, toDownload));
                    }
                    throw new CoreException((IStatus)RepositoryStatus.forStatus(e.getStatus(), toDownload));
                }
                catch (AuthenticationFailedException authenticationFailedException) {
                    promptUser = true;
                }
                catch (Credentials.LoginCanceledException loginCanceledException) {
                    throw new AuthenticationFailedException();
                }
                catch (JREHttpClientRequiredException jREHttpClientRequiredException) {
                    if (useJREHttp) break block8;
                    useJREHttp = true;
                    ++i;
                    Activator.getDefault().useJREHttpClient();
                }
            }
            --i;
        }
        throw new AuthenticationFailedException();
    }
}

