/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.views.palette.PaletteViewerPage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.actions.container.ContainerActionGroup;
import org.eclipse.jst.pagedesigner.actions.menuextension.CustomedContextMenuActionGroup;
import org.eclipse.jst.pagedesigner.actions.range.RangeActionGroup;
import org.eclipse.jst.pagedesigner.actions.single.SingleElementActionGroup;
import org.eclipse.jst.pagedesigner.commands.CopyAction;
import org.eclipse.jst.pagedesigner.commands.CutAction;
import org.eclipse.jst.pagedesigner.commands.DeleteAction;
import org.eclipse.jst.pagedesigner.commands.PasteAction;
import org.eclipse.jst.pagedesigner.dnd.internal.LocalSelectionDropTargetListener;
import org.eclipse.jst.pagedesigner.dnd.internal.PDTemplateTransferDropTargetListener;
import org.eclipse.jst.pagedesigner.dnd.internal.ResouceDropTargetListener;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.jst.pagedesigner.editors.IDesignViewer;
import org.eclipse.jst.pagedesigner.editors.PageDesignerActionConstants;
import org.eclipse.jst.pagedesigner.editors.SelectionSynchronizer;
import org.eclipse.jst.pagedesigner.editors.actions.ActionsMessages;
import org.eclipse.jst.pagedesigner.editors.actions.DesignerUndoRedoAction;
import org.eclipse.jst.pagedesigner.editors.actions.RelatedViewActionGroup;
import org.eclipse.jst.pagedesigner.editors.actions.SkinsMenuItemBuilder;
import org.eclipse.jst.pagedesigner.editors.palette.DesignerPaletteCustomizer;
import org.eclipse.jst.pagedesigner.editors.palette.DesignerPaletteRootFactory;
import org.eclipse.jst.pagedesigner.editors.palette.DesignerPaletteViewerProvider;
import org.eclipse.jst.pagedesigner.editors.palette.IPaletteFactory;
import org.eclipse.jst.pagedesigner.jsp.core.internal.pagevar.DocumentPageVariableAdapter;
import org.eclipse.jst.pagedesigner.jsp.core.pagevar.adapter.PageVariableAdapterFactory;
import org.eclipse.jst.pagedesigner.parts.CSSStyleAdapterFactory;
import org.eclipse.jst.pagedesigner.parts.DocumentEditPart;
import org.eclipse.jst.pagedesigner.parts.HTMLEditPartsFactory;
import org.eclipse.jst.pagedesigner.parts.RefresherFactory;
import org.eclipse.jst.pagedesigner.utils.SelectionHelper;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.wst.sse.core.internal.PropagatingAdapter;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.undo.IDocumentSelectionMediator;
import org.eclipse.wst.sse.core.internal.undo.UndoDocumentEvent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class SimpleGraphicalEditor
extends GraphicalEditorWithFlyoutPalette
implements IDesignViewer,
IDocumentSelectionMediator {
    private HTMLEditor _delegate;
    private IHTMLGraphicalViewer _viewer;
    private IStructuredModel _model;
    private PaletteRoot _palette;
    private PaletteViewerPage _paletteViewerPage;
    private SelectionSynchronizer _synchronizer = new SelectionSynchronizer(this);
    private IModelStateListener _internalModelListener = new IModelStateListener(){

        public void modelAboutToBeChanged(IStructuredModel model) {
        }

        public void modelChanged(IStructuredModel model) {
            SimpleGraphicalEditor.this.updateActionsWhenModelChange();
        }

        public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
        }

        public void modelResourceDeleted(IStructuredModel model) {
        }

        public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
        }

        public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
        }

        public void modelReinitialized(IStructuredModel structuredModel) {
        }
    };
    private PaletteViewerProvider _paletteViewerProvider;
    protected IPaletteFactory _paletteViewerPageFactory;

    public SimpleGraphicalEditor(HTMLEditor delegate, DefaultEditDomain editdomain) {
        this._delegate = delegate;
        this.initPaletteFactory();
        this.setEditDomain(editdomain);
    }

    protected void createGraphicalViewer(Composite parent) {
        this._viewer = IHTMLGraphicalViewer.Factory.createGraphicalViewer((IEditorPart)this);
        Control control = this._viewer.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, PDPlugin.getResourceString("SimpleGraphicalEditor.help.id"));
        this.setGraphicalViewer(this._viewer);
        this.configureGraphicalViewer();
        this.hookGraphicalViewer();
        this.initializeGraphicalViewer();
        this.initializeContextMenu();
    }

    public void dispose() {
        if (this._model != null) {
            this._model.getUndoManager().disconnect((IDocumentSelectionMediator)this);
        }
        super.dispose();
    }

    protected void initializeGraphicalViewer() {
        ScalableRootEditPart rootEditPart = new ScalableRootEditPart();
        this._viewer.setRootEditPart((RootEditPart)rootEditPart);
        this._viewer.getViewport().setContentsTracksWidth(true);
        this._viewer.setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler((GraphicalViewer)this._viewer));
        HTMLEditPartsFactory factory = new HTMLEditPartsFactory(null);
        this._viewer.setEditPartFactory(factory);
        this._viewer.addDropTargetListener((TransferDropTargetListener)new LocalSelectionDropTargetListener((EditPartViewer)this._viewer));
        this._viewer.addDropTargetListener((TransferDropTargetListener)new PDTemplateTransferDropTargetListener((EditPartViewer)this._viewer));
        this._viewer.addDropTargetListener((TransferDropTargetListener)new ResouceDropTargetListener((EditPartViewer)this._viewer));
        this._viewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                try {
                    SimpleGraphicalEditor.this.getSite().getPage().showView("org.eclipse.ui.views.PropertySheet");
                }
                catch (PartInitException partInitException) {}
            }
        });
        super.initializeGraphicalViewer();
    }

    protected void initializeContextMenu() {
        Control gviewer = this._viewer.getControl();
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu(gviewer);
        gviewer.setMenu(menu);
        menuMgr.addMenuListener((IMenuListener)new ContextMenuListener());
        this.getSite().registerContextMenu("HTMLVisualEditor.contextMenu", menuMgr, (ISelectionProvider)this._viewer);
    }

    private void updateActionsWhenModelChange() {
        IAction action = this.getAction("org.eclipse.ui.edit.undo");
        ((UpdateAction)action).update();
        action = this.getAction("org.eclipse.ui.edit.redo");
        ((UpdateAction)action).update();
    }

    protected void createActions() {
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        Action action = new DesignerUndoRedoAction(true, this);
        action.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        action.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO_DISABLED"));
        action.setActionDefinitionId("org.eclipse.ui.edit.undo");
        action.setId("org.eclipse.ui.edit.undo");
        this.getSite().getKeyBindingService().registerAction((IAction)action);
        registry.registerAction((IAction)action);
        action = new DesignerUndoRedoAction(false, this);
        action.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        action.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO_DISABLED"));
        action.setActionDefinitionId("org.eclipse.ui.edit.redo");
        action.setId("org.eclipse.ui.edit.redo");
        this.getSite().getKeyBindingService().registerAction((IAction)action);
        registry.registerAction((IAction)action);
        action = new DeleteAction((GraphicalEditor)this);
        action.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        action.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        action.setActionDefinitionId("org.eclipse.ui.edit.delete");
        action.setId("org.eclipse.ui.edit.delete");
        this.getSite().getKeyBindingService().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        registry.registerAction((IAction)action);
        action = new CopyAction((GraphicalEditor)this);
        action.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        action.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        action.setActionDefinitionId("org.eclipse.ui.edit.copy");
        action.setId("org.eclipse.ui.edit.copy");
        this.getSite().getKeyBindingService().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        registry.registerAction((IAction)action);
        action = new CutAction((GraphicalEditor)this);
        action.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        action.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        action.setActionDefinitionId("org.eclipse.ui.edit.cut");
        action.setId("org.eclipse.ui.edit.cut");
        this.getSite().getKeyBindingService().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        registry.registerAction((IAction)action);
        action = new PasteAction((GraphicalEditor)this);
        action.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        action.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        action.setActionDefinitionId("org.eclipse.ui.edit.paste");
        action.setId("org.eclipse.ui.edit.paste");
        this.getSite().getKeyBindingService().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        registry.registerAction((IAction)action);
    }

    public void doSave(IProgressMonitor monitor) {
        if (this._delegate != null) {
            this._delegate.doSave(monitor);
        }
    }

    public void doSaveAs() {
        if (this._delegate != null) {
            this._delegate.doSaveAs();
        }
    }

    public boolean isDirty() {
        if (this._delegate != null) {
            return this._delegate.isDirty();
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        if (this._delegate != null) {
            return this._delegate.isSaveAsAllowed();
        }
        return false;
    }

    public void setModel(IStructuredModel model) {
        if (this._model != null) {
            if (this._model.getUndoManager() != null) {
                this._model.getUndoManager().disconnect((IDocumentSelectionMediator)this);
            }
            this._model.removeModelStateListener(this._internalModelListener);
        }
        this._model = model;
        if (this._model != null) {
            this._model.addModelStateListener(this._internalModelListener);
            if (this._model.getUndoManager() != null) {
                this._model.getUndoManager().connect((IDocumentSelectionMediator)this);
                this.updateActionsWhenModelChange();
            }
        }
        if (model instanceof IDOMModel) {
            IDOMDocument doc = ((IDOMModel)model).getDocument();
            PropagatingAdapter adapter = (PropagatingAdapter)doc.getAdapterFor(PropagatingAdapter.class);
            if (adapter != null) {
                RefresherFactory factory = RefresherFactory.getInstance();
                adapter.addAdaptOnCreateFactory((INodeAdapterFactory)factory);
                adapter.initializeForFactory((INodeAdapterFactory)factory, (INodeNotifier)doc);
            }
            ((IDOMModel)model).getFactoryRegistry().addFactory((INodeAdapterFactory)CSSStyleAdapterFactory.getInstance());
            ((IDOMModel)model).getFactoryRegistry().addFactory((INodeAdapterFactory)new PageVariableAdapterFactory());
            doc.addAdapter((INodeAdapter)new DocumentPageVariableAdapter(doc));
            this._viewer.setContents(((IDOMModel)model).getDocument());
        } else {
            this._viewer.setContents(null);
        }
    }

    protected SelectionSynchronizer getSynchronizer() {
        return this._synchronizer;
    }

    protected void updateActions(List actionIds) {
        super.updateActions(actionIds);
    }

    public IAction getAction(Object id) {
        return this.getActionRegistry().getAction(id);
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return DesignerPaletteRootFactory.createPalettePreferences();
    }

    protected PaletteRoot getPaletteRoot() {
        if (this._palette == null) {
            if (this._paletteViewerPageFactory != null) {
                this._palette = this._paletteViewerPageFactory.createPaletteRoot(this._delegate.getEditorInput());
            }
            if (this._palette == null) {
                this._palette = DesignerPaletteRootFactory.createPaletteRoot(this.getCurrentFile(this._delegate.getEditorInput()));
            }
        }
        return this._palette;
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        if (this._paletteViewerProvider == null) {
            if (this._paletteViewerPageFactory != null) {
                this._paletteViewerProvider = this._paletteViewerPageFactory.createPaletteViewerProvider((EditDomain)this.getEditDomain());
            }
            if (this._paletteViewerProvider == null) {
                return new DesignerPaletteViewerProvider((EditDomain)this.getEditDomain()){

                    protected void configurePaletteViewer(PaletteViewer viewer) {
                        super.configurePaletteViewer(viewer);
                        viewer.setCustomizer((PaletteCustomizer)new DesignerPaletteCustomizer());
                        viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
                    }
                };
            }
        }
        return this._paletteViewerProvider;
    }

    protected PaletteViewerPage createPaletteViewerPage() {
        if (this._paletteViewerPageFactory != null) {
            this._paletteViewerPage = this._paletteViewerPageFactory.createPaletteViewerPage(this.createPaletteViewerProvider());
        }
        if (this._paletteViewerPage == null) {
            DefaultEditDomain editDomain = this.getEditDomain();
            PaletteRoot paletteRoot = this.getPaletteRoot();
            editDomain.setPaletteRoot(paletteRoot);
            if (this._paletteViewerPage == null) {
                PaletteViewerProvider provider = this.getPaletteViewerProvider2();
                this._paletteViewerPage = new PaletteViewerPage(provider);
            }
        }
        return this._paletteViewerPage;
    }

    PaletteViewerProvider getPaletteViewerProvider2() {
        return this.getPaletteViewerProvider();
    }

    public IHTMLGraphicalViewer getGraphicViewer() {
        return this._viewer;
    }

    public HTMLEditor getHTMLEditor() {
        return this._delegate;
    }

    private IFile getCurrentFile(IEditorInput input) {
        IFile inputFile = null;
        if (input instanceof IFileEditorInput) {
            inputFile = ((IFileEditorInput)input).getFile();
        }
        return inputFile;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this._viewer != null) {
            GraphicalViewer viewerViewer = this.getGraphicalViewer();
            if (viewerViewer != null && viewerViewer.getControl() != null && viewerViewer.getControl().isFocusControl()) {
                this.updateActions(this.getSelectionActions());
                if (selection instanceof IStructuredSelection && !(((IStructuredSelection)selection).getFirstElement() instanceof DocumentEditPart)) {
                    ((IHTMLGraphicalViewer)viewerViewer).updateRangeSelection(selection);
                }
            }
        } else {
            super.selectionChanged(part, selection);
        }
    }

    public IDocument getDocument() {
        if (this._model != null) {
            return this._model.getStructuredDocument();
        }
        return null;
    }

    public void undoOperationSelectionChanged(UndoDocumentEvent event) {
        IDocumentSelectionMediator requester = event.getRequester();
        if (this == requester) {
            final int offset = event.getOffset();
            final int length = event.getLength();
            this._model.addModelStateListener(new IModelStateListener(){

                public void modelAboutToBeChanged(IStructuredModel model) {
                }

                public void modelChanged(IStructuredModel model) {
                    SimpleGraphicalEditor.this._model.removeModelStateListener((IModelStateListener)this);
                    ISelection sel = SelectionHelper.convertToDesignerSelection(SimpleGraphicalEditor.this.getGraphicViewer(), offset, length);
                    if (sel != null) {
                        SimpleGraphicalEditor.this.getGraphicViewer().setSelection(sel);
                    }
                }

                public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
                }

                public void modelResourceDeleted(IStructuredModel model) {
                }

                public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
                }

                public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
                }

                public void modelReinitialized(IStructuredModel structuredModel) {
                }
            });
        }
    }

    public PaletteViewerPage getPaletteViewerPage() {
        if (this._paletteViewerPage == null) {
            this._paletteViewerPage = this.createPaletteViewerPage();
        }
        return this._paletteViewerPage;
    }

    protected IPaletteFactory initPaletteFactory() {
        if (this._paletteViewerPageFactory == null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PDPlugin.getPluginId(), "pageDesignerExtension");
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension ext = extensions[i];
                IConfigurationElement[] elementEditElement = ext.getConfigurationElements();
                int j = 0;
                while (j < elementEditElement.length) {
                    IConfigurationElement element = elementEditElement[j];
                    if (element.getName().equals("paletteFactory")) {
                        elementEditElement[j].getAttribute("class");
                        try {
                            Object obj = elementEditElement[j].createExecutableExtension("class");
                            if (obj instanceof IPaletteFactory) {
                                this._paletteViewerPageFactory = (IPaletteFactory)obj;
                            }
                        }
                        catch (CoreException e) {
                            PDPlugin.log("Problem loading element edit extension for " + element.toString(), e);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return this._paletteViewerPageFactory;
    }

    private final class ContextMenuListener
    implements IMenuListener {
        private ContextMenuListener() {
        }

        public void menuAboutToShow(IMenuManager menuMgr1) {
            IFile file;
            IProject project;
            this.addEditSubMenu(menuMgr1);
            this.addSelectSubMenu(menuMgr1);
            this.addInsertSubMenu(menuMgr1);
            this.addStyleSubMenu(menuMgr1);
            PageDesignerActionConstants.addStandardActionGroups(menuMgr1);
            ContainerActionGroup containerActionGroup = new ContainerActionGroup();
            ActionContext context = new ActionContext(SimpleGraphicalEditor.this._viewer.getSelection());
            context.setInput((Object)SimpleGraphicalEditor.this._viewer);
            containerActionGroup.setContext(context);
            containerActionGroup.fillContextMenu(menuMgr1);
            containerActionGroup.setContext(null);
            RangeActionGroup rangeActionGroup = new RangeActionGroup();
            context = new ActionContext(SimpleGraphicalEditor.this._viewer.getSelection());
            context.setInput((Object)SimpleGraphicalEditor.this._viewer);
            rangeActionGroup.setContext(context);
            rangeActionGroup.fillContextMenu(menuMgr1);
            rangeActionGroup.setContext(null);
            SingleElementActionGroup singleActionGroup = new SingleElementActionGroup();
            singleActionGroup.setContext(new ActionContext(SimpleGraphicalEditor.this._viewer.getSelection()));
            singleActionGroup.fillContextMenu(menuMgr1);
            singleActionGroup.setContext(null);
            RelatedViewActionGroup viewMenu = new RelatedViewActionGroup((EditDomain)SimpleGraphicalEditor.this.getEditDomain());
            context = new ActionContext(SimpleGraphicalEditor.this._viewer.getSelection());
            viewMenu.setContext(context);
            viewMenu.fillContextMenu(menuMgr1);
            CustomedContextMenuActionGroup customedMenu = new CustomedContextMenuActionGroup();
            customedMenu.setContext(new ActionContext(SimpleGraphicalEditor.this._viewer.getSelection()));
            customedMenu.setModel(SimpleGraphicalEditor.this._model);
            customedMenu.setParentControl(SimpleGraphicalEditor.this._viewer.getControl());
            customedMenu.fillContextMenu(menuMgr1);
            customedMenu.setContext(null);
            customedMenu.setParentControl(null);
            customedMenu.setModel(null);
            IEditorInput editorInput = SimpleGraphicalEditor.this._delegate.getEditorInput();
            if (editorInput instanceof IFileEditorInput && (project = (file = ((IFileEditorInput)editorInput).getFile()).getProject()) != null) {
                SkinsMenuItemBuilder builder = new SkinsMenuItemBuilder(project);
                builder.buildMenuManagers(menuMgr1);
            }
        }

        private void addEditSubMenu(IMenuManager menu) {
            MenuManager editSubmenu = new MenuManager(ActionsMessages.getString("Edit.Menu"), "org.eclipse.jst.pagedesigner.context.submenu.edit");
            menu.add((IContributionItem)editSubmenu);
            PageDesignerActionConstants.addStandardEditActionGroups((IMenuManager)editSubmenu);
            editSubmenu.appendToGroup("org.eclipse.gef.group.undo", SimpleGraphicalEditor.this.getAction("org.eclipse.ui.edit.undo"));
            editSubmenu.appendToGroup("org.eclipse.gef.group.undo", SimpleGraphicalEditor.this.getAction("org.eclipse.ui.edit.redo"));
            editSubmenu.appendToGroup("org.eclipse.gef.group.edit", SimpleGraphicalEditor.this.getAction("org.eclipse.ui.edit.cut"));
            editSubmenu.appendToGroup("org.eclipse.gef.group.edit", SimpleGraphicalEditor.this.getAction("org.eclipse.ui.edit.copy"));
            editSubmenu.appendToGroup("org.eclipse.gef.group.edit", SimpleGraphicalEditor.this.getAction("org.eclipse.ui.edit.paste"));
            editSubmenu.appendToGroup("org.eclipse.gef.group.edit", SimpleGraphicalEditor.this.getAction("org.eclipse.ui.edit.delete"));
        }

        private void addStyleSubMenu(IMenuManager menu) {
            MenuManager styleSubmenu = new MenuManager(ActionsMessages.getString("Style.Menu"), "org.eclipse.jst.pagedesigner.context.submenu.style");
            menu.add((IContributionItem)styleSubmenu);
            PageDesignerActionConstants.addStandardStyleActionGroups((IMenuManager)styleSubmenu);
        }

        private void addInsertSubMenu(IMenuManager menu) {
            MenuManager insertSubmenu = new MenuManager(ActionsMessages.getString("Insert.Menu"), "org.eclipse.jst.pagedesigner.context.submenu.insert");
            menu.add((IContributionItem)insertSubmenu);
            PageDesignerActionConstants.addStandardInsertActionGroups((IMenuManager)insertSubmenu);
        }

        private void addSelectSubMenu(IMenuManager menu) {
            MenuManager selectSubMenu = new MenuManager(ActionsMessages.getString("Select.Menu"), "org.eclipse.jst.pagedesigner.context.submenu.select");
            menu.add((IContributionItem)selectSubMenu);
            PageDesignerActionConstants.addStandardSelectActionGroups((IMenuManager)selectSubMenu);
        }
    }
}

