/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.core.util;

import com.liferay.ide.eclipse.core.CorePlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptorHelper {
    protected String descriptorPath;
    protected IProject project;

    public static Element appendChildElement(Element parentElement, String newElementName) {
        return DescriptorHelper.appendChildElement(parentElement, newElementName, null);
    }

    public static Element appendChildElement(Element parentElement, String newElementName, String initialTextContent) {
        Element newChildElement = null;
        if (parentElement != null && newElementName != null) {
            Document ownerDocument = parentElement.getOwnerDocument();
            newChildElement = ownerDocument.createElement(newElementName);
            if (initialTextContent != null) {
                newChildElement.appendChild(ownerDocument.createTextNode(initialTextContent));
            }
            parentElement.appendChild(newChildElement);
        }
        return newChildElement;
    }

    public static Element findChildElement(Element parentElement, String elementName) {
        Element retval = null;
        if (parentElement == null) {
            return retval;
        }
        NodeList children = parentElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element && child.getNodeName().equals(elementName)) {
                retval = (Element)child;
                break;
            }
            ++i;
        }
        return retval;
    }

    public static IFile getDescriptorFile(IProject project, String fileName) {
        IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
        if (comp == null) {
            return null;
        }
        IVirtualFolder webRoot = comp.getRootFolder();
        IFolder webInfFolder = (IFolder)webRoot.getFolder("WEB-INF").getUnderlyingFolder();
        return webInfFolder.getFile(fileName);
    }

    public static Element insertChildElement(Element parentElement, Node refNode, String newElementName, String initialTextContent) {
        Element newChildElement = null;
        if (parentElement != null && newElementName != null) {
            Document ownerDocument = parentElement.getOwnerDocument();
            newChildElement = ownerDocument.createElement(newElementName);
            if (initialTextContent != null) {
                newChildElement.appendChild(ownerDocument.createTextNode(initialTextContent));
            }
            parentElement.insertBefore(newChildElement, refNode);
        }
        return newChildElement;
    }

    public static void removeChildren(Node node) {
        if (node == null || node.getChildNodes() == null || node.getChildNodes().getLength() <= 0) {
            return;
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            node.removeChild(children.item(i));
            ++i;
        }
    }

    public DescriptorHelper(IProject project) {
        this.project = project;
    }

    public List<Element> getChildElements(Element parent) {
        ArrayList<Element> retval = new ArrayList<Element>();
        if (parent != null) {
            NodeList children = parent.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child instanceof Element) {
                    retval.add((Element)child);
                }
                ++i;
            }
        }
        return retval;
    }

    public String getDescriptorPath() {
        return this.descriptorPath;
    }

    public void setDescriptorPath(String path) {
        this.descriptorPath = path;
    }

    protected IFile getDescriptorFile(String fileName) {
        return DescriptorHelper.getDescriptorFile(this.project, fileName);
    }

    protected IProject getProject() {
        return this.project;
    }

    public abstract class DOMModelEditOperation
    extends DOMModelOperation {
        public DOMModelEditOperation(IFile descriptorFile) {
            super(descriptorFile);
        }

        public IStatus execute() {
            IStatus retval = null;
            if (!this.file.exists()) {
                return CorePlugin.createErrorStatus(String.valueOf(this.file.getName()) + " doesn't exist");
            }
            IDOMModel domModel = null;
            try {
                try {
                    domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForEdit(this.file);
                    domModel.aboutToChangeModel();
                    IDOMDocument document = domModel.getDocument();
                    retval = this.doExecute(document);
                    domModel.changedModel();
                    domModel.save();
                }
                catch (Exception e) {
                    retval = CorePlugin.createErrorStatus(e);
                    if (domModel != null) {
                        domModel.releaseFromEdit();
                    }
                }
            }
            finally {
                if (domModel != null) {
                    domModel.releaseFromEdit();
                }
            }
            return retval;
        }
    }

    protected static abstract class DOMModelOperation {
        protected IFile file;

        public DOMModelOperation(IFile descriptorFile) {
            this.file = descriptorFile;
        }

        public abstract IStatus execute();

        protected abstract IStatus doExecute(IDOMDocument var1);
    }

    protected abstract class DOMModelReadOperation
    extends DOMModelOperation {
        public DOMModelReadOperation(IFile descriptorFile) {
            super(descriptorFile);
        }

        public IStatus execute() {
            IStatus retval = null;
            if (!this.file.exists()) {
                return CorePlugin.createErrorStatus(String.valueOf(this.file.getName()) + " doesn't exist");
            }
            IDOMModel domModel = null;
            try {
                try {
                    domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForRead(this.file);
                    IDOMDocument document = domModel.getDocument();
                    retval = this.doExecute(document);
                }
                catch (Exception e) {
                    retval = CorePlugin.createErrorStatus(e);
                    if (domModel != null) {
                        domModel.releaseFromRead();
                    }
                }
            }
            finally {
                if (domModel != null) {
                    domModel.releaseFromRead();
                }
            }
            return retval;
        }
    }
}

