/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.core.util;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class NodeUtil {
    public static Node getFirstNamedChildNode(Element element, String string) {
        NodeList children = element.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                Node item = children.item(i);
                if (item.getNodeName().equals(string)) {
                    return item;
                }
                ++i;
            }
        }
        return null;
    }

    public static Text setTextContent(Node namespaceNode, String textContent) {
        Text retval = null;
        if (namespaceNode instanceof Text) {
            namespaceNode.setNodeValue(textContent);
            retval = (Text)namespaceNode;
        } else if (namespaceNode instanceof Element) {
            Element namespaceElement = (Element)namespaceNode;
            NodeUtil.removeChildren(namespaceElement);
            retval = namespaceElement.getOwnerDocument().createTextNode(textContent);
            namespaceElement.appendChild(retval);
        }
        return retval;
    }

    public static void removeChildren(Element element) {
        while (element != null && element.hasChildNodes()) {
            element.removeChild(element.getFirstChild());
        }
    }

    public static String getChildElementContent(Node parent, String childElement) {
        String retval = null;
        NodeList children = parent.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child instanceof Element && child.getNodeName().equals(childElement)) {
                    return NodeUtil.getTextContent((Element)child);
                }
                ++i;
            }
        }
        return retval;
    }

    public static String getTextContent(Node node) {
        NodeList children = node.getChildNodes();
        if (children.getLength() == 1) {
            return children.item(0).getNodeValue().trim();
        }
        StringBuffer s = new StringBuffer();
        Node child = node.getFirstChild();
        while (child != null) {
            s.append(child.getNodeValue().trim());
            child = child.getNextSibling();
        }
        return s.toString().trim();
    }

    public static Node findFirstChild(Element element, String elementName) {
        NodeList children;
        if (element != null && !CoreUtil.isNullOrEmpty(elementName) && (children = element.getChildNodes()) != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (elementName.equals(child.getNodeName())) {
                    return child;
                }
                ++i;
            }
        }
        return null;
    }
}

