/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.portlet.jsf.core;

import com.liferay.ide.eclipse.portlet.jsf.core.JSFCorePlugin;
import com.liferay.ide.eclipse.project.core.AbstractPortletFramework;
import com.liferay.ide.eclipse.project.core.facet.IPluginFacetConstants;
import com.liferay.ide.eclipse.project.core.util.ProjectUtil;
import com.liferay.ide.eclipse.sdk.SDK;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.jsf.core.internal.project.facet.IJSFFacetInstallDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class JSFPortletFramework
extends AbstractPortletFramework
implements IJSFFacetInstallDataModelProperties {
    public static final String JSF_FACET_SUPPORTED_VERSION = "2.0";

    public IStatus configureNewProject(IDataModel dataModel, IFacetedProjectWorkingCopy facetedProject) {
        IProjectFacetVersion jsfFacetVersion = this.getJSFProjectFacet(facetedProject);
        IProjectFacet jsfFacet = JSFCorePlugin.JSF_FACET;
        if (jsfFacetVersion == null) {
            jsfFacetVersion = jsfFacet.getVersion(JSF_FACET_SUPPORTED_VERSION);
            facetedProject.addProjectFacet(jsfFacetVersion);
        }
        IFacetedProject.Action action = facetedProject.getProjectFacetAction(jsfFacet);
        IDataModel jsfFacetDataModel = (IDataModel)action.getConfig();
        jsfFacetDataModel.setProperty("IJSFFacetInstallDataModelProperties.SERVLET_URL_PATTERNS", null);
        jsfFacetDataModel.setProperty("IJSFFacetInstallDataModelProperties.WEBCONTENT_DIR", (Object)"docroot");
        LibraryInstallDelegate libraryInstallDelegate = (LibraryInstallDelegate)jsfFacetDataModel.getProperty("IJSFFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE");
        List providers = libraryInstallDelegate.getLibraryProviders();
        ILibraryProvider noOpProvider = null;
        for (ILibraryProvider provider : providers) {
            if (!provider.getId().equals("jsf-no-op-library-provider")) continue;
            noOpProvider = provider;
            break;
        }
        if (noOpProvider != null) {
            libraryInstallDelegate.setLibraryProvider(noOpProvider);
        }
        return Status.OK_STATUS;
    }

    public IProjectFacet[] getFacets() {
        return new IProjectFacet[]{JSFCorePlugin.JSF_FACET};
    }

    public IStatus postProjectCreated(IDataModel dataModel, IFacetedProject facetedProject) {
        SDK sdk = ProjectUtil.getSDK((IProject)facetedProject.getProject(), (IProjectFacet)IPluginFacetConstants.LIFERAY_PORTLET_PROJECT_FACET);
        if (sdk == null) {
            return JSFCorePlugin.createErrorStatus("Could not get SDK from newly created project.");
        }
        try {
            File originalWebXmlFile = sdk.getLocation().append("tools/portlet_jsf_tmpl/docroot/WEB-INF/web.xml").toFile();
            IFolder docroot = ProjectUtil.getDocroot((IProject)facetedProject.getProject());
            docroot.getFile("WEB-INF/web.xml").setContents((InputStream)new FileInputStream(originalWebXmlFile), 1, null);
        }
        catch (Exception e) {
            return JSFCorePlugin.createErrorStatus("Could not copy original web.xml from JSF template in SDK.", e);
        }
        return Status.OK_STATUS;
    }

    protected IProjectFacetVersion getJSFProjectFacet(IFacetedProjectWorkingCopy project) {
        Set facets = project.getProjectFacets();
        for (IProjectFacetVersion facet : facets) {
            if (!facet.getProjectFacet().getId().equals("jst.jsf")) continue;
            return facet;
        }
        return null;
    }
}

