/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.server.core;

import com.liferay.ide.eclipse.server.core.ILiferayRuntime;
import com.liferay.ide.eclipse.server.core.LiferayServerCorePlugin;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.model.RuntimeDelegate;

public class LiferayRuntimeStubDelegate
extends RuntimeDelegate
implements ILiferayRuntime {
    protected static final String PROP_STUB_TYPE_ID = "stub-type-id";
    protected IRuntimeWorkingCopy tempRuntime = null;

    public IVMInstall getVMInstall() {
        return JavaRuntime.getDefaultVMInstall();
    }

    public String getRuntimeStubTypeId() {
        return this.getAttribute(PROP_STUB_TYPE_ID, "");
    }

    public void setRuntimeStubTypeId(String typeId) {
        this.setAttribute(PROP_STUB_TYPE_ID, typeId);
        this.tempRuntime = null;
    }

    public String getName() {
        return this.getRuntime().getName();
    }

    public ILiferayRuntime getLiferayRuntime() {
        return (ILiferayRuntime)this.getTempRuntime().loadAdapter(ILiferayRuntime.class, (IProgressMonitor)new NullProgressMonitor());
    }

    protected IRuntimeWorkingCopy getTempRuntime() {
        if (this.tempRuntime == null && this.getRuntime().getLocation() != null) {
            IRuntimeType runtimeType = ServerCore.findRuntimeType((String)this.getRuntimeStubTypeId());
            try {
                this.tempRuntime = runtimeType.createRuntime(String.valueOf(this.getRuntimeStubTypeId()) + "-stub", (IProgressMonitor)new NullProgressMonitor());
                this.tempRuntime.setLocation(this.getRuntime().getLocation());
            }
            catch (CoreException e) {
                LiferayServerCorePlugin.logError("Error creating runtime", (Exception)((Object)e));
            }
        }
        if (this.tempRuntime.getLocation() == null || !this.tempRuntime.getLocation().equals((Object)this.getRuntime().getLocation())) {
            this.tempRuntime.setLocation(this.getRuntime().getLocation());
        }
        return this.tempRuntime;
    }

    public boolean isUsingDefaultJRE() {
        return true;
    }

    public IPath[] getAllUserClasspathLibraries() {
        return this.getLiferayRuntime().getAllUserClasspathLibraries();
    }

    public Properties getPortletCategories() {
        return this.getLiferayRuntime().getPortletCategories();
    }

    public String getPortalVersion() {
        return this.getLiferayRuntime().getPortalVersion();
    }

    public IPath getRuntimeLocation() {
        return this.getRuntime().getLocation();
    }

    public String[] getSupportedHookProperties() {
        return this.getLiferayRuntime().getSupportedHookProperties();
    }

    public IPath getAppServerDir() {
        return this.getLiferayRuntime().getAppServerDir();
    }

    public String getAppServerType() {
        return this.getLiferayRuntime().getAppServerType();
    }

    public IPath getDeployDir() {
        return this.getLiferayRuntime().getDeployDir();
    }

    public IPath getLibGlobalDir() {
        return this.getLiferayRuntime().getLibGlobalDir();
    }

    public IPath getPortalDir() {
        return this.getLiferayRuntime().getPortalDir();
    }

    public IStatus validate() {
        IStatus status = super.validate();
        if (!status.isOK()) {
            return status;
        }
        return ((RuntimeDelegate)this.getTempRuntime().loadAdapter(RuntimeDelegate.class, (IProgressMonitor)new NullProgressMonitor())).validate();
    }
}

