/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.server.core;

import com.liferay.ide.eclipse.core.CorePlugin;
import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.server.core.AbstractPluginPublisher;
import com.liferay.ide.eclipse.server.core.AbstractRuntimeDelegateValidator;
import com.liferay.ide.eclipse.server.core.ILiferayRuntimeStub;
import com.liferay.ide.eclipse.server.core.IPluginPublisher;
import com.liferay.ide.eclipse.server.core.IRuntimeDelegateValidator;
import com.liferay.ide.eclipse.server.core.LiferayRuntimeStub;
import com.liferay.ide.eclipse.server.remote.IRemoteConnection;
import com.liferay.ide.eclipse.server.remote.IRemoteServer;
import com.liferay.ide.eclipse.server.remote.RemoteConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.model.RuntimeDelegate;
import org.osgi.framework.BundleContext;

public class LiferayServerCorePlugin
extends CorePlugin {
    public static final String PLUGIN_ID = "com.liferay.ide.eclipse.server.core";
    private static Map<String, IRemoteConnection> connections = null;
    private static LiferayServerCorePlugin plugin;
    private static IPluginPublisher[] pluginPublishers;
    private static IRuntimeDelegateValidator[] runtimeDelegateValidators;
    private static ILiferayRuntimeStub[] runtimeStubs;

    static {
        pluginPublishers = null;
    }

    public static IStatus createErrorStatus(String msg) {
        return LiferayServerCorePlugin.createErrorStatus((String)PLUGIN_ID, (String)msg);
    }

    public static IStatus createInfoStatus(String msg) {
        return new Status(1, PLUGIN_ID, msg);
    }

    public static LiferayServerCorePlugin getDefault() {
        return plugin;
    }

    public static IPluginPublisher getPluginPublisher(String facetId, String runtimeTypeId) {
        if (CoreUtil.isNullOrEmpty((String)facetId) || CoreUtil.isNullOrEmpty((String)runtimeTypeId)) {
            return null;
        }
        IPluginPublisher retval = null;
        IPluginPublisher[] publishers = LiferayServerCorePlugin.getPluginPublishers();
        if (publishers != null && publishers.length > 0) {
            IPluginPublisher[] iPluginPublisherArray = publishers;
            int n = publishers.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginPublisher publisher = iPluginPublisherArray[n2];
                if (publisher != null && facetId.equals(publisher.getFacetId()) && runtimeTypeId.equals(publisher.getRuntimeTypeId())) {
                    retval = publisher;
                    break;
                }
                ++n2;
            }
        }
        return retval;
    }

    public static IPluginPublisher[] getPluginPublishers() {
        if (pluginPublishers == null) {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.liferay.ide.eclipse.server.core.pluginPublishers");
            try {
                ArrayList<AbstractPluginPublisher> deployers = new ArrayList<AbstractPluginPublisher>();
                IConfigurationElement[] iConfigurationElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    Object o = element.createExecutableExtension("class");
                    if (o instanceof AbstractPluginPublisher) {
                        AbstractPluginPublisher pluginDeployer = (AbstractPluginPublisher)o;
                        pluginDeployer.setFacetId(element.getAttribute("facetId"));
                        pluginDeployer.setRuntimeTypeId(element.getAttribute("runtimeTypeId"));
                        deployers.add(pluginDeployer);
                    }
                    ++n2;
                }
                pluginPublishers = deployers.toArray(new IPluginPublisher[0]);
            }
            catch (Exception e) {
                LiferayServerCorePlugin.logError("Unable to get plugin deployer extensions", e);
            }
        }
        return pluginPublishers;
    }

    public static IRemoteConnection getRemoteConnection(final IRemoteServer server) {
        IRemoteConnection service;
        if (connections == null) {
            connections = new HashMap<String, IRemoteConnection>();
            ServerCore.addServerLifecycleListener((IServerLifecycleListener)new IServerLifecycleListener(){

                public void serverAdded(IServer server2) {
                }

                public void serverChanged(IServer server2) {
                }

                public void serverRemoved(IServer s) {
                    IRemoteConnection service;
                    if (server.equals(s) && (service = (IRemoteConnection)connections.get(server.getId())) != null) {
                        service = null;
                        connections.put(server.getId(), null);
                    }
                }
            });
        }
        if ((service = connections.get(server.getId())) == null) {
            service = new RemoteConnection();
            LiferayServerCorePlugin.updateConnectionSettings(server, service);
            connections.put(server.getId(), service);
        }
        return service;
    }

    public static IRuntimeDelegateValidator[] getRuntimeDelegateValidators() {
        if (runtimeDelegateValidators == null) {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.liferay.ide.eclipse.server.core.runtimeDelegateValidators");
            try {
                ArrayList<AbstractRuntimeDelegateValidator> validators = new ArrayList<AbstractRuntimeDelegateValidator>();
                IConfigurationElement[] iConfigurationElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    Object o = element.createExecutableExtension("class");
                    String runtimeTypeId = element.getAttribute("runtimeTypeId");
                    if (o instanceof AbstractRuntimeDelegateValidator) {
                        AbstractRuntimeDelegateValidator validator = (AbstractRuntimeDelegateValidator)o;
                        validator.setRuntimeTypeId(runtimeTypeId);
                        validators.add(validator);
                    }
                    ++n2;
                }
                runtimeDelegateValidators = validators.toArray(new IRuntimeDelegateValidator[0]);
            }
            catch (Exception e) {
                LiferayServerCorePlugin.logError("Unable to get IRuntimeDelegateValidator extensions", e);
            }
        }
        return runtimeDelegateValidators;
    }

    public static ILiferayRuntimeStub getRuntimeStub(String stubTypeId) {
        Object retval = null;
        Object[] stubs = LiferayServerCorePlugin.getRuntimeStubs();
        if (!CoreUtil.isNullOrEmpty((Object[])stubs)) {
            Object[] objectArray = stubs;
            int n = stubs.length;
            int n2 = 0;
            while (n2 < n) {
                Object stub = objectArray[n2];
                if (stub.getRuntimeStubTypeId().equals(stubTypeId)) {
                    retval = stub;
                    break;
                }
                ++n2;
            }
        }
        return retval;
    }

    public static ILiferayRuntimeStub[] getRuntimeStubs() {
        Object[] elements;
        if (runtimeStubs == null && !CoreUtil.isNullOrEmpty((Object[])(elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.liferay.ide.eclipse.server.core.runtimeStubs")))) {
            ArrayList<LiferayRuntimeStub> stubs = new ArrayList<LiferayRuntimeStub>();
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                String runtimeTypeId = element.getAttribute("runtimeTypeId");
                String name = element.getAttribute("name");
                boolean isDefault = Boolean.parseBoolean(element.getAttribute("default"));
                try {
                    LiferayRuntimeStub stub = new LiferayRuntimeStub();
                    stub.setRuntimeTypeId(runtimeTypeId);
                    stub.setName(name);
                    stub.setDefault(isDefault);
                    stubs.add(stub);
                }
                catch (Exception e) {
                    LiferayServerCorePlugin.logError("Could not create liferay runtime stub.", e);
                }
                ++n2;
            }
            runtimeStubs = stubs.toArray(new ILiferayRuntimeStub[0]);
        }
        return runtimeStubs;
    }

    public static IPath getTempLocation(String prefix, String fileName) {
        return LiferayServerCorePlugin.getDefault().getStateLocation().append("tmp").append(String.valueOf(prefix) + "/" + System.currentTimeMillis() + (CoreUtil.isNullOrEmpty((String)fileName) ? "" : "/" + fileName));
    }

    public static void logError(Exception e) {
        LiferayServerCorePlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e));
    }

    public static void logError(String msg, Exception e) {
        LiferayServerCorePlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, msg, (Throwable)e));
    }

    public static void updateConnectionSettings(IRemoteServer server) {
        LiferayServerCorePlugin.updateConnectionSettings(server, LiferayServerCorePlugin.getRemoteConnection(server));
    }

    public static void updateConnectionSettings(IRemoteServer server, IRemoteConnection remoteConnection) {
        remoteConnection.setHost(server.getHost());
        remoteConnection.setHttpPort(server.getHTTPPort());
        remoteConnection.setManagerContextPath(server.getServerManagerContextPath());
        remoteConnection.setUsername(server.getUsername());
        remoteConnection.setPassword(server.getPassword());
    }

    public static IStatus validateRuntimeDelegate(RuntimeDelegate runtimeDelegate) {
        if (runtimeDelegate.getRuntime().isStub()) {
            return Status.OK_STATUS;
        }
        String runtimeTypeId = runtimeDelegate.getRuntime().getRuntimeType().getId();
        Object[] validators = LiferayServerCorePlugin.getRuntimeDelegateValidators();
        if (!CoreUtil.isNullOrEmpty((Object[])validators)) {
            Object[] objectArray = validators;
            int n = validators.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus status;
                Object validator = objectArray[n2];
                if (runtimeTypeId.equals(validator.getRuntimeTypeId()) && !(status = validator.validateRuntimeDelegate(runtimeDelegate)).isOK()) {
                    return status;
                }
                ++n2;
            }
        }
        return Status.OK_STATUS;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static /* bridge */ /* synthetic */ CorePlugin getDefault() {
        return LiferayServerCorePlugin.getDefault();
    }
}

