/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.server.remote;

import com.liferay.ide.eclipse.server.remote.IRemoteConnection;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.eclipse.core.runtime.IProgressMonitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteConnection
implements IRemoteConnection {
    private GetMethod debugPortMethod;
    private String host;
    private HttpClient httpClient;
    private String httpPort;
    private GetMethod isAliveMethod;
    private String managerContextPath;
    private String password;
    private String username;

    public RemoteConnection() {
        this(null, null, null, null, null);
    }

    public RemoteConnection(String host, String httpPort, String username, String pw, String managerContextPath) {
        this.host = host;
        this.httpPort = httpPort;
        this.managerContextPath = managerContextPath;
        this.username = username;
        this.password = pw;
    }

    @Override
    public int getDebugPort() {
        if (this.isAlive()) {
            try {
                GetMethod method = this.getDebugPortMethod();
                int statusCode = this.getHttpClient().executeMethod((HttpMethod)method);
                if (statusCode != 200) {
                    System.err.println("Method failed: " + method.getStatusLine());
                } else {
                    byte[] body = method.getResponseBody();
                    String response = new String(body);
                    JSONObject jsonObject = new JSONObject(response);
                    if (this.isSuccess(jsonObject)) {
                        String debugPortOutput = jsonObject.getString("output-stream");
                        return Integer.parseInt(new String(debugPortOutput));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    @Override
    public List<String> getLiferayPlugins() {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            GetMethod method = new GetMethod(this.getPluginsURI());
            int statusCode = this.getHttpClient().executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                System.err.println("Method failed: " + method.getStatusLine());
            } else {
                byte[] body = method.getResponseBody();
                JSONObject json = new JSONObject(new String(body));
                if (this.isSuccess(json)) {
                    String output = this.getJSONOutput(json);
                    JSONArray jsonPlugins = new JSONArray(output);
                    int i = 0;
                    while (i < jsonPlugins.length()) {
                        retval.add(jsonPlugins.get(i).toString());
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retval;
    }

    @Override
    public String getManagerURI() {
        return "http://" + this.host + ":" + this.httpPort + this.managerContextPath;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getServerState() {
        if (this.isAlive()) {
            return "STARTED";
        }
        return "STOPPED";
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public Object installApplication(String absolutePath, String appName, IProgressMonitor submon) {
        try {
            String responseString;
            JSONObject json;
            File f = new File(absolutePath);
            PostMethod filePost = new PostMethod(this.getDeployURI(appName));
            Part[] parts = new Part[]{new FilePart("deployWar", f)};
            filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
            int status = this.getHttpClient().executeMethod((HttpMethod)filePost);
            if (status != 200) {
                System.err.println("Method failed: " + filePost.getStatusLine());
            }
            if (this.isSuccess(json = new JSONObject(responseString = filePost.getResponseBodyAsString()))) {
                System.out.println("installApplication: Sucess.\n\n");
            }
            filePost.releaseConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
        return null;
    }

    @Override
    public boolean isAlive() {
        try {
            GetMethod method = this.getIsAliveMethod();
            int statusCode = this.getHttpClient().executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                System.err.println("Method failed: " + method.getStatusLine());
            } else {
                byte[] body = method.getResponseBody();
                if (this.isSuccess(new JSONObject(new String(body)))) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean isAppInstalled(String appName) {
        try {
            GetMethod method = new GetMethod(this.getPluginURI(appName));
            int statusCode = this.getHttpClient().executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                System.err.println("Method failed: " + method.getStatusLine());
            } else {
                String output;
                JSONObject jsonOutput;
                Boolean installed;
                byte[] body = method.getResponseBody();
                JSONObject json = new JSONObject(new String(body));
                if (this.isSuccess(json) && (installed = Boolean.valueOf(Boolean.parseBoolean((jsonOutput = new JSONObject(output = this.getJSONOutput(json))).getString("installed")))).booleanValue()) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean isLiferayPluginStarted(String appName) {
        try {
            GetMethod method = new GetMethod(this.getPluginURI(appName));
            int statusCode = this.getHttpClient().executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                System.err.println("Method failed: " + method.getStatusLine());
            } else {
                String output;
                JSONObject jsonOutput;
                Boolean installed;
                byte[] body = method.getResponseBody();
                JSONObject json = new JSONObject(new String(body));
                if (this.isSuccess(json) && (installed = Boolean.valueOf(Boolean.parseBoolean((jsonOutput = new JSONObject(output = this.getJSONOutput(json))).getString("started")))).booleanValue()) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
        this.isAliveMethod = null;
        this.debugPortMethod = null;
    }

    @Override
    public void setHttpPort(String httpPort) {
        this.httpPort = httpPort;
        this.isAliveMethod = null;
        this.debugPortMethod = null;
    }

    @Override
    public void setManagerContextPath(String managerContextPath) {
        this.managerContextPath = managerContextPath;
        this.isAliveMethod = null;
        this.debugPortMethod = null;
    }

    @Override
    public void setPassword(String pw) {
        this.httpClient = null;
        this.password = pw;
    }

    @Override
    public void setUsername(String user) {
        this.httpClient = null;
        this.username = user;
    }

    @Override
    public Object uninstallApplication(String appName, IProgressMonitor monitor) {
        try {
            String responseString;
            DeleteMethod undeployMethod = new DeleteMethod(this.getUndeployURI(appName));
            int status = this.getHttpClient().executeMethod((HttpMethod)undeployMethod);
            if (status != 200) {
                System.err.println("Method failed: " + undeployMethod.getStatusLine());
            }
            if (this.isSuccess(new JSONObject(responseString = undeployMethod.getResponseBodyAsString()))) {
                System.out.println("uninstallApplication: success.");
            }
            undeployMethod.releaseConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
        return null;
    }

    @Override
    public Object updateApplication(String appName, String absolutePath, IProgressMonitor monitor) {
        try {
            String responseString;
            File f = new File(absolutePath);
            PutMethod filePut = new PutMethod(this.getUpdateURI(appName));
            Part[] parts = new Part[]{new FilePart(f.getName(), f)};
            filePut.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePut.getParams()));
            int status = this.getHttpClient().executeMethod((HttpMethod)filePut);
            if (status != 200) {
                System.err.println("Method failed: " + filePut.getStatusLine());
            }
            if (this.isSuccess(new JSONObject(responseString = filePut.getResponseBodyAsString()))) {
                System.out.println("updateApplication: success.");
            }
            filePut.releaseConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
        return null;
    }

    private GetMethod getDebugPortMethod() {
        if (this.debugPortMethod == null) {
            this.debugPortMethod = new GetMethod(this.getDebugPortURI());
        }
        return this.debugPortMethod;
    }

    private String getDebugPortURI() {
        return String.valueOf(this.getManagerURI()) + "/debug-port";
    }

    private String getDeployURI(String appName) {
        return String.valueOf(this.getPluginsURI()) + "/" + appName;
    }

    private HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = new HttpClient();
            this.httpClient.getParams().setAuthenticationPreemptive(true);
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(this.username, this.password);
            this.httpClient.getState().setCredentials(new AuthScope(this.host, Integer.parseInt(this.httpPort)), (Credentials)creds);
        }
        return this.httpClient;
    }

    private GetMethod getIsAliveMethod() {
        if (this.isAliveMethod == null) {
            this.isAliveMethod = new GetMethod(this.getIsAliveURI());
        }
        return this.isAliveMethod;
    }

    private String getIsAliveURI() {
        return String.valueOf(this.getManagerURI()) + "/is-alive";
    }

    private String getJSONOutput(JSONObject json) throws JSONException {
        return json.getString("output-stream");
    }

    private String getPluginsURI() {
        return String.valueOf(this.getManagerURI()) + "/plugins";
    }

    private String getPluginURI(String appName) {
        return String.valueOf(this.getPluginsURI()) + "/" + appName;
    }

    private String getUndeployURI(String appName) {
        return this.getDeployURI(appName);
    }

    private String getUpdateURI(String appName) {
        return this.getDeployURI(appName);
    }

    private boolean isSuccess(JSONObject jsonObject) throws JSONException {
        String success = jsonObject.getString("success");
        return "0".equals(success);
    }
}

