/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.server.remote;

import com.liferay.ide.eclipse.server.core.LiferayServerCorePlugin;
import com.liferay.ide.eclipse.server.remote.IRemoteConnection;
import com.liferay.ide.eclipse.server.remote.IRemoteServer;
import com.liferay.ide.eclipse.server.remote.RemoteMonitorProcess;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMConnector;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class RemoteLaunchConfigDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public static final String SERVER_ID = "server-id";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String serverId = configuration.getAttribute(SERVER_ID, "");
        IServer server = ServerCore.findServer((String)serverId);
        if (server == null) {
            launch.terminate();
            return;
        }
        int state = server.getServerState();
        if (state != 2) {
            throw new CoreException(LiferayServerCorePlugin.createErrorStatus("Server is not running. The WebSphere server adapter only supports connecting to already running instance of WebSphere."));
        }
        if ("run".equals(mode)) {
            this.runLaunch(server, configuration, launch, monitor);
        } else if ("debug".equals(mode)) {
            this.debugLaunch(server, configuration, launch, monitor);
        } else {
            throw new CoreException(LiferayServerCorePlugin.createErrorStatus("Profile mode is not supported."));
        }
    }

    protected void debugLaunch(IServer server, ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.runLaunch(server, configuration, launch, monitor);
        String connectorId = this.getVMConnectorId(configuration);
        IVMConnector connector = null;
        connector = connectorId == null ? JavaRuntime.getDefaultVMConnector() : JavaRuntime.getVMConnector((String)connectorId);
        if (connector == null) {
            this.abort("Debugging connector not specified.", null, 119);
        }
        Map connectMap = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, null);
        int connectTimeout = JavaRuntime.getPreferences().getInt(JavaRuntime.PREF_CONNECT_TIMEOUT);
        connectMap.put("timeout", "" + connectTimeout);
        if (monitor.isCanceled()) {
            return;
        }
        this.setDefaultSourceLocator(launch, configuration);
        if (!launch.isTerminated()) {
            connector.connect(connectMap, monitor, launch);
        }
        if (monitor.isCanceled() || launch.isTerminated()) {
            IDebugTarget[] debugTargets = launch.getDebugTargets();
            int i = 0;
            while (i < debugTargets.length) {
                IDebugTarget target = debugTargets[i];
                if (target.canDisconnect()) {
                    target.disconnect();
                }
                ++i;
            }
            return;
        }
        monitor.done();
    }

    protected void runLaunch(IServer server, ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IRemoteConnection connection = LiferayServerCorePlugin.getRemoteConnection((IRemoteServer)server.loadAdapter(IRemoteServer.class, monitor));
        RemoteMonitorProcess process = new RemoteMonitorProcess(server, connection, launch);
        launch.addProcess((IProcess)process);
    }
}

