/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.server.remote;

import com.liferay.ide.eclipse.server.remote.IRemoteConnection;
import com.liferay.ide.eclipse.server.remote.IRemoteServer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.wst.server.core.IServer;

public class RemoteLogStream
extends BufferedInputStream {
    public static final IEclipsePreferences _defaultPrefs = new DefaultScope().getNode("com.liferay.ide.eclipse.server.core");
    public static final long LOG_QUERY_RANGE = _defaultPrefs.getLong("log.query.range", 51200L);
    public static final long OUTPUT_MONITOR_DELAY = _defaultPrefs.getLong("output.monitor.delay", 1000L);
    protected URL baseUrl = null;
    protected IRemoteConnection connection;
    protected String log;
    protected long range = 0L;

    protected static URL createBaseUrl(IServer server, IRemoteServer remoteServer, IRemoteConnection connection, String log) {
        try {
            return new URL(String.valueOf(RemoteLogStream.getLogURI(connection, log)) + RemoteLogStream.getFormatQuery());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    protected static InputStream createInputStream(IServer server, IRemoteServer remoteServer, IRemoteConnection connection, String log) {
        try {
            URL url = RemoteLogStream.createBaseUrl(server, remoteServer, connection, log);
            return RemoteLogStream.openInputStream(connection, url);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static String getFormatQuery() {
        return "?format=raw";
    }

    protected static String getLogURI(IRemoteConnection connection, String log) {
        return String.valueOf(connection.getManagerURI()) + "/log/" + log;
    }

    protected static InputStream openInputStream(IRemoteConnection remote, URL url) throws IOException {
        String username = remote.getUsername();
        String password = remote.getPassword();
        String authString = String.valueOf(username) + ":" + password;
        byte[] authEncBytes = Base64.encodeBase64((byte[])authString.getBytes());
        String authStringEnc = new String(authEncBytes);
        URLConnection conn = url.openConnection();
        conn.setRequestProperty("Authorization", "Basic " + authStringEnc);
        return conn.getInputStream();
    }

    public RemoteLogStream(IServer server, IRemoteServer remoteServer, IRemoteConnection connection, String log) {
        super(RemoteLogStream.createInputStream(server, remoteServer, connection, log), 8192);
        this.baseUrl = RemoteLogStream.createBaseUrl(server, remoteServer, connection, log);
        this.log = log;
        this.connection = connection;
    }

    public int read(byte[] b) throws IOException {
        int read = super.read(b);
        if (read < 1) {
            this.waitOnNewInput();
            read = super.read(b);
            this.range += (long)read;
        }
        return read;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        if (read < 1) {
            this.waitOnNewInput();
            read = super.read(b, off, len);
            this.range += (long)read;
        }
        return read;
    }

    protected void waitOnNewInput() throws IOException {
        this.in.close();
        boolean goodUrl = false;
        while (!goodUrl) {
            URL newUrl = new URL(String.valueOf(RemoteLogStream.getLogURI(this.connection, this.log)) + "/" + this.range + RemoteLogStream.getFormatQuery());
            try {
                goodUrl = this.urlPeek(newUrl);
            }
            catch (Exception exception) {}
            if (goodUrl) {
                this.in = RemoteLogStream.openInputStream(this.connection, newUrl);
                return;
            }
            try {
                Thread.sleep(OUTPUT_MONITOR_DELAY);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    boolean urlPeek(URL url) throws IOException {
        String peek;
        byte[] buf = new byte[256];
        int bufRead = new BufferedInputStream(RemoteLogStream.openInputStream(this.connection, url), 256).read(buf);
        return bufRead != -1 && (peek = new String(buf)) != null && !peek.contains("Error 416: Invalid Range values.");
    }
}

