/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.server.remote;

import com.liferay.ide.eclipse.server.remote.IRemoteConnection;
import com.liferay.ide.eclipse.server.remote.IRemoteServer;
import com.liferay.ide.eclipse.server.remote.RemoteLogStream;
import com.liferay.ide.eclipse.server.remote.RemoteUtil;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.internal.core.StreamsProxy;
import org.eclipse.wst.server.core.IServer;

public class RemoteMonitorProcess
extends Process
implements IProcess {
    protected IRemoteConnection remoteConnection;
    protected String label;
    protected ILaunch launch;
    protected IServer server;
    protected IStreamsProxy streamsProxy;
    protected IRemoteServer remoteServer;

    public RemoteMonitorProcess(IServer server, IRemoteConnection connection, ILaunch launch) {
        this.server = server;
        this.remoteServer = (IRemoteServer)server.loadAdapter(IRemoteServer.class, null);
        this.remoteConnection = connection;
        this.launch = launch;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public void destroy() {
        System.out.println("destroy");
    }

    public int exitValue() {
        return 0;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public String getAttribute(String key) {
        return null;
    }

    public InputStream getErrorStream() {
        return new RemoteLogStream(this.server, this.remoteServer, this.remoteConnection, "syserr");
    }

    public int getExitValue() throws DebugException {
        return 0;
    }

    public InputStream getInputStream() {
        return new RemoteLogStream(this.server, this.remoteServer, this.remoteConnection, "sysout");
    }

    public String getLabel() {
        if (this.label == null) {
            IRemoteServer wasServer;
            String host = null;
            String port = null;
            if (this.server != null) {
                host = this.server.getHost();
            }
            if ((wasServer = RemoteUtil.getRemoteServer(this.server)) != null) {
                port = wasServer.getHTTPPort();
            }
            this.label = String.valueOf(host != null ? host : "") + ":" + (port != null ? port : "");
        }
        return this.label;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public OutputStream getOutputStream() {
        return null;
    }

    public IStreamsProxy getStreamsProxy() {
        if (this.streamsProxy == null) {
            this.streamsProxy = new StreamsProxy((Process)this, "UTF-8");
        }
        return this.streamsProxy;
    }

    public boolean isTerminated() {
        return this.remoteConnection == null;
    }

    public void setAttribute(String key, String value) {
    }

    public void terminate() throws DebugException {
        this.remoteConnection = null;
        DebugEvent[] events = new DebugEvent[]{new DebugEvent((Object)this, 8)};
        DebugPlugin.getDefault().fireDebugEventSet(events);
    }

    public int waitFor() throws InterruptedException {
        return 0;
    }
}

