/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.server.remote;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.sdk.SDK;
import com.liferay.ide.eclipse.sdk.util.SDKUtil;
import com.liferay.ide.eclipse.server.core.ILiferayServerBehavior;
import com.liferay.ide.eclipse.server.core.LiferayServerCorePlugin;
import com.liferay.ide.eclipse.server.remote.IRemoteConnection;
import com.liferay.ide.eclipse.server.remote.IRemoteServer;
import com.liferay.ide.eclipse.server.remote.RemoteUtil;
import com.liferay.ide.eclipse.server.util.LiferayPublishHelper;
import com.liferay.ide.eclipse.server.util.ServerUtil;
import com.liferay.ide.eclipse.server.util.SocketUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;

public class RemoteServerBehavior
extends ServerBehaviourDelegate
implements ILiferayServerBehavior,
IServerLifecycleListener {
    protected ILaunch currentLaunch;
    protected IRemoteConnection remoteConnection;
    protected Job remoteServerUpdateJob;

    public boolean canConnect() {
        return SocketUtil.canConnect(this.getServer().getHost(), this.getRemoteServer().getHTTPPort()).isOK();
    }

    public IStatus canPublish() {
        if (this.currentLaunch != null) {
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus canRestart(String mode) {
        return LiferayServerCorePlugin.createWarningStatus((String)"Restarting remote server is not supported.");
    }

    public boolean canRestartModule(IModule[] module) {
        IStatus status = this.getServer().canModifyModules(module, null, null);
        return status.isOK();
    }

    public IStatus canStart(String launchMode) {
        return LiferayServerCorePlugin.createErrorStatus("The Liferay server instance is remote and can not be started locally.");
    }

    public IStatus canStop() {
        return LiferayServerCorePlugin.createWarningStatus((String)"Stopping a remote Liferay server is not supported.");
    }

    public void dispose() {
        super.dispose();
        this.remoteServerUpdateJob.cancel();
        this.remoteServerUpdateJob = null;
    }

    public int getRemoteServerState(int currentServerState, IProgressMonitor monitor) {
        String serverState;
        block9: {
            String retval;
            block8: {
                try {
                    if (currentServerState == 4) {
                        monitor.beginTask("Updating server state for " + this.getServer().getName(), 100);
                    }
                    retval = null;
                    IRemoteConnection remoteConnection = this.getRemoteConnection();
                    try {
                        retval = remoteConnection.getServerState();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (retval != null) break block8;
                    this.setServerStatus(LiferayServerCorePlugin.createErrorStatus("Check connection settings."));
                    return 0;
                }
                catch (Exception e) {
                    LiferayServerCorePlugin.logError("Could not get server state.", e);
                    return 0;
                }
            }
            serverState = retval.toString();
            if (!"STARTED".equals(serverState)) break block9;
            return 2;
        }
        if ("STOPPED".equals(serverState)) {
            return 4;
        }
        return 0;
    }

    public void redeployModule(IModule[] module) {
        this.setModulePublishState(module, 3);
        IAdaptable info = new IAdaptable(){

            public Object getAdapter(Class adapter) {
                if (String.class.equals((Object)adapter)) {
                    return "user";
                }
                return null;
            }
        };
        this.getServer().publish(2, null, info, null);
    }

    public void serverAdded(IServer server) {
    }

    public void serverChanged(IServer server) {
    }

    public void serverRemoved(IServer server) {
        if (server.equals(this.getServer()) && this.currentLaunch != null && !this.currentLaunch.isTerminated()) {
            try {
                this.currentLaunch.terminate();
            }
            catch (DebugException debugException) {}
        }
        ServerCore.removeServerLifecycleListener((IServerLifecycleListener)this);
    }

    public void stop(boolean force) {
        this.setServerState(4);
    }

    protected Job checkRemoteServerState(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!this.getServer().equals(ServerCore.findServer((String)this.getServer().getId()))) {
            this.remoteServerUpdateJob = null;
            return null;
        }
        final int state = this.getServer().getServerState();
        Job updateServerJob = null;
        switch (state) {
            case 0: {
                if (!this.canConnect()) break;
                updateServerJob = new Job("Updating status for " + this.getServer().getName()){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            return RemoteServerBehavior.this.updateServerState(state, monitor);
                        }
                        catch (Exception e) {
                            LiferayServerCorePlugin.logError(e);
                            return Status.OK_STATUS;
                        }
                    }
                };
                break;
            }
            case 4: {
                if (!this.canConnect()) break;
                updateServerJob = new Job("Connecting to " + this.getServer().getName()){

                    protected IStatus run(IProgressMonitor monitor) {
                        int wasState = RemoteServerBehavior.this.getRemoteServerState(state, monitor);
                        if (wasState == 2) {
                            RemoteServerBehavior.this.setServerState(2);
                            RemoteServerBehavior.this.launchServer(monitor);
                        }
                        return Status.OK_STATUS;
                    }
                };
                break;
            }
            case 2: {
                boolean isAlive = false;
                try {
                    isAlive = this.getRemoteConnection().isAlive();
                }
                catch (Exception exception) {}
                if (isAlive && (this.currentLaunch == null || this.currentLaunch.isTerminated())) {
                    updateServerJob = new Job("Connecting to server: " + this.getServer().getName()){

                        protected IStatus run(IProgressMonitor monitor) {
                            RemoteServerBehavior.this.launchServer(monitor);
                            return Status.OK_STATUS;
                        }
                    };
                    break;
                }
                if (isAlive) break;
                this.terminateLaunch();
                this.setServerState(4);
                break;
            }
            case 1: 
            case 3: {
                break;
            }
        }
        return updateServerJob;
    }

    protected Job createRemoteServerUpdateJob() {
        return new Job("Remote server update."){

            protected IStatus run(IProgressMonitor monitor) {
                Job updateServerJob = RemoteServerBehavior.this.checkRemoteServerState(monitor);
                if (updateServerJob != null) {
                    updateServerJob.schedule();
                    try {
                        updateServerJob.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (RemoteServerBehavior.this.remoteServerUpdateJob != null) {
                    RemoteServerBehavior.this.remoteServerUpdateJob.schedule(RemoteServerBehavior.this.getRemoteServerUpdateDelay());
                }
                return Status.OK_STATUS;
            }
        };
    }

    protected IRemoteConnection getRemoteConnection() {
        if (this.remoteConnection == null) {
            this.remoteConnection = LiferayServerCorePlugin.getRemoteConnection(this.getRemoteServer());
        }
        return this.remoteConnection;
    }

    protected IRemoteServer getRemoteServer() {
        return RemoteUtil.getRemoteServer(this.getServer());
    }

    protected long getRemoteServerUpdateDelay() {
        return 5000L;
    }

    protected void initialize(IProgressMonitor monitor) {
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)this);
        this.remoteServerUpdateJob = this.createRemoteServerUpdateJob();
        this.remoteServerUpdateJob.setSystem(true);
        this.remoteServerUpdateJob.schedule();
    }

    protected boolean isModuleInstalled(IModule[] module) {
        IModule[] iModuleArray = module;
        int n = module.length;
        int n2 = 0;
        while (n2 < n) {
            IModule m = iModuleArray[n2];
            String appName = m.getProject().getName();
            if (this.getRemoteConnection().isAppInstalled(appName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void launchServer(IProgressMonitor monitor) {
        if (this.currentLaunch != null && !this.currentLaunch.isTerminated()) {
            this.terminateLaunch();
        }
        ILaunchConfigurationWorkingCopy config = null;
        String launchMode = null;
        try {
            config = this.getServer().getLaunchConfiguration(true, null).getWorkingCopy();
            IRemoteConnection remoteConnection = this.getRemoteConnection();
            Integer debugPort = remoteConnection.getDebugPort();
            if (debugPort > 0) {
                HashMap<String, String> connectMap = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, null);
                if (connectMap == null) {
                    connectMap = new HashMap<String, String>();
                    config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, connectMap);
                }
                connectMap.put("hostname", this.getServer().getHost());
                connectMap.put("port", debugPort.toString());
                launchMode = "debug";
            } else {
                launchMode = "run";
            }
            try {
                this.currentLaunch = config.launch(launchMode, null);
            }
            catch (CoreException coreException) {
                if (debugPort > 0) {
                    ServerUtil.terminateLaunchesForConfig(config);
                }
                try {
                    this.currentLaunch = config.launch("run", null);
                }
                catch (CoreException coreException2) {
                    ServerUtil.terminateLaunchesForConfig(config);
                }
            }
        }
        catch (Exception e) {
            LiferayServerCorePlugin.logError("Could not create new server launch configuration.", e);
        }
    }

    protected void publishFinish(IProgressMonitor monitor) throws CoreException {
        super.publishFinish(monitor);
        this.setServerPublishState(1);
    }

    protected void publishModule(int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        boolean shouldPublishModule = LiferayPublishHelper.prePublishModule(this, kind, deltaKind, module, this.getPublishedResourceDelta(module), monitor);
        if (!shouldPublishModule) {
            return;
        }
        int modulePublishState = -1;
        if (kind == 2 && (deltaKind == 1 || deltaKind == 2)) {
            modulePublishState = this.publishModuleFull(module, deltaKind, monitor);
        } else if (kind == 2 && deltaKind == 0) {
            if (!this.isModuleInstalled(module)) {
                modulePublishState = this.publishModuleFull(module, deltaKind, monitor);
            }
        } else if (kind == 2 && deltaKind == 3) {
            modulePublishState = this.removeModule(module, monitor);
        } else if ((kind == 3 || kind == 1) && deltaKind == 2) {
            modulePublishState = this.publishModuleDelta(module, monitor);
        }
        this.setModulePublishState(module, modulePublishState);
    }

    protected int publishModuleDelta(IModule[] module, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IProject moduleProject = module[0].getProject();
        IModuleResourceDelta[] delta = this.getPublishedResourceDelta(module);
        if (this.shouldPublishModuleFull(delta)) {
            return this.publishModuleFull(module, 2, monitor);
        }
        String appName = moduleProject.getName();
        monitor.subTask("Creating partial " + moduleProject.getName() + " update archive...");
        File partialWar = ServerUtil.createPartialWAR(String.valueOf(appName) + ".war", delta, "liferay", true);
        monitor.worked(25);
        if (monitor != null && monitor.isCanceled()) {
            return 0;
        }
        monitor.subTask("Getting Liferay connection...");
        IRemoteConnection connection = this.getRemoteConnection();
        monitor.subTask("Updating " + moduleProject.getName() + " on Liferay...");
        Object error = connection.updateApplication(appName, partialWar.getAbsolutePath(), monitor);
        monitor.worked(90);
        if (error != null) {
            throw new CoreException(LiferayServerCorePlugin.createErrorStatus(error.toString()));
        }
        monitor.done();
        return 1;
    }

    protected int publishModuleFull(IModule[] module, int deltaKind, IProgressMonitor monitor) throws CoreException {
        if (module == null || module.length != 1) {
            throw new CoreException(LiferayServerCorePlugin.createErrorStatus("Cannot publish module with length " + (module != null ? module.length : 0)));
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IModule publishModule = module[0];
        IProject moduleProject = publishModule.getProject();
        IProgressMonitor submon = CoreUtil.newSubMonitor((IProgressMonitor)monitor, (int)100);
        submon.subTask("Deploying " + moduleProject.getName() + "  to Liferay...");
        SDK sdk = SDKUtil.getSDK((IProject)moduleProject);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("auto.deploy.unpack.war", "false");
        IPath deployPath = LiferayServerCorePlugin.getTempLocation("direct-deploy", "");
        properties.put("app.server.deploy.dir", deployPath.toOSString());
        File warFile = deployPath.append(String.valueOf(moduleProject.getName()) + ".war").toFile();
        warFile.getParentFile().mkdirs();
        properties.put("plugin.file", warFile.getAbsolutePath());
        submon.worked(10);
        if (monitor.isCanceled()) {
            return 3;
        }
        submon.subTask("Deploying " + moduleProject.getName() + "...");
        Map<String, String> appServerProperties = ServerUtil.configureAppServerProperties(moduleProject);
        IStatus directDeployStatus = sdk.war(moduleProject, properties, true, appServerProperties, new String[]{"-Duser.timezone=GMT"});
        if (!directDeployStatus.isOK() || !warFile.exists()) {
            throw new CoreException(directDeployStatus);
        }
        submon.worked(15);
        if (monitor.isCanceled()) {
            return 3;
        }
        String appName = moduleProject.getName();
        IRemoteConnection remoteConnection = this.getRemoteConnection();
        this.setModuleStatus(module, LiferayServerCorePlugin.createInfoStatus("Installing..."));
        submon.worked(15);
        if (monitor.isCanceled()) {
            return 3;
        }
        submon.subTask("Publishing " + moduleProject.getName() + " to Liferay...");
        Object error = null;
        try {
            error = remoteConnection.isAppInstalled(appName) ? remoteConnection.updateApplication(appName, warFile.getAbsolutePath(), submon) : remoteConnection.installApplication(warFile.getAbsolutePath(), appName, submon);
        }
        catch (Exception ex) {
            this.setModuleStatus(module, null);
            this.setModuleState(module, 0);
            throw new CoreException(LiferayServerCorePlugin.createErrorStatus((Exception)ex));
        }
        if (error != null) {
            this.setModuleStatus(module, null);
            this.setModuleState(module, 0);
            throw new CoreException(LiferayServerCorePlugin.createErrorStatus(error.toString()));
        }
        submon.worked(40);
        this.setModuleStatus(module, LiferayServerCorePlugin.createInfoStatus("Starting..."));
        if (monitor.isCanceled()) {
            this.setModuleStatus(module, null);
            return 0;
        }
        this.setModuleStatus(module, null);
        this.setModuleState(module, 2);
        submon.worked(10);
        monitor.done();
        return 1;
    }

    protected void publishStart(IProgressMonitor monitor) throws CoreException {
        int state = this.getServer().getServerState();
        if (state != 2) {
            throw new CoreException(LiferayServerCorePlugin.createErrorStatus("Cannot publish to remote server that is not started."));
        }
    }

    protected int removeModule(IModule[] module, IProgressMonitor monitor) throws CoreException {
        IModule publishModule;
        IProject moduleProject;
        if (module == null || module.length != 1) {
            throw new CoreException(LiferayServerCorePlugin.createErrorStatus("Cannot publish module with length " + (module != null ? module.length : 0)));
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((moduleProject = (publishModule = module[0]).getProject()) == null) {
            this.setModuleStatus(module, null);
            return 0;
        }
        monitor.beginTask("Undeploying " + moduleProject.getName() + " from Liferay...", 100);
        String appName = moduleProject.getName();
        this.setModuleStatus(module, LiferayServerCorePlugin.createInfoStatus("Uninstalling..."));
        monitor.subTask("Getting remote connection...");
        IRemoteConnection remoteConnection = this.getRemoteConnection();
        monitor.worked(25);
        monitor.subTask("Uninstalling " + moduleProject.getName() + " from Liferay...");
        Object error = remoteConnection.uninstallApplication(appName, monitor);
        monitor.worked(75);
        if (error != null) {
            throw new CoreException(LiferayServerCorePlugin.createErrorStatus(error.toString()));
        }
        this.setModuleStatus(module, null);
        return 1;
    }

    protected boolean shouldPublishModuleFull(IModuleResourceDelta[] deltas) {
        boolean retval = false;
        if (!CoreUtil.isNullOrEmpty((Object[])deltas)) {
            IModuleResourceDelta[] iModuleResourceDeltaArray = deltas;
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                IModuleResourceDelta delta = iModuleResourceDeltaArray[n2];
                if (this.shouldPublishModuleFull(delta.getAffectedChildren())) {
                    retval = true;
                    break;
                }
                IModuleResource resource = delta.getModuleResource();
                if (resource.getName().equals("web.xml") || resource.getName().equals("liferay-plugin-package.properties") ? (retval = CoreUtil.isResourceInDocroot((IModuleResource)resource)) : resource.getName().equals("portlet.xml") && (retval = CoreUtil.isResourceInDocroot((IModuleResource)resource))) break;
                ++n2;
            }
        }
        return retval;
    }

    protected void terminateLaunch() {
        if (this.currentLaunch != null) {
            try {
                this.currentLaunch.terminate();
            }
            catch (DebugException debugException) {}
            this.currentLaunch = null;
        }
    }

    protected IStatus updateModuleState(IModule module) {
        String appName = module.getProject().getName();
        boolean appStarted = this.getRemoteConnection().isLiferayPluginStarted(appName);
        IModule[] module2 = new IModule[]{module};
        this.setModuleState(module2, appStarted ? 2 : 4);
        return Status.OK_STATUS;
    }

    protected IStatus updateServerState(int currentServerState, IProgressMonitor monitor) {
        if (this.getServer() == null) {
            return Status.OK_STATUS;
        }
        monitor.beginTask("Updating server status...", 100);
        int remoteState = this.getRemoteServerState(currentServerState, monitor);
        if (remoteState == 2) {
            this.setServerState(2);
            this.launchServer(monitor);
        } else if (remoteState == 4) {
            this.terminateLaunch();
            this.setServerState(4);
        }
        Object[] modules = this.getServer().getModules();
        if (!CoreUtil.isNullOrEmpty((Object[])modules)) {
            List<String> plugins = this.getRemoteConnection().getLiferayPlugins();
            Object[] objectArray = modules;
            int n = modules.length;
            int n2 = 0;
            while (n2 < n) {
                Object module = objectArray[n2];
                if (ServerUtil.isLiferayProject(module.getProject())) {
                    String appName = module.getProject().getName();
                    if (plugins.contains(appName)) {
                        this.updateModuleState((IModule)module);
                    } else {
                        this.setModuleState(new IModule[]{module}, 0);
                    }
                }
                ++n2;
            }
        }
        return Status.OK_STATUS;
    }
}

