/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.server.util;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.PropertiesConfigurationLayout;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class CustomPropertiesConfigLayout
extends PropertiesConfigurationLayout {
    private static final String ESCAPE = "\\";
    private static final char[] SEPARATORS = new char[]{'=', ':'};
    private static final char[] WHITE_SPACE = new char[]{' ', '\t', '\f'};

    public CustomPropertiesConfigLayout(PropertiesConfiguration config) {
        super(config);
    }

    public void save(Writer out) throws ConfigurationException {
        try {
            char delimiter = this.getConfiguration().isDelimiterParsingDisabled() ? (char)'\u0000' : this.getConfiguration().getListDelimiter();
            CustomPropertiesWriter writer = new CustomPropertiesWriter(out, delimiter);
            if (this.getHeaderComment() != null) {
                writer.writeln(this.getCanonicalHeaderComment(true));
                writer.writeln(null);
            }
            for (String key : this.getKeys()) {
                if (!this.getConfiguration().containsKey(key)) continue;
                int i = 0;
                while (i < this.getBlancLinesBefore(key)) {
                    writer.writeln(null);
                    ++i;
                }
                if (this.getComment(key) != null) {
                    writer.writeln(this.getCanonicalComment(key, true));
                }
                boolean singleLine = (this.isForceSingleLine() || this.isSingleLine(key)) && !this.getConfiguration().isDelimiterParsingDisabled();
                writer.writeProperty(key, this.getConfiguration().getProperty(key), singleLine);
            }
            writer.flush();
        }
        catch (IOException ioex) {
            throw new ConfigurationException((Throwable)ioex);
        }
    }

    public static class CustomPropertiesWriter
    extends PropertiesConfiguration.PropertiesWriter {
        private char delimiter;

        public CustomPropertiesWriter(Writer writer, char delimiter) {
            super(writer, delimiter);
            this.delimiter = delimiter;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void writeProperty(String key, Object value, boolean forceSingleLine) throws IOException {
            String v;
            if (value instanceof List) {
                List values = (List)value;
                if (!forceSingleLine) {
                    this.writeProperty(key, values);
                    return;
                }
                v = this.makeSingleLineValue(values);
            } else {
                v = this.escapeValue(value);
            }
            this.write(this.escapeKey(key));
            this.write("=");
            this.write(v);
            this.writeln(null);
        }

        private String escapeValue(Object value) {
            String escapedValue = StringEscapeUtils.escapeJava((String)String.valueOf(value));
            if (this.delimiter != '\u0000') {
                escapedValue = StringUtils.replace((String)escapedValue, (String)String.valueOf(this.delimiter), (String)(CustomPropertiesConfigLayout.ESCAPE + this.delimiter));
            }
            return escapedValue;
        }

        private String escapeKey(String key) {
            StringBuffer newkey = new StringBuffer();
            int i = 0;
            while (i < key.length()) {
                char c = key.charAt(i);
                if (ArrayUtils.contains((char[])SEPARATORS, (char)c) || ArrayUtils.contains((char[])WHITE_SPACE, (char)c)) {
                    newkey.append('\\');
                    newkey.append(c);
                } else {
                    newkey.append(c);
                }
                ++i;
            }
            return newkey.toString();
        }

        private String makeSingleLineValue(List values) {
            if (!values.isEmpty()) {
                Iterator it = values.iterator();
                String lastValue = this.escapeValue(it.next());
                StringBuffer buf = new StringBuffer(lastValue);
                while (it.hasNext()) {
                    if (lastValue.endsWith(CustomPropertiesConfigLayout.ESCAPE)) {
                        buf.append(CustomPropertiesConfigLayout.ESCAPE).append(CustomPropertiesConfigLayout.ESCAPE);
                    }
                    buf.append(this.delimiter);
                    lastValue = this.escapeValue(it.next());
                    buf.append(lastValue);
                }
                return buf.toString();
            }
            return null;
        }
    }
}

