/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.server.util;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.server.core.ILiferayRuntime;
import com.liferay.ide.eclipse.server.core.LiferayServerCorePlugin;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.internal.BridgedRuntime;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerUtil {
    protected static final IStatus emptyInstallDirStatus = ServerUtil.createErrorStatus("Install directory is empty.");
    protected static final IStatus installDirDoesNotExist = ServerUtil.createErrorStatus("Install directory does not exist.");
    protected static final IStatus invalidInstallDirStatus = ServerUtil.createErrorStatus("Invalid installation directory.");

    public static IStatus createErrorStatus(String msg) {
        return new Status(4, "com.liferay.ide.eclipse.server.core", msg);
    }

    public static IServerWorkingCopy createServerForRuntime(IRuntime runtime) {
        IServerType[] iServerTypeArray = ServerCore.getServerTypes();
        int n = iServerTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServerType serverType = iServerTypeArray[n2];
            if (serverType.getRuntimeType().equals(runtime.getRuntimeType())) {
                try {
                    return serverType.createServer("server", null, runtime, null);
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
        return null;
    }

    public static IPath getAppServerDir(org.eclipse.wst.common.project.facet.core.runtime.IRuntime serverRuntime) {
        ILiferayRuntime runtime = (ILiferayRuntime)ServerUtil.getRuntimeAdapter(serverRuntime, ILiferayRuntime.class);
        return runtime != null ? runtime.getAppServerDir() : null;
    }

    public static IPath getPortalDir(IJavaProject project) {
        return ServerUtil.getPortalDir(project.getProject());
    }

    public static IPath getPortalDir(IProject project) {
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = facetedProject.getPrimaryRuntime();
            if (runtime != null) {
                return ServerUtil.getPortalDir(runtime);
            }
        }
        catch (CoreException e) {
            LiferayServerCorePlugin.logError((Exception)((Object)e));
        }
        return null;
    }

    public static IPath getPortalDir(org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime) {
        ILiferayRuntime runtime = (ILiferayRuntime)ServerUtil.getRuntimeAdapter(facetRuntime, ILiferayRuntime.class);
        return runtime != null ? runtime.getPortalDir() : null;
    }

    public static ILiferayRuntime getLiferayRuntime(IProject project) throws CoreException {
        return (ILiferayRuntime)ServerUtil.getRuntimeAdapter(ProjectFacetsManager.create((IProject)project).getPrimaryRuntime(), ILiferayRuntime.class);
    }

    public static ILiferayRuntime getLiferayRuntime(IRuntime runtime) {
        if (runtime != null) {
            return (ILiferayRuntime)runtime.createWorkingCopy().loadAdapter(ILiferayRuntime.class, null);
        }
        return null;
    }

    public static ILiferayRuntime getLiferayRuntime(IServer server) {
        if (server != null) {
            return ServerUtil.getLiferayRuntime(server.getRuntime());
        }
        return null;
    }

    public static IRuntime getRuntime(IProject project) throws CoreException {
        return (IRuntime)ServerUtil.getRuntimeAdapter(ProjectFacetsManager.create((IProject)project).getPrimaryRuntime(), IRuntime.class);
    }

    public static IRuntime getRuntime(org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime) {
        return ServerCore.findRuntime((String)runtime.getProperty("id"));
    }

    public static IRuntimeWorkingCopy getRuntime(String runtimeTypeId, IPath location) {
        IRuntimeType runtimeType = ServerCore.findRuntimeType((String)runtimeTypeId);
        try {
            IRuntimeWorkingCopy runtime = runtimeType.createRuntime("runtime", null);
            IRuntimeWorkingCopy runtimeWC = runtime.createWorkingCopy();
            runtimeWC.setName("Runtime");
            runtimeWC.setLocation(location);
            return runtimeWC;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getRuntimeAdapter(org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime, Class<?> adapterClass) {
        String runtimeId = facetRuntime.getProperty("id");
        IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
        int n = iRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime runtime = iRuntimeArray[n2];
            if (runtime.getId().equals(runtimeId)) {
                if (IRuntime.class.equals(adapterClass)) {
                    return runtime;
                }
                IRuntimeWorkingCopy runtimeWC = null;
                runtimeWC = !runtime.isWorkingCopy() ? runtime.createWorkingCopy() : (IRuntimeWorkingCopy)runtime;
                return (ILiferayRuntime)runtimeWC.loadAdapter(adapterClass, null);
            }
            ++n2;
        }
        return null;
    }

    public static IServer[] getServersForRuntime(IRuntime runtime) {
        Object[] servers;
        ArrayList<Object> serverList = new ArrayList<Object>();
        if (runtime != null && !CoreUtil.isNullOrEmpty((Object[])(servers = ServerCore.getServers()))) {
            Object[] objectArray = servers;
            int n = servers.length;
            int n2 = 0;
            while (n2 < n) {
                Object server = objectArray[n2];
                if (runtime.equals(server.getRuntime())) {
                    serverList.add(server);
                }
                ++n2;
            }
        }
        return serverList.toArray(new IServer[0]);
    }

    public static boolean isExistingVMName(String name) {
        IVMInstall[] iVMInstallArray = JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType").getVMInstalls();
        int n = iVMInstallArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstall vm = iVMInstallArray[n2];
            if (vm.getName().equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isLiferayRuntime(BridgedRuntime bridgedRuntime) {
        String id;
        if (bridgedRuntime != null && (id = bridgedRuntime.getProperty("id")) != null) {
            IRuntime runtime = ServerCore.findRuntime((String)id);
            return ServerUtil.isLiferayRuntime(runtime);
        }
        return false;
    }

    public static boolean isLiferayRuntime(IRuntime runtime) {
        return ServerUtil.getLiferayRuntime(runtime) != null;
    }

    public static boolean isLiferayRuntime(IServer server) {
        return ServerUtil.getLiferayRuntime(server) != null;
    }

    public static boolean isValidPropertiesFile(File file) {
        if (file == null || !file.exists()) {
            return false;
        }
        try {
            new PropertiesConfiguration(file);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean isLiferayProject(IProject project) {
        boolean retval;
        block4: {
            retval = false;
            if (project == null) {
                return retval;
            }
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                if (facetedProject == null) break block4;
                for (IProjectFacetVersion facet : facetedProject.getProjectFacets()) {
                    IProjectFacet projectFacet = facet.getProjectFacet();
                    if (!projectFacet.getId().startsWith("liferay")) continue;
                    retval = true;
                    break;
                }
            }
            catch (Exception exception) {}
        }
        return retval;
    }

    public static boolean isExtProject(IProject project) {
        return ServerUtil.hasFacet(project, ProjectFacetsManager.getProjectFacet((String)"liferay.ext"));
    }

    public static boolean hasFacet(IProject project, IProjectFacet checkProjectFacet) {
        boolean retval;
        block4: {
            retval = false;
            if (project == null || checkProjectFacet == null) {
                return retval;
            }
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                if (facetedProject == null || checkProjectFacet == null) break block4;
                for (IProjectFacetVersion facet : facetedProject.getProjectFacets()) {
                    IProjectFacet projectFacet = facet.getProjectFacet();
                    if (!checkProjectFacet.equals(projectFacet)) continue;
                    retval = true;
                    break;
                }
            }
            catch (CoreException coreException) {}
        }
        return retval;
    }

    public static void terminateLaunchesForConfig(ILaunchConfigurationWorkingCopy config) throws DebugException {
        ILaunch[] launches;
        ILaunch[] iLaunchArray = launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (launch.getLaunchConfiguration().equals(config)) {
                launch.terminate();
            }
            ++n2;
        }
    }

    public static IFacetedProject getFacetedProject(IProject project) {
        try {
            return ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static IProjectFacet getLiferayFacet(IFacetedProject facetedProject) {
        for (IProjectFacetVersion projectFacet : facetedProject.getProjectFacets()) {
            if (!ServerUtil.isLiferayFacet(projectFacet.getProjectFacet())) continue;
            return projectFacet.getProjectFacet();
        }
        return null;
    }

    public static boolean isLiferayFacet(IProjectFacet projectFacet) {
        return projectFacet != null && projectFacet.getId().startsWith("liferay");
    }

    public static Map<String, String> configureAppServerProperties(ILiferayRuntime appServer) {
        HashMap<String, String> properties = new HashMap<String, String>();
        String type = appServer.getAppServerType();
        String dir = appServer.getAppServerDir().toOSString();
        String deployDir = appServer.getDeployDir().toOSString();
        String libGlobalDir = appServer.getLibGlobalDir().toOSString();
        String portalDir = appServer.getPortalDir().toOSString();
        properties.put("app.server.type", type);
        properties.put("app.server.dir", dir);
        properties.put("app.server.deploy.dir", deployDir);
        properties.put("app.server.lib.global.dir", libGlobalDir);
        properties.put("app.server.portal.dir", portalDir);
        return properties;
    }

    public static Map<String, String> configureAppServerProperties(IProject project) throws CoreException {
        ILiferayRuntime runtime = null;
        try {
            runtime = ServerUtil.getLiferayRuntime(project);
        }
        catch (CoreException e1) {
            throw new CoreException(LiferayServerCorePlugin.createErrorStatus((Exception)((Object)e1)));
        }
        return ServerUtil.configureAppServerProperties(runtime);
    }

    private static void processResourceDeltasZip(IModuleResourceDelta[] deltas, ZipOutputStream zip, Map<ZipEntry, String> deleteEntries, String deletePrefix, String deltaPrefix, boolean adjustGMTOffset) throws IOException, CoreException {
        IModuleResourceDelta[] iModuleResourceDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleResourceDelta delta = iModuleResourceDeltaArray[n2];
            int deltaKind = delta.getKind();
            IResource deltaResource = (IResource)delta.getModuleResource().getAdapter(IResource.class);
            IProject deltaProject = deltaResource.getProject();
            IFolder docroot = CoreUtil.getDocroot((IProject)deltaProject);
            Path deltaPath = new Path(String.valueOf(deltaPrefix) + deltaResource.getFullPath().makeRelativeTo(docroot.getFullPath()));
            if (deltaKind == 1 || deltaKind == 2) {
                ServerUtil.addToZip((IPath)deltaPath, deltaResource, zip, adjustGMTOffset);
            } else if (deltaKind == 3) {
                ServerUtil.addRemoveProps((IPath)deltaPath, deltaResource, zip, deleteEntries, deletePrefix);
            } else if (deltaKind == 0) {
                IModuleResourceDelta[] children = delta.getAffectedChildren();
                ServerUtil.processResourceDeltasZip(children, zip, deleteEntries, deletePrefix, deltaPrefix, adjustGMTOffset);
            }
            ++n2;
        }
    }

    private static String removeArchive(String archive) {
        int index = Math.max(archive.lastIndexOf(".war"), archive.lastIndexOf(".jar"));
        if (index >= 0) {
            return archive.substring(0, index + 5);
        }
        return "";
    }

    private static void addRemoveProps(IPath deltaPath, IResource deltaResource, ZipOutputStream zip, Map<ZipEntry, String> deleteEntries, String deletePrefix) throws IOException {
        String archive = ServerUtil.removeArchive(deltaPath.toPortableString());
        ZipEntry zipEntry = null;
        for (ZipEntry entry : deleteEntries.keySet()) {
            if (!entry.getName().startsWith(archive)) continue;
            zipEntry = entry;
        }
        if (zipEntry == null) {
            zipEntry = new ZipEntry(String.valueOf(archive) + "META-INF/" + deletePrefix + "-partialapp-delete.props");
        }
        String existingFiles = deleteEntries.get(zipEntry);
        String file = deltaPath.toPortableString().substring(archive.length());
        if (deltaResource.getType() == 2) {
            file = String.valueOf(file) + "/.*";
        }
        deleteEntries.put(zipEntry, String.valueOf(existingFiles != null ? existingFiles : "") + file + "\n");
    }

    private static void addToZip(IPath path, IResource resource, ZipOutputStream zip, boolean adjustGMTOffset) throws IOException, CoreException {
        switch (resource.getType()) {
            case 1: {
                ZipEntry zipEntry = new ZipEntry(path.toString());
                zip.putNextEntry(zipEntry);
                InputStream contents = ((IFile)resource).getContents();
                if (adjustGMTOffset) {
                    TimeZone currentTimeZone = TimeZone.getDefault();
                    GregorianCalendar currentDt = new GregorianCalendar(currentTimeZone, Locale.getDefault());
                    int gmtOffset = currentTimeZone.getOffset(currentDt.get(0), currentDt.get(1), currentDt.get(2), currentDt.get(5), currentDt.get(7), currentDt.get(14));
                    zipEntry.setTime(System.currentTimeMillis() + (long)(gmtOffset * -1));
                }
                try {
                    IOUtils.copy((InputStream)contents, (OutputStream)zip);
                    break;
                }
                finally {
                    contents.close();
                }
            }
            case 2: 
            case 4: {
                IResource[] members;
                IContainer container = (IContainer)resource;
                IResource[] iResourceArray = members = container.members();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource res = iResourceArray[n2];
                    ServerUtil.addToZip(path.append(res.getName()), res, zip, adjustGMTOffset);
                    ++n2;
                }
                break;
            }
        }
    }

    public static File createPartialEAR(String archiveName, IModuleResourceDelta[] deltas, String deletePrefix, String deltaPrefix, boolean adjustGMTOffset) {
        File file;
        block15: {
            IPath path = LiferayServerCorePlugin.getTempLocation("partial-ear", archiveName);
            FileOutputStream outputStream = null;
            ZipOutputStream zip = null;
            file = path.toFile();
            file.getParentFile().mkdirs();
            try {
                try {
                    outputStream = new FileOutputStream(file);
                    zip = new ZipOutputStream(outputStream);
                    HashMap<ZipEntry, String> deleteEntries = new HashMap<ZipEntry, String>();
                    ServerUtil.processResourceDeltasZip(deltas, zip, deleteEntries, deletePrefix, deltaPrefix, adjustGMTOffset);
                    for (ZipEntry entry : deleteEntries.keySet()) {
                        zip.putNextEntry(entry);
                        zip.write(((String)deleteEntries.get(entry)).getBytes());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (zip != null) {
                        try {
                            zip.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException iOException) {}
            }
        }
        return file;
    }

    public static File createPartialWAR(String archiveName, IModuleResourceDelta[] deltas, String deletePrefix, boolean adjustGMTOffset) {
        File file;
        block15: {
            IPath path = LiferayServerCorePlugin.getTempLocation("partial-war", archiveName);
            FileOutputStream outputStream = null;
            ZipOutputStream zip = null;
            file = path.toFile();
            file.getParentFile().mkdirs();
            try {
                try {
                    outputStream = new FileOutputStream(file);
                    zip = new ZipOutputStream(outputStream);
                    HashMap<ZipEntry, String> deleteEntries = new HashMap<ZipEntry, String>();
                    ServerUtil.processResourceDeltasZip(deltas, zip, deleteEntries, deletePrefix, "", adjustGMTOffset);
                    for (ZipEntry entry : deleteEntries.keySet()) {
                        zip.putNextEntry(entry);
                        zip.write(((String)deleteEntries.get(entry)).getBytes());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (zip != null) {
                        try {
                            zip.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException iOException) {}
            }
        }
        return file;
    }
}

