/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.project.core;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.core.util.NodeUtil;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationEvent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseValidator
extends AbstractValidator {
    protected IPreferencesService fPreferencesService = Platform.getPreferencesService();

    public boolean shouldClearMarkers(ValidationEvent event) {
        return true;
    }

    protected Map<String, Object> checkClass(IJavaProject javaProject, Node classSpecifier, String preferenceNodeQualifier, IScopeContext[] preferenceScopes, String preferenceKey, String errorMessage) {
        String className = NodeUtil.getTextContent((Node)classSpecifier);
        if (className != null && className.length() > 0) {
            IType type = null;
            try {
                type = javaProject.findType(className);
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
            if (type == null || !type.exists()) {
                String msg = MessageFormat.format(errorMessage, className);
                return this.createMarkerValues(preferenceNodeQualifier, preferenceScopes, preferenceKey, (IDOMNode)classSpecifier, msg);
            }
        }
        return null;
    }

    protected Map<String, Object> checkClassResource(IJavaProject javaProject, Node classResourceSpecifier, String preferenceNodeQualifier, IScopeContext[] preferenceScopes, String preferenceKey, String errorMessage) {
        return this.checkClassResource(javaProject, classResourceSpecifier, preferenceNodeQualifier, preferenceScopes, preferenceKey, errorMessage, false);
    }

    protected Map<String, Object> checkClassResource(IJavaProject javaProject, Node classResourceSpecifier, String preferenceNodeQualifier, IScopeContext[] preferenceScopes, String preferenceKey, String errorMessage, boolean warnPropertiesSuffix) {
        String classResource = NodeUtil.getTextContent((Node)classResourceSpecifier);
        if (classResource != null && classResource.length() > 0) {
            if (classResource.endsWith(".properties") && warnPropertiesSuffix) {
                String msg = MessageFormat.format("The class resource {0} should not end with .properties", classResource);
                return this.createMarkerValues(preferenceNodeQualifier, preferenceScopes, preferenceKey, (IDOMNode)classResourceSpecifier, msg);
            }
            try {
                IClasspathEntry[] classpathEntries = javaProject.getResolvedClasspath(true);
                IResource classResourceValue = null;
                IClasspathEntry[] iClasspathEntryArray = classpathEntries;
                int n = classpathEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 3) {
                        IPath entryPath = entry.getPath();
                        IPath classResourcePath = entryPath.append(classResource);
                        classResourceValue = javaProject.getJavaModel().getWorkspace().getRoot().findMember(classResourcePath);
                        if (classResourceValue != null) break;
                        IPath qualifiedResourcePath = entryPath.append(classResource.replaceAll("\\.", "/"));
                        classResourceValue = javaProject.getJavaModel().getWorkspace().getRoot().findMember(qualifiedResourcePath);
                        if (classResourceValue != null) break;
                        String resourceName = classResourcePath.lastSegment();
                        if (classResourceValue == null && classResourcePath.segmentCount() > 0) {
                            IPath parent = classResourcePath.removeLastSegments(1);
                            IPath propertiesClassResourcePath = parent.append(String.valueOf(resourceName) + ".properties");
                            classResourceValue = javaProject.getJavaModel().getWorkspace().getRoot().findMember(propertiesClassResourcePath);
                            if (classResourceValue != null) break;
                            propertiesClassResourcePath = parent.append(String.valueOf(resourceName.replaceAll("\\.", "/")) + ".properties");
                            classResourceValue = javaProject.getJavaModel().getWorkspace().getRoot().findMember(propertiesClassResourcePath);
                            if (classResourceValue != null) break;
                        }
                    }
                    ++n2;
                }
                if (classResourceValue == null) {
                    String msg = MessageFormat.format(errorMessage, classResource);
                    return this.createMarkerValues(preferenceNodeQualifier, preferenceScopes, preferenceKey, (IDOMNode)classResourceSpecifier, msg);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    protected void checkDocrootElement(IDOMDocument document, String element, IProject project, String preferenceNodeQualifier, IScopeContext[] preferenceScopes, String validationKey, String messageKey, List<Map<String, Object>> problems) {
        NodeList elements = document.getElementsByTagName(element);
        int i = 0;
        while (i < elements.getLength()) {
            Node item = elements.item(i);
            Map<String, Object> problem = this.checkDocrootResource(item, project, preferenceNodeQualifier, preferenceScopes, validationKey, messageKey);
            if (problem != null) {
                problems.add(problem);
            }
            ++i;
        }
    }

    protected Map<String, Object> checkDocrootResource(Node docrootResourceSpecifier, IProject project, String preferenceNodeQualifier, IScopeContext[] preferenceScopes, String preferenceKey, String errorMessage) {
        IFolder docroot;
        IResource docrootResourceValue;
        String docrootResource = NodeUtil.getTextContent((Node)docrootResourceSpecifier);
        if (docrootResource != null && docrootResource.length() > 0 && (docrootResourceValue = (docroot = CoreUtil.getDocroot((IProject)project)).findMember((IPath)new Path(docrootResource))) == null) {
            String msg = MessageFormat.format(errorMessage, docrootResource);
            return this.createMarkerValues(preferenceNodeQualifier, preferenceScopes, preferenceKey, (IDOMNode)docrootResourceSpecifier, msg);
        }
        return null;
    }

    protected Map<String, Object> createMarkerValues(String qualifier, IScopeContext[] preferenceScopes, String preferenceKey, IDOMNode domNode, String message) {
        Integer severity = this.getMessageSeverity(qualifier, preferenceScopes, preferenceKey);
        if (severity == null) {
            return null;
        }
        HashMap<String, Object> markerValues = new HashMap<String, Object>();
        markerValues.put("severity", severity);
        int start = domNode.getStartOffset();
        if (domNode.getStartStructuredDocumentRegion() != null && domNode.getEndStructuredDocumentRegion() != null) {
            start = domNode.getStartStructuredDocumentRegion().getEndOffset();
        }
        int end = domNode.getEndOffset();
        if (domNode.getStartStructuredDocumentRegion() != null && domNode.getEndStructuredDocumentRegion() != null) {
            end = domNode.getEndStructuredDocumentRegion().getStartOffset();
        }
        int line = domNode.getStructuredDocument().getLineOfOffset(start);
        markerValues.put("charStart", new Integer(start));
        markerValues.put("charEnd", new Integer(end));
        markerValues.put("lineNumber", new Integer(line + 1));
        markerValues.put("message", message);
        return markerValues;
    }

    protected Integer getMessageSeverity(String qualifier, IScopeContext[] preferenceScopes, String key) {
        int sev = this.fPreferencesService.getInt(qualifier, key, 2, preferenceScopes);
        switch (sev) {
            case 1: {
                return new Integer(2);
            }
            case 2: {
                return new Integer(1);
            }
            case 3: {
                return new Integer(0);
            }
            case -1: {
                return null;
            }
        }
        return new Integer(1);
    }
}

