/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.project.core;

import com.liferay.ide.eclipse.project.core.ILiferayProjectImportDataModelProperties;
import com.liferay.ide.eclipse.project.core.ProjectCorePlugin;
import com.liferay.ide.eclipse.project.core.ProjectRecord;
import com.liferay.ide.eclipse.project.core.util.ProjectUtil;
import com.liferay.ide.eclipse.sdk.SDK;
import com.liferay.ide.eclipse.sdk.SDKManager;
import com.liferay.ide.eclipse.sdk.util.SDKUtil;
import java.io.File;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class LiferayProjectImportOperation
extends AbstractDataModelOperation
implements ILiferayProjectImportDataModelProperties {
    public LiferayProjectImportOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ProjectRecord projectRecord = (ProjectRecord)this.getDataModel().getProperty("ILiferayProjectImportDataModelProperties.PROJECT_RECORD");
        if (projectRecord == null) {
            return ProjectCorePlugin.createErrorStatus((String)"Project record to import is null.");
        }
        File projectDir = projectRecord.getProjectLocation().toFile();
        SDK sdk = SDKUtil.getSDKFromProjectDir((File)projectDir);
        if (sdk != null && !SDKManager.getInstance().containsSDK(sdk)) {
            SDKManager.getInstance().addSDK(sdk);
        }
        IRuntime runtime = (IRuntime)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        try {
            ProjectUtil.importProject(projectRecord, runtime, sdk.getLocation().toOSString(), monitor);
        }
        catch (CoreException e) {
            return ProjectCorePlugin.createErrorStatus((Exception)((Object)e));
        }
        return Status.OK_STATUS;
    }
}

