/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.project.core;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.project.core.PluginClasspathContainerInitializer;
import com.liferay.ide.eclipse.project.core.ProjectCorePlugin;
import com.liferay.ide.eclipse.project.core.util.ProjectUtil;
import com.liferay.ide.eclipse.server.util.ServerUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jst.common.jdt.internal.classpath.FlexibleProjectContainer;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathContainerUtils;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.operation.AddReferenceDataModelProvider;
import org.eclipse.wst.common.componentcore.internal.operation.RemoveReferenceDataModelProvider;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginPackageResourceListener
implements IResourceChangeListener,
IResourceDeltaVisitor {
    public static boolean isLiferayProject(IProject project) {
        boolean retval;
        block3: {
            retval = false;
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                if (facetedProject == null) break block3;
                for (IProjectFacetVersion facet : facetedProject.getProjectFacets()) {
                    IProjectFacet projectFacet = facet.getProjectFacet();
                    if (!projectFacet.getId().startsWith("liferay.")) continue;
                    retval = true;
                    break;
                }
            }
            catch (CoreException coreException) {}
        }
        return retval;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event == null) {
            return;
        }
        try {
            event.getDelta().accept((IResourceDeltaVisitor)this);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected boolean shouldProcessResourceChangedEvent(IResourceChangeEvent event) {
        if (event == null) {
            return false;
        }
        IResourceDelta delta = event.getDelta();
        int deltaKind = delta.getKind();
        return deltaKind != 2 && deltaKind != 16;
    }

    protected boolean shouldProcessResourceDelta(IResourceDelta delta) {
        IPath fullPath = delta.getFullPath();
        if (fullPath.lastSegment() != null && fullPath.lastSegment().equals("liferay-plugin-package.properties")) {
            IFolder docroot = CoreUtil.getDocroot((IProject)delta.getResource().getProject());
            if (docroot == null) {
                return false;
            }
            IPath filePath = docroot.getFile("WEB-INF/liferay-plugin-package.properties").getFullPath();
            if (filePath.equals((Object)fullPath)) {
                return true;
            }
        }
        return false;
    }

    private IFile getWorkspaceFile(IPath path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFile(path);
        if (!file.exists()) {
            file = root.getFileForLocation(path);
        }
        return file;
    }

    protected void addVirtualRef(IVirtualComponent rootComponent, IVirtualReference ref) throws CoreException {
        this.processVirtualRef(rootComponent, ref, (IDataModelProvider)new AddReferenceDataModelProvider());
    }

    protected boolean isLiferayPluginProject(IPath deltaPath) {
        IFile pluginPackagePropertiesFile = this.getWorkspaceFile(deltaPath);
        if (pluginPackagePropertiesFile != null && pluginPackagePropertiesFile.exists()) {
            return PluginPackageResourceListener.isLiferayProject(pluginPackagePropertiesFile.getProject());
        }
        return false;
    }

    protected IVirtualReference processContext(IVirtualComponent rootComponent, String context) {
        IFile serviceJar = ProjectUtil.findServiceJarForContext(context);
        if (serviceJar == null) {
            return null;
        }
        IPath serviceJarPath = serviceJar.getFullPath();
        if (rootComponent == null) {
            return null;
        }
        String type = "lib/";
        IVirtualComponent archive = ComponentCore.createArchiveComponent((IProject)rootComponent.getProject(), (String)(String.valueOf(type) + serviceJarPath.makeRelative().toString()));
        IVirtualReference ref = ComponentCore.createReference((IVirtualComponent)rootComponent, (IVirtualComponent)archive, (IPath)new Path("WEB-INF/lib").makeAbsolute());
        ref.setArchiveName(serviceJarPath.lastSegment());
        return ref;
    }

    protected void processPortalDependencyTlds(Properties props, IProject project) {
        String portalDependencyTlds = props.getProperty("portal-dependency-tlds");
        if (portalDependencyTlds != null) {
            String[] portalTlds = portalDependencyTlds.split(",");
            IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
            if (comp != null) {
                IFolder webroot = (IFolder)comp.getRootFolder().getUnderlyingFolder();
                final IFolder tldFolder = webroot.getFolder("WEB-INF/tld");
                IPath portalDir = ServerUtil.getPortalDir((IProject)project);
                final ArrayList<IPath> tldFilesToCopy = new ArrayList<IPath>();
                String[] stringArray = portalTlds;
                int n = portalTlds.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath realPortalTld;
                    String portalTld = stringArray[n2];
                    IFile tldFile = tldFolder.getFile(portalTld);
                    if (!tldFile.exists() && (realPortalTld = portalDir.append("WEB-INF/tld/" + portalTld)).toFile().exists()) {
                        tldFilesToCopy.add(realPortalTld);
                    }
                    ++n2;
                }
                if (tldFilesToCopy.size() > 0) {
                    new WorkspaceJob("copy portal tlds"){

                        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                            CoreUtil.prepareFolder((IFolder)tldFolder);
                            for (IPath tldFileToCopy : tldFilesToCopy) {
                                IFile newTldFile = tldFolder.getFile(tldFileToCopy.lastSegment());
                                try {
                                    newTldFile.create((InputStream)new FileInputStream(tldFileToCopy.toFile()), true, null);
                                }
                                catch (FileNotFoundException e) {
                                    throw new CoreException(ProjectCorePlugin.createErrorStatus((Exception)e));
                                }
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            }
        }
    }

    protected void processRequiredDeploymentContexts(Properties props, IProject project) {
        Object[] contexts;
        IVirtualReference ref;
        IClasspathEntry[] existingEntries;
        final IVirtualComponent rootComponent = ComponentCore.createComponent((IProject)project);
        if (rootComponent == null) {
            return;
        }
        final ArrayList<IVirtualReference> removeRefs = new ArrayList<IVirtualReference>();
        FlexibleProjectContainer webAppLibrariesContainer = J2EEComponentClasspathContainerUtils.getInstalledWebAppLibrariesContainer((IProject)project);
        if (webAppLibrariesContainer == null) {
            return;
        }
        IClasspathEntry[] iClasspathEntryArray = existingEntries = webAppLibrariesContainer.getClasspathEntries();
        int n = existingEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            IClasspathEntry entry = iClasspathEntryArray[n2];
            IPath path = entry.getPath();
            String archiveName = path.lastSegment();
            if (archiveName.endsWith("-service.jar") && (file = this.getWorkspaceFile(path)).exists() && ProjectUtil.isLiferayProject(file.getProject())) {
                IVirtualReference[] iVirtualReferenceArray = rootComponent.getReferences();
                int n3 = iVirtualReferenceArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ref = iVirtualReferenceArray[n4];
                    if (archiveName.equals(ref.getArchiveName())) {
                        removeRefs.add(ref);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        final ArrayList<IVirtualReference> addRefs = new ArrayList<IVirtualReference>();
        String requiredDeploymenContexts = props.getProperty("required-deployment-contexts");
        if (requiredDeploymenContexts != null && !CoreUtil.isNullOrEmpty((Object[])(contexts = requiredDeploymenContexts.split(",")))) {
            Object[] objectArray = contexts;
            int n5 = contexts.length;
            int n6 = 0;
            while (n6 < n5) {
                Object context = objectArray[n6];
                ref = this.processContext(rootComponent, (String)context);
                if (ref != null) {
                    addRefs.add(ref);
                }
                ++n6;
            }
        }
        new WorkspaceJob("Update virtual component."){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                PluginPackageResourceListener.this.updateVirtualComponent(rootComponent, removeRefs, addRefs);
                PluginPackageResourceListener.this.updateWebClasspathContainer(rootComponent, addRefs);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected void processResourceChanged(IResourceDelta delta) throws CoreException {
        IPath deltaPath = delta.getFullPath();
        final IFile pluginPackagePropertiesFile = this.getWorkspaceFile(deltaPath);
        new WorkspaceJob("Processing plugin package resource."){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                PluginPackageResourceListener.this.processPropertiesFile(pluginPackagePropertiesFile);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected void processPropertiesFile(IFile pluginPackagePropertiesFile) throws CoreException {
        block17: {
            IClasspathEntry[] entries;
            IProject project = pluginPackagePropertiesFile.getProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IPath containerPath = null;
            IClasspathEntry[] iClasspathEntryArray = entries = javaProject.getRawClasspath();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 5 && entry.getPath().segment(0).equals("com.liferay.ide.eclipse.server.plugin.container")) {
                    containerPath = entry.getPath();
                    break;
                }
                ++n2;
            }
            if (containerPath != null) {
                IClasspathContainer classpathContainer = JavaCore.getClasspathContainer(containerPath, (IJavaProject)javaProject);
                PluginClasspathContainerInitializer initializer = (PluginClasspathContainerInitializer)JavaCore.getClasspathContainerInitializer((String)"com.liferay.ide.eclipse.server.plugin.container");
                initializer.requestClasspathContainerUpdate(containerPath, javaProject, classpathContainer);
            }
            Properties props = new Properties();
            InputStream contents = null;
            try {
                try {
                    contents = pluginPackagePropertiesFile.getContents();
                    props.load(contents);
                    this.processPortalDependencyTlds(props, pluginPackagePropertiesFile.getProject());
                    this.processRequiredDeploymentContexts(props, pluginPackagePropertiesFile.getProject());
                }
                catch (Exception e) {
                    ProjectCorePlugin.logError((Throwable)e);
                    if (contents != null) {
                        try {
                            contents.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (contents != null) {
                    try {
                        contents.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (contents != null) {
                try {
                    contents.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void processVirtualRef(IVirtualComponent rootComponent, IVirtualReference ref, IDataModelProvider provider) throws CoreException {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)provider);
        dm.setProperty("IAddReferenceDataModelProperties.SOURCE_COMPONENT", (Object)rootComponent);
        dm.setProperty("IAddReferenceDataModelProperties.TARGET_REFERENCE_LIST", Arrays.asList(ref));
        IStatus stat = dm.validateProperty("IAddReferenceDataModelProperties.TARGET_REFERENCE_LIST");
        if (stat == null || !stat.isOK()) {
            throw new CoreException(stat);
        }
        try {
            dm.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            ProjectCorePlugin.logError((Throwable)e);
        }
    }

    protected void removeVirtualRef(IVirtualComponent rootComponent, IVirtualReference ref) throws CoreException {
        this.processVirtualRef(rootComponent, ref, (IDataModelProvider)new RemoveReferenceDataModelProvider());
    }

    protected void updateVirtualComponent(IVirtualComponent rootComponent, List<IVirtualReference> removeRefs, List<IVirtualReference> addRefs) throws CoreException {
        for (IVirtualReference ref : removeRefs) {
            this.removeVirtualRef(rootComponent, ref);
        }
        for (IVirtualReference ref : addRefs) {
            this.addVirtualRef(rootComponent, ref);
        }
    }

    protected void updateWebClasspathContainer(IVirtualComponent rootComponent, List<IVirtualReference> addRefs) throws CoreException {
        IClasspathEntry[] webappEntries;
        IProject project = rootComponent.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        FlexibleProjectContainer container = J2EEComponentClasspathContainerUtils.getInstalledWebAppLibrariesContainer((IProject)project);
        if (container == null) {
            return;
        }
        container.refresh();
        container = J2EEComponentClasspathContainerUtils.getInstalledWebAppLibrariesContainer((IProject)project);
        IClasspathEntry[] iClasspathEntryArray = webappEntries = container.getClasspathEntries();
        int n = webappEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            String archiveName = entry.getPath().lastSegment();
            for (IVirtualReference ref : addRefs) {
                if (!ref.getArchiveName().equals(archiveName)) continue;
                IFile referencedFile = (IFile)ref.getReferencedComponent().getAdapter(IFile.class);
                IProject referencedFileProject = referencedFile.getProject();
                ((ClasspathEntry)entry).sourceAttachmentPath = referencedFileProject.getFolder("docroot/WEB-INF/service").getFullPath();
            }
            ++n2;
        }
        ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)"org.eclipse.jst.j2ee.internal.web.container");
        initializer.requestClasspathContainerUpdate(container.getPath(), javaProject, (IClasspathContainer)container);
    }

    public boolean visit(final IResourceDelta delta) throws CoreException {
        switch (delta.getResource().getType()) {
            case 2: 
            case 4: 
            case 8: {
                return true;
            }
            case 1: {
                if (this.shouldProcessResourceDelta(delta)) {
                    new WorkspaceJob("Processing plugin package resource."){

                        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                            IResource resource = delta.getResource();
                            PluginPackageResourceListener.this.processPropertiesFile((IFile)resource);
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
                return false;
            }
        }
        return false;
    }
}

