/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.project.core;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class ProjectRecord {
    public IProjectDescription description;
    public File liferayProjectDir;
    public File projectSystemFile;
    boolean hasConflicts;
    int level;
    Object parent;
    IProject project;
    String projectName;

    public ProjectRecord(File file) {
        if (file.isDirectory()) {
            this.liferayProjectDir = file;
        } else {
            this.projectSystemFile = file;
        }
        this.setProjectName();
    }

    public ProjectRecord(IProject preSelectedProject) {
        this.project = preSelectedProject;
        this.setProjectName();
    }

    ProjectRecord(Object file, Object parent, int level) {
        this.parent = parent;
        this.level = level;
        this.setProjectName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProjectRecord && this.project != null) {
            return this.project.equals((Object)((ProjectRecord)obj).project);
        }
        return super.equals(obj);
    }

    public String getProjectLabel() {
        if (this.description == null) {
            return this.projectName;
        }
        String path = this.projectSystemFile != null ? this.projectSystemFile.getParent() : (this.liferayProjectDir != null ? this.liferayProjectDir.getPath() : (this.project != null ? new Path(this.project.getLocationURI().getPath()).toOSString() : ""));
        return NLS.bind((String)"{0} ({1})", (Object)this.projectName, (Object)path);
    }

    public IPath getProjectLocation() {
        if (this.projectSystemFile != null) {
            return new Path(this.projectSystemFile.getParent());
        }
        if (this.liferayProjectDir != null) {
            return new Path(this.liferayProjectDir.getPath());
        }
        if (this.project != null) {
            return this.project.getRawLocation();
        }
        return null;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public boolean hasConflicts() {
        return this.hasConflicts;
    }

    public void setHasConflicts(boolean b) {
        this.hasConflicts = b;
    }

    private boolean isDefaultLocation(IPath path) {
        if (path.segmentCount() < 2) {
            return false;
        }
        return path.removeLastSegments(2).toFile().equals(Platform.getLocation().toFile());
    }

    private void setProjectName() {
        try {
            if (this.projectName == null) {
                if (this.projectSystemFile != null) {
                    Path path = new Path(this.projectSystemFile.getPath());
                    if (this.isDefaultLocation((IPath)path)) {
                        this.projectName = path.segment(path.segmentCount() - 2);
                        this.description = IDEWorkbenchPlugin.getPluginWorkspace().newProjectDescription(this.projectName);
                    } else {
                        this.description = IDEWorkbenchPlugin.getPluginWorkspace().loadProjectDescription((IPath)path);
                        this.projectName = this.description.getName();
                    }
                } else if (this.liferayProjectDir != null) {
                    Path path = new Path(this.liferayProjectDir.getPath());
                    this.projectName = path.lastSegment();
                    this.description = IDEWorkbenchPlugin.getPluginWorkspace().newProjectDescription(this.projectName);
                } else if (this.project != null) {
                    this.projectName = this.project.getName();
                    this.description = this.project.getDescription();
                }
            }
        }
        catch (CoreException coreException) {}
    }
}

